/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.new_engine.SignalReadWriteVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.VlogHidMatch;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ReferenceHidSearchVisitor
extends RfHidVisitor {
    private static final String[] PREDEFINED_ARRAY_FUNCTIONS_STRING = new String[]{"push_back", "push_front", "insert", "delete"};
    private static final Set<String> PREDEFINED_ARRAY_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_ARRAY_FUNCTIONS_STRING));
    private static final String[] PREDEFINED_RW_QUEUE_FUNCTIONS_STRING = new String[]{"pop_back", "pop_front"};
    private static final Set<String> PREDEFINED_RW_QUEUE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_RW_QUEUE_FUNCTIONS_STRING));
    private static final String[] PREDEFINED_STRING_WRITE_FUNCTIONS_STRING = new String[]{"itoa", "hextoa", "octtoa", "bintoa", "realtoa", "putc"};
    private static final Set<String> PREDEFINED_STRING_WRITE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_STRING_WRITE_FUNCTIONS_STRING));
    private static final String[] PREDEFINED_MAILBOX_WRITE_FUNCTIONS_STRING = new String[]{"put", "try_put"};
    private static final Set<String> PREDEFINED_MAILBOX_WRITE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_MAILBOX_WRITE_FUNCTIONS_STRING));
    public static final int BUFFER_SIZE = 524288;
    private IRfNamedElement fRfElement;
    private boolean fIsStrictVirtualFunction;
    private IProject fProject;
    private RfProject fRfProject;
    private boolean fForRefactor;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private IFile fCurrentFile;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter = 0;
    private boolean fIncludeDeclarations;
    private boolean fIsFunctionSearch;
    private boolean fIsClassFieldOrFunctionParameterSearch;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private boolean fSemanticSearch;
    private SearchedElementWrapper fElementWrapper;
    private Map<RfFunction, LinkedHashSet<RfClass>> fFunctionClassFamily;
    private boolean fIsEnumeratedTypeRange;
    private String fSearchedString;
    private Map<IRfScopeElement, List<VlogHidMatch>> fHitBuffer = new LinkedHashMap<IRfScopeElement, List<VlogHidMatch>>();
    private IRfNamedElement fHolderScope;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public ReferenceHidSearchVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, String searchedString, boolean semanticSearch, boolean isStrictVirtualFunction, IProject project, boolean forRefactor, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, boolean includeDeclarations, IReportHitsListener<SearchHit> listener, SearchedElementWrapper elementWrapper, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElement = element;
        this.fSearchedString = searchedString;
        this.fSemanticSearch = semanticSearch;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fIsStrictVirtualFunction = isStrictVirtualFunction;
        this.fForRefactor = forRefactor;
        this.fMacroInfoMap = macroInfoMap;
        this.fCurrentFile = null;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fIsEnumeratedTypeRange = this.fRfElement instanceof RfField && (((RfField)this.fRfElement).isEnumRangeElement() || ((RfField)this.fRfElement).isEnumRangeGeneratedElement());
        this.fIsFunctionSearch = this.fRfElement instanceof RfFunction || this.fRfElement instanceof RfResultImplicitVariable;
        this.fIsClassFieldOrFunctionParameterSearch = VlogRfReferencesUtils.isClassFieldOrFunctionArgument(this.fRfElement);
        this.fElementWrapper = elementWrapper;
        this.fFunctionClassFamily = functionClassFamily;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    @Override
    public void setHolder(IHidHolder holder) {
        super.setHolder(holder);
        if (!(holder instanceof RfHidHolder)) {
            return;
        }
        RfHidHolder rfHidHolder = (RfHidHolder)holder;
        this.fHolderScope = rfHidHolder.getScope();
        if (this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement firstBufferedScope = this.fHitBuffer.keySet().iterator().next();
        if (this.isParentScope(firstBufferedScope, (IRfScopeElement)this.fHolderScope)) {
            return;
        }
        try {
            this.reportFromBuffer();
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isParentScope(IRfScopeElement parent, IRfScopeElement child) {
        while (child != parent) {
            if ((child = child.getEnclosingScope()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean visit(RfHid hid) {
        block28: {
            SearchMatchKindsWrapper searchTypeWrapper;
            block29: {
                IRfNamedElement foundElement;
                block27: {
                    block25: {
                        block26: {
                            block24: {
                                String hidName;
                                block23: {
                                    block22: {
                                        block21: {
                                            try {
                                                RfClass enclosingScope;
                                                if (this.fCheckForQueryInterruptionCounter++ == 20) {
                                                    if (this.fProgressMonitor.isCanceled()) {
                                                        throw new OperationCanceledException("Operation Canceled");
                                                    }
                                                    this.fCheckForQueryInterruptionCounter = 0;
                                                }
                                                if (!this.fListener.shouldFilterIHidObject((IHidObject)hid, (IRfClassElement)(enclosingScope = (RfClass)this.fHolderScope.getEnclosingScope(RfClass.class)))) break block21;
                                                return true;
                                            }
                                            catch (Exception e) {
                                                if (e instanceof OperationCanceledException) {
                                                    throw (OperationCanceledException)((Object)e);
                                                }
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                return false;
                                            }
                                        }
                                        if (hid.getParentAccess() == null || hid.getParentAccess().getAccessKind() != 4) break block22;
                                        return true;
                                    }
                                    hidName = hid.getName();
                                    if (hidName != null) break block23;
                                    return true;
                                }
                                foundElement = hid.getElement();
                                if (this.checkSameName(foundElement, hidName)) break block24;
                                return true;
                            }
                            searchTypeWrapper = null;
                            if (foundElement != null) break block25;
                            if (!hid.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER) || hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 2) break block26;
                            return true;
                        }
                        this.addReferenceMatch(true, hid, searchTypeWrapper);
                        return true;
                    }
                    if (!VlogRfReferencesUtils.matchesMethodArgumentForRefactoring(this.fRfElement, foundElement, this.fForRefactor)) break block27;
                    this.addReferenceMatch(false, hid, searchTypeWrapper);
                    return true;
                }
                boolean isFunctionSearch = this.fIsFunctionSearch && (foundElement instanceof RfFunction || foundElement instanceof RfResultImplicitVariable);
                boolean isClassFieldOrFunctionArgumentSearch = this.fIsClassFieldOrFunctionParameterSearch && VlogRfReferencesUtils.isClassFieldOrFunctionArgument(foundElement);
                boolean isMatch = false;
                if (isFunctionSearch && !this.fRfElement.isPredefined()) {
                    if (foundElement instanceof RfFunction) {
                        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)(hid.getParentAccess() != null ? hid.getParentAccess().getAssociatedType() : this.fHolderScope), this.fRfProject, 8);
                        LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)foundElement, this.fFunctionClassFamily);
                        searchTypeWrapper = ((RfFunction)foundElement).computeEquals(resolver, this.fRfElement, this.fResolver, classFamily);
                    }
                    if (foundElement instanceof RfResultImplicitVariable) {
                        searchTypeWrapper = ((RfResultImplicitVariable)foundElement).computeEquals(this.fRfElement);
                    }
                    if (searchTypeWrapper != null && searchTypeWrapper.getFunctionCallKind() != null) {
                        isMatch = this.fIsStrictVirtualFunction ? searchTypeWrapper.getFunctionCallKind().ordinal() == RfFunction.FunctionCallKind.STRICT.ordinal() : searchTypeWrapper.isMatch();
                    }
                } else if (isClassFieldOrFunctionArgumentSearch && !this.fRfElement.isPredefined()) {
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fHolderScope, null, (boolean)true, (ELManager)this.fRfProject.getELManager());
                    RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fHolderScope, this.fRfProject, 8);
                    resolver.resolveHidInContext((IHidObject)hid.upwardsCopy(true), guardian, false);
                    searchTypeWrapper = ((RfField)foundElement).computeEqualsForField(resolver, this.fRfElement, this.fResolver);
                    if (searchTypeWrapper != null) {
                        isMatch = searchTypeWrapper.isMatch();
                    }
                } else {
                    RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fHolderScope, this.fRfProject, 8);
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fHolderScope, null, (boolean)true, (ELManager)this.fRfProject.getELManager());
                    resolver.resolveHidInContext((IHidObject)hid.upwardsCopy(true), guardian, false);
                    isMatch = VlogRfReferencesUtils.checkEquals(foundElement, resolver, this.fRfElement, this.fResolver, this.fIsStrictVirtualFunction, this.fFunctionClassFamily);
                }
                if (!isMatch) break block28;
                if (!VlogRfReferencesUtils.skipNonStrictMatchesInSemanticSearchMode(this.fSemanticSearch, searchTypeWrapper)) break block29;
                return true;
            }
            this.addReferenceMatch(false, hid, searchTypeWrapper);
        }
        return true;
    }

    private boolean checkSameName(IRfNamedElement foundElement, String hidName) {
        boolean isEnumeratedRangeType;
        boolean bl = isEnumeratedRangeType = foundElement instanceof RfField && (((RfField)foundElement).isEnumRangeElement() || ((RfField)foundElement).isEnumRangeGeneratedElement());
        if (this.fIsEnumeratedTypeRange && isEnumeratedRangeType) {
            return hidName.startsWith(this.fSearchedString) || this.fSearchedString.startsWith(hidName);
        }
        return hidName.equals(this.fRfElement.getName());
    }

    private void addMatch(boolean isPossibleMatch, IDocument openDocument, RfHid hid, SearchMatchKindsWrapper searchKindWrapper) throws Exception {
        this.computeReadersWritersHits(isPossibleMatch, openDocument, hid, searchKindWrapper);
    }

    private void computeReadersWritersHits(boolean isPossibleMatch, IDocument openDocument, RfHid hid, SearchMatchKindsWrapper searchKindWrapper) {
        List<VlogHidMatch> scopeHits = this.fHitBuffer.get(this.fHolderScope);
        if (scopeHits == null) {
            scopeHits = new ArrayList<VlogHidMatch>();
            this.fHitBuffer.put((IRfScopeElement)this.fHolderScope, scopeHits);
        }
        scopeHits.add(new VlogHidMatch(isPossibleMatch, openDocument, hid, searchKindWrapper, this.parserPath, this.fRfElement));
    }

    private void reportOccurences(HidMatch hidMatch, IRfScopeElement topScope) throws Exception {
        HidOccurrence occurence;
        boolean isPossibleMatch = hidMatch.isPossibleMatch();
        IDocument openDocument = hidMatch.getOpenDocument();
        Hid hid = hidMatch.getHid();
        RfFunction.FunctionCallKind functionCallType = null;
        RfField.TypeCompatibilityMatchKind classFieldType = null;
        if (hidMatch instanceof VlogHidMatch) {
            functionCallType = ((VlogHidMatch)hidMatch).getFunctionCallType();
            classFieldType = ((VlogHidMatch)hidMatch).getClassFieldType();
        }
        if ((occurence = hid.getOccurrence()) == null) {
            return;
        }
        if (occurence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 10) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        RWKind writeAccess = hidMatch.getAccess();
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, openDocument, isPossibleMatch, functionCallType, classFieldType, occurence.getLine(), null, writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, hidMatch.getConnectedElements());
        } else {
            MacroCallHitsInfo computeMacroHit = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), hidMatch.getParserPath(), openDocument, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (computeMacroHit == null) {
                return;
            }
            if (computeMacroHit.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, openDocument, isPossibleMatch, functionCallType, classFieldType, -1, computeMacroHit.getMacroCallText(), writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, hidMatch.getConnectedElements());
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = computeMacroHit.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallparameterHit : macroCallParameterHits) {
                if (!macroCallparameterHit.getText().isEmpty() && this.addHitOccurence(false, offset = macroCallparameterHit.getOffset(), openDocument, isPossibleMatch, functionCallType, classFieldType, -1, computeMacroHit.getMacroCallText(), writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, hidMatch.getConnectedElements())) continue;
            }
        }
    }

    private void addReferenceMatch(boolean isPossibleMatch, RfHid hid, SearchMatchKindsWrapper searchKindWrapper) throws Exception {
        if (hid == null) {
            return;
        }
        if (!this.fFileManager.isSynchedFile(this.parserPath, this.fProject)) {
            return;
        }
        IDocument openDocument = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
        if (openDocument == null) {
            return;
        }
        this.addMatch(isPossibleMatch, openDocument, hid, searchKindWrapper);
    }

    private boolean addHitOccurence(boolean isNonParameterHit, int offset, IDocument openDocument, boolean isPossibleMatch, RfFunction.FunctionCallKind type, RfField.TypeCompatibilityMatchKind classFieldType, int line, String macroCallText, RWKind written, ParserPath parserPath, boolean isFromDefparam, Hid hid, IRfScopeElement topScope, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        String highlightName;
        if (line == -1) {
            line = openDocument.getLineOfOffset(offset) + 1;
        }
        IRegion info = openDocument.getLineInformation(line - 1);
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int lineOffset = openDocument.getLineOffset(line - 1);
        int matchLength = isNonParameterHit ? lineContents.trim().length() : (!this.fIncludeDeclarations ? hid.getName().length() : this.fRfElement.getName().length());
        boolean isEscaped = offset - lineOffset >= 0 && offset - lineOffset < lineContents.length() && lineContents.charAt(offset - lineOffset) == '\\';
        String string = highlightName = this.fIncludeDeclarations ? this.fRfElement.getName() : hid.getName();
        if (isEscaped) {
            ++matchLength;
        }
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        if (VlogRfReferencesUtils.shouldSkipFunctionUsage(type, this.fIncludeDeclarations, hid, this.fRfElement.getEnclosingScope(), (IRfScopeElement)this.fHolderScope)) {
            return true;
        }
        VlogSearchHit lineEntry = new VlogSearchHit(parserPath, line, offset, lineContents, matchLength, new SearchMatchKindsWrapper(type, classFieldType), isNonParameterHit, this.fElementWrapper == null ? true : this.fElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject, hid);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
        lineEntry.setConnectedElement(elements);
        int highlightOffset = offset;
        if (isEscaped) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, isPossibleMatch);
        }
        lineEntry.setIsEscaped(isEscaped);
        lineEntry.setSemanticScope(topScope);
        lineEntry.setVirtualOffset(hid == null ? -1 : hid.getVirtualOffset());
        lineEntry.setAccess(written);
        if (isFromDefparam) {
            lineEntry.setFromDefparam();
        }
        if (hid != null && hid.getParentAccess() != null) {
            lineEntry.setIsInsideHierarchicalAccess();
        }
        this.fListener.addMatch((Object)lineEntry);
        return true;
    }

    public void reportFromBuffer() throws Exception {
        if (this.fHitBuffer == null || this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement topScope = this.fHitBuffer.keySet().iterator().next();
        if (!(topScope instanceof RfNamedElement)) {
            return;
        }
        IdentityHashMap<Hid, HidMatch> rwMap = new IdentityHashMap<Hid, HidMatch>();
        this.fHitBuffer.values().forEach(x -> x.forEach(y -> {
            VlogHidMatch vlogHidMatch = rwMap.put(y.getHid(), (HidMatch)y);
        }));
        this.fHitBuffer.clear();
        RfParamsHolder paramsHolder = this.getParamsHolder();
        ((IRfNamedElement)topScope).visitHidObject((IRfSingleLangProject)this.fRfProject, (IHidVisitor)new SignalReadWriteVisitor(rwMap));
        for (HidMatch hidMatch : rwMap.values()) {
            if (VlogRfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)hidMatch.getHid().getElement()) && hidMatch.getAccess() == RWKind.NONE) {
                boolean shouldBeMarkedAsReadWrite = this.hasPredefinedOrUserDefinedReadWriteAPI(hidMatch, paramsHolder);
                if (shouldBeMarkedAsReadWrite) {
                    hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
                    hidMatch.addWriteOccurence(hidMatch.getHid().getOccurrence());
                } else {
                    boolean shouldBeMarkedAsWrite = this.hasPredefinedOrUserDefinedWriteAPI(hidMatch, paramsHolder);
                    if (shouldBeMarkedAsWrite) {
                        hidMatch.addWriteOccurence(hidMatch.getHid().getOccurrence());
                    } else if (this.shouldMarkAsRead(hidMatch)) {
                        hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
                    }
                }
            }
            this.reportOccurences(hidMatch, topScope);
        }
    }

    private RfParamsHolder getParamsHolder() {
        if (!(this.fHolderScope instanceof RfNamedElement)) {
            return null;
        }
        RfNamedElement closestTypeContainer = ((RfNamedElement)this.fHolderScope).getClosestTypeContainer();
        return closestTypeContainer instanceof RfParamsHolder ? (RfParamsHolder)closestTypeContainer : null;
    }

    private boolean hasPredefinedOrUserDefinedWriteAPI(HidMatch hidMatch, RfParamsHolder paramsHolder) {
        Hid hid = hidMatch.getHid();
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        ListContainer accesses = hid.getAccesses();
        if (accesses == null || accesses.isEmpty()) {
            return false;
        }
        HidAccess hidAccess = (HidAccess)accesses.get(0);
        if (hidAccess == null) {
            return false;
        }
        RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)(hid.getParentAccess() != null ? hid.getParentAccess().getAssociatedType() : paramsHolder), this.fRfProject, 8);
        boolean hasListType = false;
        ListContainer hidAccessHids = hidAccess.getHids();
        if (hidAccessHids != null) {
            for (Hid hidAccessHid : hidAccessHids) {
                IRfNamedElement associatedType;
                IRfNamedElement associatedType2;
                RfField field;
                IRfNamedElement hidAccessElement = hidAccessHid.getElement();
                if (!(hidAccessElement instanceof RfPredefinedFunction)) continue;
                if (PREDEFINED_ARRAY_FUNCTIONS.contains(hidAccessElement.getName())) {
                    if (!hasListType) {
                        field = (RfField)element;
                        associatedType2 = field.getAssociatedType(typesResolver);
                        if (associatedType2 instanceof RfTypeAlias) {
                            associatedType2 = ((RfTypeAlias)associatedType2).getTranslatedType(typesResolver);
                        }
                        hasListType = associatedType2 instanceof RfListType;
                    }
                    if (!hasListType) continue;
                    return true;
                }
                if (!(PREDEFINED_STRING_WRITE_FUNCTIONS.contains(hidAccessElement.getName()) ? (associatedType2 = (field = (RfField)element).getAssociatedType()) instanceof RfStringType && "string".equals(associatedType2.getName()) : PREDEFINED_MAILBOX_WRITE_FUNCTIONS.contains(hidAccessElement.getName()) && element instanceof RfField && (associatedType = ((RfField)element).getAssociatedType()) instanceof RfSpecializedClass && "mailbox".equals(associatedType.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPredefinedOrUserDefinedReadWriteAPI(HidMatch hidMatch, RfParamsHolder paramsHolder) {
        Hid hid = hidMatch.getHid();
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        ListContainer accesses = hid.getAccesses();
        if (accesses == null || accesses.isEmpty()) {
            return false;
        }
        HidAccess hidAccess = (HidAccess)accesses.get(0);
        if (hidAccess == null) {
            return false;
        }
        boolean hasListType = false;
        RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)(hid.getParentAccess() != null ? hid.getParentAccess().getAssociatedType() : paramsHolder), this.fRfProject, 8);
        ListContainer hidAccessHids = hidAccess.getHids();
        if (hidAccessHids != null) {
            for (Hid hidAccessHid : hidAccessHids) {
                IRfNamedElement hidAccessElement = hidAccessHid.getElement();
                if (!(hidAccessElement instanceof RfPredefinedFunction) || !PREDEFINED_RW_QUEUE_FUNCTIONS.contains(hidAccessElement.getName())) continue;
                if (!hasListType) {
                    RfField field = (RfField)element;
                    IRfNamedElement associatedType = field.getAssociatedType(typesResolver);
                    if (associatedType instanceof RfTypeAlias) {
                        associatedType = ((RfTypeAlias)associatedType).getTranslatedType(typesResolver);
                    }
                    hasListType = associatedType instanceof RfListType;
                }
                if (!hasListType) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldMarkAsRead(HidMatch hidMatch) {
        Collection declarations;
        boolean markAsRead = true;
        if (this.fRfElement instanceof RfPort && (declarations = this.fRfElement.getDeclarations()) != null) {
            for (IRfDefElement declaration : declarations) {
                if (hidMatch.getHid().getOccurrence().getLine() != declaration.getStartLine()) continue;
                markAsRead = false;
                break;
            }
        }
        return markAsRead;
    }
}

