/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ReferenceImportExportHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private IProject fProject;
    private IRfNamedElement fRfElement;
    private ParserPath fParserPath;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private RfProject fRfProject;
    private boolean fForRefactor;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public ReferenceImportExportHidOperatorVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, IProject project, boolean forRefactoring, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, IReportHitsListener<SearchHit> listener, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElement = element;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fListener = listener;
        this.fFileManager = fileManager;
        this.fProgressMonitor = progressMonitor;
        this.fMacroInfoMap = macroInfoMap;
        this.fDocumentManager = documentManager;
        this.fForRefactor = forRefactoring;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(RfHidOperator hidOperator) {
        try {
            boolean insideMacroCall;
            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException("Operation Canceled");
                }
                this.fCheckForQueryInterruptionCounter = 0;
            }
            if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_IMPORT) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_EXPORT)) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            ListContainer rhHidObjects = hidOperator.getRHValues();
            RfHidImplicit pkgHidImplicit = (RfHidImplicit)lhHidObject;
            String pkgName = pkgHidImplicit.getName();
            if (pkgName == null) {
                return true;
            }
            boolean leftSide = true;
            boolean bl = insideMacroCall = hidOperator.getVirtualOffset() != -1;
            if (this.fRfElement.getName().equals(pkgName)) {
                this.addReferenceImportExportMatch(hidOperator, leftSide, insideMacroCall);
            }
            Iterator iterator = rhHidObjects.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                IHidObject rhHidObject = (IHidObject)iterator.next();
                if (!(rhHidObject instanceof RfHidImplicit)) continue;
                RfHidImplicit rhHidImplicit = (RfHidImplicit)rhHidObject;
                if (this.fRfElement.getName().equals(rhHidImplicit.getName())) break;
            }
            leftSide = false;
            this.addReferenceImportExportMatch(hidOperator, leftSide, insideMacroCall);
            return true;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void addReferenceImportExportMatch(RfHidOperator hidOperator, boolean leftSide, boolean insideMacroCall) {
        try {
            if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
                return;
            }
            IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
            if (document == null) {
                return;
            }
            this.addImportExportMatch(hidOperator, document, leftSide, insideMacroCall);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addImportExportMatch(RfHidOperator hidOperator, IDocument document, boolean leftSide, boolean insideMacroCall) throws Exception {
        if (!(this.fRfElement instanceof IRfPackageElement) && leftSide || this.fRfElement instanceof IRfPackageElement && !leftSide) {
            return;
        }
        HidOperatorOccurrence importExportOccurrence = hidOperator.getOccurrence(HidOperatorQualifier.IS_IMPORT.value());
        if (importExportOccurrence == null) {
            importExportOccurrence = hidOperator.getOccurrence(HidOperatorQualifier.IS_EXPORT.value());
        }
        if (importExportOccurrence == null) {
            return;
        }
        if (insideMacroCall) {
            MacroCallHitsInfo macroCallHitsInfo = VlogRfReferencesUtils.computeMacroHit(false, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, importExportOccurrence.getOffset(), this.fParserPath, document, null, this.fDisableHitInMacroArgument);
            if (macroCallHitsInfo == null) {
                return;
            }
            if (macroCallHitsInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, importExportOccurrence.getOffset(), document, false, macroCallHitsInfo.getMacroCallText(), RWKind.NONE);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitsInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (macroCallParameterHit.getText().isEmpty()) continue;
                int offset = macroCallParameterHit.getOffset();
                this.addHitOccurence(false, offset, document, false, macroCallHitsInfo.getMacroCallText(), RWKind.NONE);
            }
            return;
        }
        int line = importExportOccurrence.getLine();
        if (line == -1) {
            return;
        }
        IRegion region = document.getLineInformation(line - 1);
        String lineContents = document.get(region.getOffset(), region.getLength());
        int index = lineContents.indexOf(this.fRfElement.getName());
        if (index == -1) {
            return;
        }
        int offset = leftSide ? importExportOccurrence.getOffset() - this.fRfElement.getName().length() : importExportOccurrence.getOffset() + 2;
        this.addHitOccurence(false, offset, document, false, null, RWKind.NONE);
    }

    private void addHitOccurence(boolean isNonParameterHit, int offset, IDocument openDocument, boolean isPossibleMatch, String macroCallText, RWKind writeAccess) throws BadLocationException {
        int line = openDocument.getLineOfOffset(offset);
        IRegion info = openDocument.getLineInformation(line);
        int lineOffset = info.getOffset();
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int matchLength = isNonParameterHit ? lineContents.trim().length() : this.fRfElement.getName().length();
        int myOffset = lineContents.indexOf("\\");
        if (myOffset != -1 && lineOffset + myOffset == offset) {
            ++offset;
        }
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        String highlightName = this.fRfElement.getName();
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        VlogSearchHit lineEntry = new VlogSearchHit(this.fParserPath, line + 1, offset, lineContents, matchLength, isNonParameterHit, this.fProject, null);
        lineEntry.setAccess(writeAccess);
        if (this.fParserPath != null) {
            lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)(line + 1), (int)offset, (boolean)isPossibleMatch));
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, offset - lineOffset - counter, isPossibleMatch);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

