/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfigurationRule;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ReferenceNamedElementVisitor
implements IRfNamedElementVisitor {
    private static final String DUMMY_CHAR_STRING = "c";
    private IRfNamedElement fRfElement;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private boolean fIncludeDeclarations;
    private boolean fForRefactor;
    private IProject fProject;
    private RfProject fRfProject;
    private boolean fIsStrictVirtual;
    private HashSet<PairOffsetFile> fHitsInSameLine;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter = 0;
    private boolean fIsFunctionSearch;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private boolean fSemanticSearch;
    private boolean fSkipDirectLibraryMembers;
    private boolean fIsClassFieldOrFunctionArgumentSearch;
    private boolean fSearchForTypeParameter;
    private boolean fSearchForParameter;
    private SearchedElementWrapper fSearchedElementWrapper;
    private Map<RfFunction, LinkedHashSet<RfClass>> fFunctionClassFamily;
    private boolean assumeHitWhenSameNameAndType;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public ReferenceNamedElementVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, boolean semanticSearch, boolean includeDeclarations, boolean forRefactoring, IProject project, boolean isStrictVirtual, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, IReportHitsListener<SearchHit> listener, SearchedElementWrapper searchedElementWrapper, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElement = element;
        this.fSemanticSearch = semanticSearch;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fIncludeDeclarations = includeDeclarations;
        this.fForRefactor = forRefactoring;
        this.fMacroInfoMap = macroInfoMap;
        this.fIsStrictVirtual = isStrictVirtual;
        this.fListener = listener;
        this.fFileManager = fileManager;
        this.fSkipDirectLibraryMembers = false;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fIsFunctionSearch = this.fRfElement instanceof RfFunction || this.fRfElement instanceof RfResultImplicitVariable;
        this.fIsClassFieldOrFunctionArgumentSearch = VlogRfReferencesUtils.isClassFieldOrFunctionArgument(this.fRfElement);
        this.fSearchForParameter = this.fRfElement instanceof IRfFieldElement && ((IRfFieldElement)this.fRfElement).isParameter();
        this.fSearchForTypeParameter = RfSearchUtils.isTypeElement((IRfNamedElement)this.fRfElement, (IProject)this.fProject) || this.fRfElement instanceof IRfFieldElement && ((IRfFieldElement)this.fRfElement).isTypeParameter();
        this.fHitsInSameLine = new HashSet();
        this.fSearchedElementWrapper = searchedElementWrapper;
        this.fFunctionClassFamily = functionClassFamily;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visit(RfNamedElement element) {
        try {
            Collection defElements;
            IRfNamedElement resolvedDesignMapping;
            if (this.fSkipDirectLibraryMembers && element.getEnclosingScope() instanceof RfLibrary) {
                return true;
            }
            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException("Operation Canceled");
                }
                this.fCheckForQueryInterruptionCounter = 0;
            }
            if (element instanceof RfConfigurationRule && this.fRfElement.checkEquals((Object)(resolvedDesignMapping = ((RfConfigurationRule)element).getResolvedDesignMapping(null)))) {
                this.addMatchAssocType(null, false, element.getDeclaration(), element.getEnclosingScope(), element);
            }
            if ((defElements = element.getDeclarations()) == null || defElements.isEmpty()) {
                return true;
            }
            for (RfDefElement defElement : defElements) {
                boolean isInEnclosingScope;
                boolean includeDeclaration;
                if (defElement instanceof RfFileDef || defElement instanceof RfFieldDef && ((RfFieldDef)defElement).isImplicit() && (!(element instanceof RfField) || !((RfField)element).isNamedArrayMethodItem())) continue;
                if (VlogRfReferencesUtils.matchesMethodArgumentForRefactoring(this.fRfElement, element, this.fForRefactor)) {
                    this.addMatchDef(false, element, defElement, defElement.getEnclosingScope(), null, RWKind.NONE);
                }
                RWKind writeAccess = this.computeWriteAccessForDeclaration(element);
                boolean isDeclaration = this.isDeclaration(defElement, element, defElement.getParserPath());
                boolean bl = includeDeclaration = this.fIncludeDeclarations || !isDeclaration || writeAccess != RWKind.NONE;
                if (includeDeclaration && VlogRfReferencesUtils.checkEquals(this.fRfElement, this.fResolver, element, RfTypesResolver.create((IRfScopeElement)element.getEnclosingScope(), this.fRfProject, 8), this.fIsStrictVirtual, this.fFunctionClassFamily)) {
                    boolean isClassFieldOrFunctionArgument;
                    ParserPath parserPath = defElement.getParserPath();
                    if (parserPath == null) continue;
                    if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
                        return true;
                    }
                    SearchMatchKindsWrapper searchMatchKindsWrapper = null;
                    boolean isFunctionSearch = this.fIsFunctionSearch && (element instanceof RfFunction || element instanceof RfResultImplicitVariable);
                    boolean bl2 = isClassFieldOrFunctionArgument = this.fIsClassFieldOrFunctionArgumentSearch && VlogRfReferencesUtils.isClassFieldOrFunctionArgument(element);
                    if (isFunctionSearch) {
                        if (element instanceof RfFunction) {
                            LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)element, this.fFunctionClassFamily);
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)element.getEnclosingScope(), this.fRfProject, 8);
                            searchMatchKindsWrapper = ((RfFunction)element).computeEquals(resolver, this.fRfElement, this.fResolver, classFamily);
                        }
                        if (element instanceof RfResultImplicitVariable) {
                            searchMatchKindsWrapper = ((RfResultImplicitVariable)element).computeEquals(this.fRfElement);
                        }
                    } else if (isClassFieldOrFunctionArgument) {
                        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)element.getEnclosingScope(), this.fRfProject, 8);
                        searchMatchKindsWrapper = ((RfField)element).computeEqualsForField(resolver, this.fRfElement, this.fResolver);
                    }
                    if (!includeDeclaration) continue;
                    this.addMatchDef(false, element, defElement, element.getEnclosingScope(), searchMatchKindsWrapper, writeAccess);
                    continue;
                }
                if (!this.fSearchForTypeParameter && !this.fSearchForParameter) continue;
                if (element instanceof RfAssociatedType) {
                    List<ArgInfo> args;
                    IRfNamedElement assocType = ((RfAssociatedType)element).getResolvedType(true);
                    while (assocType instanceof RfListType) {
                        assocType = ((RfListType)assocType).getResolvedType(true);
                    }
                    DataType dataType = ((RfAssociatedType)element).getDataType();
                    if (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isOutOfClassDefinition() && this.fRfElement instanceof RfClass) {
                        boolean isInEnclosingScope2;
                        if (!((RfFunction)element).isConstructor()) {
                            dataType = ((RfFunctionDef)defElement).getTypeInfo(element);
                        }
                        if (dataType == null) {
                            dataType = defElement.getDataType(element);
                        }
                        if (isInEnclosingScope2 = this.checkIsEnclosingScope(element)) {
                            this.addMatchAssocType(null, false, defElement, element.getEnclosingScope(), element);
                        }
                    }
                    if (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isPrototype() && (args = ((RfFunctionDef)defElement).getArgumentInfos()) != null) {
                        for (ArgInfo argInfo : args) {
                            DataType argDataType = argInfo.getDataType();
                            IRfNamedElement dataTypeElement = VlogRfReferencesUtils.getNamedElementOfDataType(element, argDataType, true, element.getEnclosingScope());
                            if (!this.fRfElement.checkEquals((Object)dataTypeElement)) continue;
                            this.addMatchAssocType(argDataType, false, defElement, element.getEnclosingScope(), element);
                        }
                    }
                    if (dataType == null || defElement instanceof RfFunctionDef && ((RfFunction)element).isConstructor() && !((RfFunctionDef)defElement).isOutOfClassDefinition()) continue;
                    if (assocType != null && (!(assocType instanceof RfNamedElement) || assocType instanceof RfModport)) {
                        if (this.fRfElement.checkEquals((Object)assocType.getEnclosingScope(this.fRfElement.getClass()))) {
                            this.addMatchAssocType(dataType, false, defElement, element.getEnclosingScope(), element);
                            continue;
                        }
                        if (this.fRfElement.checkEquals((Object)assocType.getEnclosingScope())) {
                            this.addMatchAssocType(dataType, false, defElement, element.getEnclosingScope(), element);
                            continue;
                        }
                        this.checkDataType(dataType, element, defElement, element.getEnclosingScope());
                        continue;
                    }
                    this.checkDataType(dataType, element, defElement, element.getEnclosingScope());
                    continue;
                }
                if (element instanceof RfClass) {
                    List<DataType> parentInterfacesClassTypes;
                    DataType parentClassType = ((RfClass)element).getExtendedType();
                    if (parentClassType != null) {
                        this.checkDataType(parentClassType, element, defElement, element.getEnclosingScope());
                    }
                    if ((parentInterfacesClassTypes = ((RfClass)element).getImplementedTypes()) == null || parentInterfacesClassTypes.isEmpty()) continue;
                    for (DataType parentInterfaceType : parentInterfacesClassTypes) {
                        if (parentInterfaceType == null) continue;
                        this.checkDataType(parentInterfaceType, element, defElement, element.getEnclosingScope());
                    }
                    continue;
                }
                if (!(element instanceof RfConstraint) || !(this.fRfElement instanceof RfClass) || !(defElement instanceof RfConstraintDef) || !((RfConstraintDef)defElement).isOutOfClassDefinition()) continue;
                DataType dataType = null;
                if (!((RfConstraintDef)defElement).isPrototype()) {
                    dataType = defElement.getDataType(element);
                }
                if (dataType == null) {
                    dataType = defElement.getDataType(element);
                }
                if (!(isInEnclosingScope = this.checkIsEnclosingScope(element))) continue;
                this.addMatchAssocType(null, false, defElement, element.getEnclosingScope(), element);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private boolean checkIsEnclosingScope(RfNamedElement element) {
        while (element.getEnclosingScope() != null) {
            if (!this.fRfElement.checkEquals((Object)(element = element.getEnclosingScope()))) continue;
            return true;
        }
        return false;
    }

    private RWKind computeWriteAccessForDeclaration(IRfNamedElement element) {
        if (!VlogRfReferencesUtils.canBeReadOrWritten((IRfNamedElement)element)) {
            return RWKind.NONE;
        }
        IRfFieldElement fieldElement = (IRfFieldElement)element;
        boolean hasInitialValue = fieldElement.getInitialValue(false) != null && !fieldElement.getInitialValue(false).isEmpty();
        return hasInitialValue ? RWKind.WRITE : RWKind.NONE;
    }

    private void checkDataType(DataType dataType, RfNamedElement element, RfDefElement defElement, IRfScopeElement scope) throws Exception {
        this.checkDataType(dataType, element, defElement, scope, element);
    }

    private void checkDataType(DataType dataType, RfNamedElement element, RfDefElement defElement, IRfScopeElement scope, IRfNamedElement searchScope) throws Exception {
        if (dataType == null) {
            return;
        }
        DataType dataTypePackageScope = dataType.getPackageScope();
        if (dataTypePackageScope != null) {
            RfNamedElement packageClassScopeElement = element.getEnclosingScope().getPackageOrClassScope(dataType);
            if (this.fRfElement.checkEquals((Object)packageClassScopeElement)) {
                this.addMatchAssocType(dataTypePackageScope, false, defElement, scope, element);
            } else if (packageClassScopeElement == null && this.fRfElement.getName().equals(dataTypePackageScope.toString())) {
                this.addMatchAssocType(dataTypePackageScope, true, defElement, scope, element);
            }
            if (packageClassScopeElement == null) {
                return;
            }
            searchScope = packageClassScopeElement;
            this.checkParamDataType(dataTypePackageScope, element, defElement, true, scope, null);
        }
        if (searchScope == null) {
            searchScope = element;
        }
        searchScope = this.checkParamDataType(dataType, element, defElement, searchScope == element, scope, searchScope);
        List<DataType> innerClassesDataTypes = dataType.getInnerClassesInfo();
        if (innerClassesDataTypes == null || innerClassesDataTypes.isEmpty()) {
            return;
        }
        for (DataType innerClassDataType : innerClassesDataTypes) {
            searchScope = this.checkParamDataType(innerClassDataType, element, defElement, searchScope == element.getEnclosingScope(), scope, searchScope);
        }
    }

    private IRfNamedElement checkParamDataType(DataType currentDataType, RfNamedElement element, RfDefElement defElement, boolean isFirst, IRfScopeElement scope, IRfNamedElement searchScope) throws Exception {
        RfHidHolder paramValuesHolder;
        Map<String, ArgInfo> namedParamAssigns;
        List<DataType> orderedParamAssigns;
        if (currentDataType == null) {
            return null;
        }
        IRfNamedElement namedElement = null;
        if (searchScope != null && this.fSearchForTypeParameter) {
            namedElement = VlogRfReferencesUtils.getNamedElementOfDataType(element, currentDataType, isFirst, searchScope);
            if (namedElement == null && element.getRfProject() != null && element.getRfProject().getMixedLangProjectParent() != null && element.getRfProject().getMixedLangProjectParent().isMixed()) {
                namedElement = element.getOtherLangMemberWithPrefix(currentDataType.getType(), 1);
            }
            if (this.fRfElement.checkEquals((Object)namedElement) || this.assumeHitWhenSameNameAndType && this.fRfElement.getName().equals(currentDataType.getType())) {
                this.addMatchAssocType(currentDataType, false, defElement, scope, element);
            } else if (namedElement == null && this.fRfElement.getName().equals(currentDataType.getType())) {
                this.addMatchAssocType(currentDataType, true, defElement, scope, element);
            }
        }
        if ((orderedParamAssigns = currentDataType.getOrderedParamAssignments()) != null) {
            for (DataType subDataType : orderedParamAssigns) {
                this.checkDataType(subDataType, element, defElement, scope, null);
            }
        }
        if ((namedParamAssigns = currentDataType.getNamedParamAssignments()) != null) {
            for (ArgInfo namedParamAssign : namedParamAssigns.values()) {
                this.checkDataType(namedParamAssign.getDataType(), element, defElement, scope, null);
            }
        }
        if ((paramValuesHolder = currentDataType.getParamValuesHolder()) != null) {
            DataTypeVisitor dataTypeVisitor = new DataTypeVisitor(defElement.getParserPath(), element);
            paramValuesHolder.visitHidObject(null, dataTypeVisitor);
        }
        return namedElement;
    }

    private void addMatchAssocType(DataType dataType, boolean isPossibleMatch, RfDefElement defElement, IRfScopeElement scope, RfNamedElement instanceScope) throws Exception {
        String lineContents;
        boolean escapedVariable;
        ParserPath parserPath = defElement.getParserPath();
        if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        if (dataType != null && dataType.isInsideMacro()) {
            IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
            if (document == null) {
                return;
            }
            MacroCallHitsInfo macroCallHitsInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, dataType.getOffset(), parserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitsInfo == null) {
                return;
            }
            if (macroCallHitsInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, dataType.getOffset(), document, isPossibleMatch, macroCallHitsInfo.getMacroCallText(), RWKind.NONE, parserPath, null);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitsInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (macroCallParameterHit.getText().isEmpty()) continue;
                int offset = macroCallParameterHit.getOffset();
                this.addHitOccurence(false, offset, document, isPossibleMatch, macroCallHitsInfo.getMacroCallText(), RWKind.NONE, parserPath, null);
            }
            return;
        }
        int offset = -1;
        int matchLength = this.fRfElement.getName().length();
        boolean bl = escapedVariable = dataType != null && dataType.isEscaped();
        if (escapedVariable) {
            ++matchLength;
        }
        if (dataType != null) {
            offset = dataType.getOffset();
            if (offset == -1) {
                return;
            }
            PairOffsetFile pair = new PairOffsetFile(offset, parserPath);
            if (this.fHitsInSameLine.contains(pair) || !this.fRfElement.getName().equals(dataType.getType())) {
                int line = defElement.getStartLine();
                IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
                if (document == null) {
                    return;
                }
                IRegion lineInfo = document.getLineInformation(line - 1);
                lineContents = document.get(lineInfo.getOffset(), lineInfo.getLength());
                offset = defElement.getStartOffset();
                int endOffset = defElement.getEndOffset();
                int lineOffset = lineInfo.getOffset();
                int localOffset = lineContents.indexOf(this.fRfElement.getName());
                if (localOffset == -1) {
                    return;
                }
                offset = localOffset + lineOffset;
                offset = this.getHitOffset(parserPath, offset, lineOffset, localOffset, endOffset, lineContents);
            }
            this.fHitsInSameLine.add(pair);
        } else {
            int line = defElement.getStartLine();
            IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
            if (document == null) {
                return;
            }
            IRegion lineInfo = document.getLineInformation(line - 1);
            lineContents = document.get(lineInfo.getOffset(), lineInfo.getLength());
            offset = defElement.getStartOffset();
            int endOffset = defElement.getEndOffset();
            int lineOffset = lineInfo.getOffset();
            int localOffset = lineContents.indexOf(this.fRfElement.getName());
            while (localOffset > 0 && localOffset + this.fRfElement.getName().length() < lineContents.length() && (Character.isJavaIdentifierPart(lineContents.charAt(localOffset - 1)) || Character.isJavaIdentifierPart(lineContents.charAt(localOffset + this.fRfElement.getName().length())))) {
                localOffset = lineContents.indexOf(this.fRfElement.getName(), localOffset + 1);
            }
            if (localOffset == -1) {
                return;
            }
            offset = localOffset + lineOffset;
            offset = this.getHitOffset(parserPath, offset, lineOffset, localOffset, endOffset, lineContents);
        }
        if (offset == -1) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
        if (document == null) {
            return;
        }
        if (!RfSearchUtils.validContentType((IProject)this.fProject, (IDocument)document, (int)offset)) {
            return;
        }
        int startOffsetLine = document.getLineOfOffset(offset);
        IRegion startLineInfo = document.getLineInformation(startOffsetLine);
        int lineStart = document.getLineOffset(startOffsetLine);
        lineContents = document.get(startLineInfo.getOffset(), startLineInfo.getLength());
        VlogSearchHit lineEntry = new VlogSearchHit(parserPath, startOffsetLine + 1, offset, lineContents, matchLength, this.fProject, null);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)(startOffsetLine + 1), (int)offset, (boolean)isPossibleMatch));
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)startLineInfo);
        int highlightOffset = offset;
        if (escapedVariable) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(this.fRfElement.getName(), highlightOffset - lineStart - counter, isPossibleMatch);
        }
        lineEntry.setIsEscaped(escapedVariable);
        if (instanceScope instanceof RfInstance) {
            lineEntry.setInstance((RfInstance)instanceScope);
            VlogRfReferencesUtils.changeToPostConfigHit((IProject)this.fProject, (IRfInstanceElement)((RfInstance)instanceScope), (SearchHit)lineEntry);
        }
        if (this.assumeHitWhenSameNameAndType) {
            lineEntry.setIsElaborationHit();
        }
        if (dataType != null && dataType.getPackageScope() != null) {
            lineEntry.setIsInsideHierarchicalAccess();
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    /*
     * Unable to fully structure code
     */
    private int getHitOffset(ParserPath file, int offset, int lineOffset, int localOffset, int endOffset, String lineContents) {
        block4: {
            block3: {
                startOffset = offset;
                if (localOffset != -1) ** GOTO lbl6
                return -1;
                while ((localOffset = lineContents.indexOf(this.fRfElement.getName(), localOffset + this.fRfElement.getName().length() + 1)) != -1 && localOffset <= endOffset - lineOffset) {
                    startOffset = localOffset + lineOffset;
lbl6:
                    // 3 sources

                    ** while (!(localOffset == 0 && (lineContents.charAt((int)(localOffset + this.fRfElement.getName().length())) == '\"' || Character.isJavaIdentifierPart((char)lineContents.charAt((int)(localOffset + this.fRfElement.getName().length())))) || localOffset - 1 >= 0 && localOffset + this.fRfElement.getName().length() + 1 < endOffset && localOffset + this.fRfElement.getName().length() < lineContents.length() && (lineContents.charAt((int)(localOffset - 1)) == '\"' || lineContents.charAt((int)(localOffset + this.fRfElement.getName().length())) == '\"' || Character.isJavaIdentifierPart((char)lineContents.charAt((int)(localOffset - 1))) || Character.isJavaIdentifierPart((char)lineContents.charAt((int)(localOffset + this.fRfElement.getName().length()))))))
lbl7:
                    // 1 sources

                }
lbl8:
                // 2 sources

                if (localOffset == -1) {
                    return -1;
                }
                pair = new PairOffsetFile(startOffset, file);
                if (this.fHitsInSameLine.contains(pair)) break block3;
                this.fHitsInSameLine.add(pair);
                break block4;
            }
            auxLocalOffset = lineContents.indexOf(this.fRfElement.getName(), localOffset + this.fRfElement.getName().length() + 1);
            if (auxLocalOffset == -1) break block4;
            startOffset = auxLocalOffset + lineOffset;
            localOffset = auxLocalOffset;
            ** GOTO lbl6
        }
        return startOffset;
    }

    private void addMatchDef(boolean isPossibleMatch, IRfNamedElement element, RfDefElement defElement, IRfScopeElement scope, SearchMatchKindsWrapper searchKindWrapper, RWKind writeAccess) throws Exception {
        ParserPath parserPath = defElement.getParserPath();
        if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
        if (document == null) {
            return;
        }
        try {
            if (defElement.hasNameInsideMacro()) {
                MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, defElement.getStartOffset(), parserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
                if (macroCallHitInfo == null) {
                    return;
                }
                if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                    this.addHitOccurence(true, defElement.getStartOffset(), document, isPossibleMatch, macroCallHitInfo.getMacroCallText(), writeAccess, parserPath, null);
                    return;
                }
                List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
                if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                    return;
                }
                for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                    if (macroCallParameterHit.getText().isEmpty()) continue;
                    int offset = macroCallParameterHit.getOffset();
                    this.addHitOccurence(false, offset, document, isPossibleMatch, macroCallHitInfo.getMacroCallText(), writeAccess, parserPath, null);
                }
                return;
            }
            int startLabelLine = defElement.getLabelStartLine();
            int startLabelOffset = defElement.getLabelStartOffset();
            int matchLength = this.fRfElement.getName().length();
            IRegion startLabelLineInfo = document.getLineInformation(startLabelLine - 1);
            String lineContents = document.get(startLabelLineInfo.getOffset(), startLabelLineInfo.getLength());
            if (element.isEscaped()) {
                ++matchLength;
            }
            if (searchKindWrapper != null && VlogRfReferencesUtils.shouldSkipFunctionUsage(searchKindWrapper.getFunctionCallKind(), this.fIncludeDeclarations, null, this.fRfElement.getEnclosingScope())) {
                return;
            }
            VlogSearchHit lineEntry = new VlogSearchHit(parserPath, startLabelLine, startLabelOffset, lineContents, matchLength, searchKindWrapper, false, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject, null);
            lineEntry.setAccess(writeAccess);
            lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)defElement.getParserPath(), (int)startLabelLine, (int)startLabelOffset, (boolean)isPossibleMatch));
            int lineStart = document.getLineOffset(startLabelLine - 1);
            int counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)startLabelLineInfo);
            if (element.isEscaped()) {
                ++startLabelOffset;
            }
            if (counter >= 0) {
                lineEntry.setSearchedElement(this.fRfElement.getName(), startLabelOffset - lineStart - counter, isPossibleMatch);
            }
            if (scope instanceof RfInstance) {
                lineEntry.setInstance((RfInstance)scope);
            }
            lineEntry.setIsDeclarationHit();
            if (this.assumeHitWhenSameNameAndType) {
                lineEntry.setIsElaborationHit();
            }
            lineEntry.setIsEscaped(element.isEscaped());
            this.fListener.addMatch((Object)lineEntry);
            if (defElement.hasEndLabel()) {
                int endLabelOffset = defElement.getEndLabelOffset();
                int endLabelLine = document.getLineOfOffset(endLabelOffset);
                IRegion endLabelLineInfo = document.getLineInformation(endLabelLine);
                lineContents = document.get(endLabelLineInfo.getOffset(), endLabelLineInfo.getLength());
                lineEntry = new VlogSearchHit(parserPath, endLabelLine + 1, endLabelOffset, lineContents, matchLength, false, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), this.fProject, null);
                lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)defElement.getParserPath(), (int)(endLabelLine + 1), (int)endLabelOffset, (boolean)isPossibleMatch));
                lineStart = document.getLineOffset(endLabelLine);
                counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)endLabelLineInfo);
                if (counter >= 0) {
                    lineEntry.setSearchedElement(this.fRfElement.getName(), endLabelOffset - lineStart - counter, isPossibleMatch);
                }
                if (scope instanceof RfInstance) {
                    lineEntry.setInstance((RfInstance)scope);
                }
                if (this.assumeHitWhenSameNameAndType) {
                    lineEntry.setIsElaborationHit();
                }
                lineEntry.setIsDeclarationHit();
                this.fListener.addMatch((Object)lineEntry);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
    }

    private SearchMatchKindsWrapper computeClassFieldType(IRfNamedElement element, RWKind writeAccess, RfTypesResolver resolver) {
        if (writeAccess == RWKind.NONE) {
            return new SearchMatchKindsWrapper(RfField.TypeCompatibilityMatchKind.STRICT_MATCH);
        }
        if (!(this.fRfElement instanceof RfField) || !(element instanceof RfField)) {
            return new SearchMatchKindsWrapper(RfField.TypeCompatibilityMatchKind.STRICT_MATCH);
        }
        return ((RfField)this.fRfElement).computeEqualsForField(this.fResolver, element, resolver);
    }

    private boolean isDeclaration(RfDefElement defElement, IRfNamedElement element, ParserPath parserPath) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (!(this.fRfElement instanceof RfNamedElement) || this.fRfElement.getCustomClass().getName().equals(element.getCustomClass().getName()) || this.fIsFunctionSearch && (element instanceof RfFunction || element instanceof RfResultImplicitVariable)) break block4;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    this.fProgressMonitor.done();
                    return false;
                }
            }
            document = this.fDocumentManager.getDocument(parserPath, this.fProject);
            if (document != null) break block5;
            return false;
        }
        return this.checkDeclaration(defElement, element, document, parserPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDeclaration(RfDefElement defElement, IRfNamedElement element, IDocument openDocument, ParserPath parserPath) {
        try {
            IRegion lineInfo;
            String lineContents;
            int index;
            if (element.isAutoDefined()) {
                return true;
            }
            int startOffsetLine = openDocument.getLineOfOffset(defElement.getStartOffset());
            int currentMatchStartLine = startOffsetLine + 1;
            int endOffsetLine = openDocument.getLineOfOffset(defElement.getEndOffset());
            IRfDefElement declaration = element.getDeclaration();
            if (element instanceof RfActionBlock && !((RfActionBlock)element).isAnonymous() && (index = (lineContents = openDocument.get((lineInfo = openDocument.getLineInformation((startOffsetLine = defElement.getLabelStartLine()) - 1)).getOffset(), lineInfo.getLength())).indexOf(this.fRfElement.getName())) != -1) {
                int startOffset = openDocument.getLineOffset(startOffsetLine - 1) + index;
                int endOffset = openDocument.getLineOffset(startOffsetLine - 1) + index + this.fRfElement.getName().length();
                startOffsetLine = openDocument.getLineOfOffset(startOffset);
                currentMatchStartLine = startOffsetLine + 1;
                endOffsetLine = openDocument.getLineOfOffset(endOffset);
            }
            if (element instanceof VlogMacroInfo && defElement.getStartOffset() > 0 && !((VlogMacroInfo)element).isUndefConfigMacro()) {
                int declarationStart = ((VlogMacroInfo)element).getLine();
                if (currentMatchStartLine != declarationStart || ((VlogMacroInfo)element).isUndef()) return false;
                return true;
            } else {
                if (element != this.fRfElement && element instanceof RfField && (element.getEnclosingScope() instanceof RfModport || element.getEnclosingScope() instanceof RfClockingBlock)) {
                    return false;
                }
                for (IRfDefElement layer : element.getDeclarations()) {
                    if (layer.getDefFile() == null || !layer.getDefFile().getParserPath().equals((Object)parserPath) || layer.getStartLine() != currentMatchStartLine && openDocument.getLineOfOffset(layer.getEndOffset()) != endOffsetLine || element instanceof RfPort && layer != declaration) continue;
                    return true;
                }
            }
            return false;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fProgressMonitor.done();
            return false;
        }
    }

    private void addReferenceMatchOcc(boolean isPossibleMatch, IHidObject hidObject, ParserPath parserPath, RWKind writeAccess, IRfNamedElement instanceScope) throws Exception {
        if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
        if (document == null) {
            return;
        }
        if (HidUtils.isHid((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, (Hid)hidObject, document, writeAccess, parserPath, instanceScope);
        } else if (HidUtils.isOperator((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, (HidOperator)hidObject, document, writeAccess, parserPath, instanceScope);
        }
    }

    private void addMatchOcc(boolean isPossibleMatch, Hid hid, IDocument document, RWKind writeAccess, ParserPath parserPath, IRfNamedElement instanceScope) throws BadLocationException {
        if (hid == null) {
            return;
        }
        HidOccurrence occurence = hid.getOccurrence();
        if (occurence == null) {
            return;
        }
        boolean sameTypeOfElement = false;
        if (hid.getElement() != null) {
            sameTypeOfElement = this.fRfElement.getClass().getName().equals(hid.getElement().getClass().getName());
        }
        if (!this.fIncludeDeclarations && sameTypeOfElement && VlogRfReferencesUtils.isDeclaration(occurence, hid.getElement(), this.fRfElement, parserPath, document)) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, document, isPossibleMatch, null, writeAccess, parserPath, instanceScope);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), parserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, document, isPossibleMatch, macroCallHitInfo.getMacroCallText(), writeAccess, parserPath, instanceScope);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (macroCallParameterHit.getText().equals("")) continue;
                offset = macroCallParameterHit.getOffset();
                this.addHitOccurence(false, offset, document, isPossibleMatch, macroCallHitInfo.getMacroCallText(), writeAccess, parserPath, instanceScope);
            }
        }
    }

    private void addMatchOcc(boolean isPossibleMatch, HidOperator operator, IDocument document, RWKind writeAccess, ParserPath parserPath, IRfNamedElement instanceScope) throws BadLocationException {
        int virtualOffset;
        if (operator == null) {
            return;
        }
        HidOperatorOccurrence occurence = operator.getOccurrence();
        if (occurence == null) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        if ((virtualOffset = occurence.getVirtualOffset()) == -1) {
            this.addHitOccurence(false, operator.getOpenBoundary(), operator.getCloseBoundary(), document, isPossibleMatch, null, writeAccess, parserPath, instanceScope);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), parserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallHitInfo.hasHitsInsideMacroCall() || macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                this.addHitOccurence(true, operator.getOpenBoundary(), operator.getCloseBoundary(), document, isPossibleMatch, macroCallHitInfo.getMacroCallText(), writeAccess, parserPath, instanceScope);
                return;
            }
        }
    }

    private void addHitOccurence(boolean isNonParameterHit, int offset, IDocument openDocument, boolean isPossibleMatch, String macroCallText, RWKind writeAccess, ParserPath parserPath, IRfNamedElement instanceScope) throws BadLocationException {
        PairOffsetFile pair;
        int line = openDocument.getLineOfOffset(offset);
        IRegion info = openDocument.getLineInformation(line);
        int lineOffset = info.getOffset();
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int matchLength = isNonParameterHit ? lineContents.trim().length() : this.fRfElement.getName().length();
        int myOffset = lineContents.indexOf("\\");
        if (myOffset != -1 && lineOffset + myOffset == offset) {
            ++offset;
        }
        if (this.fHitsInSameLine.contains(pair = new PairOffsetFile(offset, parserPath))) {
            return;
        }
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        String highlightName = this.fRfElement.getName();
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        VlogSearchHit lineEntry = new VlogSearchHit(parserPath, line + 1, offset, lineContents, matchLength, null, isNonParameterHit, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject, null);
        lineEntry.setAccess(writeAccess);
        this.fHitsInSameLine.add(pair);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)(line + 1), (int)offset, (boolean)isPossibleMatch));
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, offset - lineOffset - counter, isPossibleMatch);
        }
        if (this.assumeHitWhenSameNameAndType) {
            lineEntry.setIsElaborationHit();
        }
        if (instanceScope instanceof RfInstance) {
            lineEntry.setInstance((RfInstance)instanceScope);
            VlogRfReferencesUtils.changeToPostConfigHit((IProject)this.fProject, (IRfInstanceElement)((RfInstance)instanceScope), (SearchHit)lineEntry);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    private void addHitOccurence(boolean isNonParameterHit, int startOffset, int endOffset, IDocument openDocument, boolean isPossibleMatch, String macroCallText, RWKind writeAccess, ParserPath parserPath, IRfNamedElement instanceScope) throws BadLocationException {
        int line = openDocument.getLineOfOffset(startOffset);
        IRegion info = openDocument.getLineInformation(line);
        int lineOffset = info.getOffset();
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int endJumpOffset = Math.min(lineOffset + lineContents.length(), endOffset);
        StringBuilder str = new StringBuilder();
        int i = startOffset;
        while (i < endJumpOffset) {
            str.append(DUMMY_CHAR_STRING);
            ++i;
        }
        int matchLength = isNonParameterHit ? lineContents.trim().length() : str.toString().length();
        PairOffsetFile pair = new PairOffsetFile(startOffset, parserPath);
        if (this.fHitsInSameLine.contains(pair)) {
            return;
        }
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        String highlightName = str.toString().trim();
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        VlogSearchHit lineEntry = new VlogSearchHit(parserPath, line + 1, startOffset, lineContents, matchLength, isNonParameterHit, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), this.fProject, null);
        lineEntry.setAccess(writeAccess);
        this.fHitsInSameLine.add(pair);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)(line + 1), (int)startOffset, (boolean)isPossibleMatch));
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, startOffset - lineOffset - counter, isPossibleMatch);
        }
        if (instanceScope instanceof RfInstance) {
            lineEntry.setInstance((RfInstance)instanceScope);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    public void skipDirectLibraryMembers(boolean value) {
        this.fSkipDirectLibraryMembers = value;
    }

    public void setAssumeHitWhenSameNameAndType() {
        this.assumeHitWhenSameNameAndType = true;
    }

    public void clearHitsOnSameLine() {
        this.fHitsInSameLine.clear();
    }

    private class DataTypeVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath fParserPath;
        private IRfNamedElement fScope;
        private RfTypesResolver fResolver;

        public DataTypeVisitor(ParserPath parserPath, IRfNamedElement scope) {
            this.fParserPath = parserPath;
            this.fScope = scope;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean visit(IHidObject hidObject) {
            try {
                boolean isMatch;
                IHid rhHid;
                if (ReferenceNamedElementVisitor.this.fListener.shouldFilterIHidObject(hidObject, null)) {
                    return true;
                }
                if (HidUtils.isHid((IHidObject)hidObject)) {
                    Hid hid = (Hid)hidObject;
                    IRfNamedElement rhHidElement = hid.getElement();
                    String rhHidName = hid.getName();
                    boolean isPotentialMatch = ReferenceNamedElementVisitor.this.fRfElement.getName().equals(rhHidName);
                    boolean isMatch2 = false;
                    boolean isFunctionSearch = ReferenceNamedElementVisitor.this.fIsFunctionSearch && (rhHidElement instanceof RfFunction || rhHidElement instanceof RfResultImplicitVariable);
                    SearchMatchKindsWrapper searchKindWrapper = null;
                    if (isFunctionSearch && !ReferenceNamedElementVisitor.this.fRfElement.isPredefined()) {
                        if (rhHidElement instanceof RfFunction) {
                            LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)rhHidElement, ReferenceNamedElementVisitor.this.fFunctionClassFamily);
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)(hid.getParentAccess() != null ? hid.getParentAccess().getAssociatedType() : this.fScope), ReferenceNamedElementVisitor.this.fRfProject, 8);
                            searchKindWrapper = ((RfFunction)rhHidElement).computeEquals(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver, classFamily);
                        }
                        if (rhHidElement instanceof RfResultImplicitVariable) {
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, ReferenceNamedElementVisitor.this.fRfProject, 8);
                            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)ReferenceNamedElementVisitor.this.fRfProject.getELManager());
                            resolver.resolveHidInContext((IHidObject)hid.upwardsCopy(true), guardian, false);
                            searchKindWrapper = ((RfResultImplicitVariable)rhHidElement).computeEqualsForField(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver);
                        }
                        if (searchKindWrapper != null && searchKindWrapper.getFunctionCallKind() != null) {
                            isMatch2 = ReferenceNamedElementVisitor.this.fIsStrictVirtual ? searchKindWrapper.getFunctionCallKind().ordinal() == RfFunction.FunctionCallKind.STRICT.ordinal() : searchKindWrapper.isMatch();
                        }
                    } else {
                        boolean bl = isMatch2 = ReferenceNamedElementVisitor.this.fRfElement.checkEquals((Object)rhHidElement) && isPotentialMatch;
                    }
                    if (isFunctionSearch && ReferenceNamedElementVisitor.this.fSemanticSearch && searchKindWrapper != null && searchKindWrapper.getFunctionCallKind() != null && searchKindWrapper.getFunctionCallKind() != RfFunction.FunctionCallKind.STRICT) {
                        return true;
                    }
                    if (!isMatch2) {
                        if (!isPotentialMatch) return true;
                        if (rhHidElement != null) return true;
                    }
                    ReferenceNamedElementVisitor.this.addReferenceMatchOcc(!isMatch2, (IHidObject)hid, this.fParserPath, RWKind.NONE, this.fScope);
                    return true;
                }
                if (!HidUtils.isOperator((IHidObject)hidObject)) return true;
                ListContainer rhOperators = ((HidOperator)hidObject).getRHValues();
                IHid lhHid = HidUtils.getHidFrom((IHidObject)((HidOperator)hidObject).getLHValue());
                if (HidUtils.isHid((IHidObject)lhHid)) {
                    boolean isFunctionSearch;
                    IRfNamedElement lhHidElement = lhHid.getElement();
                    String lhHidName = lhHid.getName();
                    boolean isPotentialMatch = ReferenceNamedElementVisitor.this.fRfElement.getName().equals(lhHidName);
                    boolean isMatch3 = false;
                    SearchMatchKindsWrapper searchKindWrapper = null;
                    boolean bl = isFunctionSearch = ReferenceNamedElementVisitor.this.fIsFunctionSearch && (lhHidElement instanceof RfFunction || lhHidElement instanceof RfResultImplicitVariable);
                    if (isFunctionSearch && !ReferenceNamedElementVisitor.this.fRfElement.isPredefined()) {
                        if (lhHidElement instanceof RfFunction) {
                            LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)lhHidElement, ReferenceNamedElementVisitor.this.fFunctionClassFamily);
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, ReferenceNamedElementVisitor.this.fRfProject, 8);
                            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)ReferenceNamedElementVisitor.this.fRfProject.getELManager());
                            if (lhHid instanceof RfHid) {
                                resolver.resolveHidInContext((IHidObject)((RfHid)lhHid).upwardsCopy(true), guardian, false);
                            }
                            searchKindWrapper = ((RfFunction)lhHidElement).computeEquals(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver, classFamily);
                        }
                        if (lhHidElement instanceof RfResultImplicitVariable) {
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, ReferenceNamedElementVisitor.this.fRfProject, 8);
                            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)ReferenceNamedElementVisitor.this.fRfProject.getELManager());
                            if (lhHid instanceof RfHid) {
                                resolver.resolveHidInContext((IHidObject)((RfHid)lhHid).upwardsCopy(true), guardian, false);
                            }
                            searchKindWrapper = ((RfResultImplicitVariable)lhHidElement).computeEqualsForField(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver);
                        }
                        if (searchKindWrapper != null) {
                            isMatch3 = searchKindWrapper.isMatch();
                        }
                    } else {
                        boolean isOrderedConnectionMatch = !ReferenceNamedElementVisitor.this.fIncludeDeclarations && !ReferenceNamedElementVisitor.this.fForRefactor && RfSearchUtils.allowOrderedConnections((IRfNamedElement)lhHidElement);
                        boolean bl2 = isMatch3 = (isPotentialMatch || isOrderedConnectionMatch) && ReferenceNamedElementVisitor.this.fRfElement.checkEquals((Object)lhHidElement) || isPotentialMatch && ReferenceNamedElementVisitor.this.assumeHitWhenSameNameAndType;
                    }
                    if (isFunctionSearch && ReferenceNamedElementVisitor.this.fSemanticSearch && searchKindWrapper != null && searchKindWrapper.getFunctionCallKind() != null && searchKindWrapper.getFunctionCallKind() != RfFunction.FunctionCallKind.STRICT) {
                        return true;
                    }
                    if (isMatch3 || isPotentialMatch && lhHidElement == null) {
                        ReferenceNamedElementVisitor.this.addReferenceMatchOcc(!isMatch3, (IHidObject)(isPotentialMatch ? lhHid : hidObject), this.fParserPath, RWKind.WRITE, this.fScope);
                        return true;
                    }
                }
                if (rhOperators == null) return true;
                Iterator iterator = rhOperators.iterator();
                while (true) {
                    boolean isFunctionSearch;
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    IHidObject rhValue = (IHidObject)iterator.next();
                    rhHid = HidUtils.getHidFrom((IHidObject)rhValue);
                    if (!HidUtils.isHid((IHidObject)rhHid)) continue;
                    IRfNamedElement rhHidElement = rhHid.getElement();
                    String rhHidName = rhHid.getName();
                    boolean isPotentialMatch = ReferenceNamedElementVisitor.this.fRfElement.getName().equals(rhHidName);
                    isMatch = ReferenceNamedElementVisitor.this.fRfElement.checkEquals((Object)rhHidElement);
                    SearchMatchKindsWrapper searchKindWrapper = null;
                    boolean bl = isFunctionSearch = ReferenceNamedElementVisitor.this.fIsFunctionSearch && (rhHidElement instanceof RfFunction || rhHidElement instanceof RfResultImplicitVariable);
                    if (isFunctionSearch && !ReferenceNamedElementVisitor.this.fRfElement.isPredefined()) {
                        if (rhHidElement instanceof RfFunction) {
                            LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)rhHidElement, ReferenceNamedElementVisitor.this.fFunctionClassFamily);
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, ReferenceNamedElementVisitor.this.fRfProject, 8);
                            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)ReferenceNamedElementVisitor.this.fRfProject.getELManager());
                            if (rhHid instanceof RfHid) {
                                resolver.resolveHidInContext((IHidObject)((RfHid)rhHid).upwardsCopy(true), guardian, false);
                            }
                            searchKindWrapper = ((RfFunction)rhHidElement).computeEquals(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver, classFamily);
                        }
                        if (rhHidElement instanceof RfResultImplicitVariable) {
                            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, ReferenceNamedElementVisitor.this.fRfProject, 8);
                            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)ReferenceNamedElementVisitor.this.fRfProject.getELManager());
                            if (rhHid instanceof RfHid) {
                                resolver.resolveHidInContext((IHidObject)((RfHid)rhHid).upwardsCopy(true), guardian, false);
                            }
                            searchKindWrapper = ((RfResultImplicitVariable)rhHidElement).computeEqualsForField(resolver, ReferenceNamedElementVisitor.this.fRfElement, this.fResolver);
                        }
                        if (searchKindWrapper != null) {
                            isMatch = searchKindWrapper.isMatch();
                        }
                    } else {
                        boolean bl3 = isMatch = ReferenceNamedElementVisitor.this.fRfElement.checkEquals((Object)rhHidElement) && isPotentialMatch;
                    }
                    if (isFunctionSearch && ReferenceNamedElementVisitor.this.fSemanticSearch && searchKindWrapper != null && searchKindWrapper.getFunctionCallKind() != null && searchKindWrapper.getFunctionCallKind() != RfFunction.FunctionCallKind.STRICT) {
                        return true;
                    }
                    if (isMatch || isPotentialMatch && rhHidElement == null) break;
                }
                ReferenceNamedElementVisitor.this.addReferenceMatchOcc(!isMatch, (IHidObject)rhHid, this.fParserPath, RWKind.READ, this.fScope);
                return true;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ReferenceNamedElementVisitor.this.fProgressMonitor.done();
                return false;
            }
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    class PairOffsetFile {
        private int fOffset;
        private ParserPath fParserPath;

        public PairOffsetFile(int offset, ParserPath parserPath) {
            this.fOffset = offset;
            this.fParserPath = parserPath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.fParserPath == null ? 0 : this.fParserPath.hashCode());
            result = 31 * result + this.fOffset;
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PairOffsetFile)) {
                return false;
            }
            PairOffsetFile pair = (PairOffsetFile)obj;
            return pair.fParserPath.equals((Object)this.fParserPath) && pair.fOffset == this.fOffset;
        }

        private ReferenceNamedElementVisitor getOuterType() {
            return ReferenceNamedElementVisitor.this;
        }
    }
}

