/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ReferencePotentialHidVisitor
extends RfHidVisitor {
    public static final int BUFFER_SIZE = 524288;
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private RfProject fRfProject;
    private boolean fForRefactor;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public ReferencePotentialHidVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, IProject project, boolean forRefactor, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, IReportHitsListener<SearchHit> listener, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElement = element;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fForRefactor = forRefactor;
        this.fMacroInfoMap = macroInfoMap;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    public boolean visit(RfHid hid) {
        block11: {
            block10: {
                String hidName;
                block9: {
                    block8: {
                        try {
                            IRfNamedElement hidElement;
                            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                                if (this.fProgressMonitor.isCanceled()) {
                                    throw new OperationCanceledException("Operation Canceled");
                                }
                                this.fCheckForQueryInterruptionCounter = 0;
                            }
                            if ((hidElement = hid.getElement()) == null) break block8;
                            return true;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return false;
                        }
                    }
                    hidName = hid.getName();
                    if (hidName != null) break block9;
                    return true;
                }
                if (hidName.equals(this.fRfElement.getName())) break block10;
                return true;
            }
            if (!hid.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER) || hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 2) break block11;
            return true;
        }
        this.addReferenceMatch(hid);
        return true;
    }

    private void addReferenceMatch(RfHid hid) throws Exception {
        if (!this.fFileManager.isSynchedFile(this.parserPath, this.fProject)) {
            return;
        }
        IDocument openDocument = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
        if (openDocument == null) {
            return;
        }
        this.addMatch(openDocument, hid);
    }

    private void addMatch(IDocument openDocument, RfHid hid) throws Exception {
        HidOccurrence occurence = hid.getOccurrence();
        if (occurence == null) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, openDocument, occurence.getLine(), null);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(true, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), this.parserPath, openDocument, null, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, openDocument, -1, macroCallHitInfo.getMacroCallText());
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (macroCallParameterHit.getText().isEmpty()) continue;
                offset = macroCallParameterHit.getOffset();
                this.addHitOccurence(false, offset, openDocument, -1, null);
            }
        }
    }

    private void addHitOccurence(boolean isNonParameterHit, int offset, IDocument openDocument, int line, String macroCallText) throws Exception {
        if (line == -1) {
            line = openDocument.getLineOfOffset(offset) + 1;
        }
        IRegion info = openDocument.getLineInformation(line - 1);
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int lineOffset = openDocument.getLineOffset(line - 1);
        int matchLength = isNonParameterHit ? lineContents.trim().length() : this.fRfElement.getName().length();
        boolean isEscaped = lineContents.charAt(offset - lineOffset) == '\\';
        String highlightName = this.fRfElement.getName();
        if (isEscaped) {
            ++matchLength;
        }
        VlogSearchHit lineEntry = new VlogSearchHit(this.parserPath, line, offset, lineContents, matchLength, null, isNonParameterHit, true, null, this.fRfElement, this.fProject, null);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.parserPath, (int)line, (int)offset, (boolean)true));
        int counter = -1;
        try {
            counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        int highlightOffset = offset;
        if (isEscaped) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, true);
        }
        lineEntry.setIsEscaped(isEscaped);
        this.fListener.addMatch((Object)lineEntry);
    }
}

