/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;

public class SignalReadWriteVisitor
implements IHidVisitor<RfHidOperator> {
    private static final long ASSIGN_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_ALIAS, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_DEFPARAM_ASSIGN});
    private static final long DEFPARAM_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DEFPARAM_ASSIGN});
    private static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    private Map<Hid, HidMatch> rwMap;
    private ParserPath fParserPath;

    public SignalReadWriteVisitor(Map<Hid, HidMatch> rwMap) {
        this.rwMap = rwMap;
    }

    public void setHolder(IHidHolder holder) {
        IRfNamedElement scope = ((RfHidHolder)holder).getScope();
        while (scope instanceof RfActionBlock && !((RfActionBlock)scope).isAlways()) {
            scope = (IRfNamedElement)scope.getEnclosingScope();
        }
    }

    public boolean visit(RfHidOperator hidOperator) {
        RfHidOperator operator = hidOperator;
        if (operator.isIfCondition() && operator.getLHValue() instanceof RfHidOperator) {
            operator = (RfHidOperator)operator.getLHValue();
        }
        boolean hasAssignQualifier = operator.hasOccurrence(ASSIGN_QUALIFIERS);
        boolean isIncrementOrDecrement = operator.isIncrementOrDecrement();
        boolean isArithmethicAssign = operator.isArithmeticAssignment();
        boolean isEventTrigger = operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_TRIGGER);
        boolean isProceduralForceAssign = operator.hasOccurrence(HidQualifierCache.IS_PROCEDURAL_FORCE_ASSIGN_QUALIFIER);
        boolean isProceduralContinuousAssign = operator.hasOccurrence(HidQualifierCache.IS_PROCEDURAL_CONTINUOUS_ASSIGN_QUALIFIER);
        boolean isForeachOperator = operator.hasOccurrence(HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER);
        if (isForeachOperator) {
            this.computeWriteAccessForEachOperator(operator);
        } else if (isArithmethicAssign) {
            this.computeWriteAccessArithmeticAssign(operator);
        } else if (isEventTrigger || isIncrementOrDecrement) {
            this.computeWriteAccessEventTriggerIncrementDecrementOperator(operator, isIncrementOrDecrement);
        } else if (hasAssignQualifier || isProceduralForceAssign || isProceduralContinuousAssign) {
            this.computeWriteAccessInAssigns(operator);
        }
        return true;
    }

    private void computeWriteAccessInAssigns(RfHidOperator operator) {
        HidOccurrence occ;
        HidMatch hidMatch;
        Set lhHids = HidUtils.flattenToUniqueHids((IHidObject)operator.getLHValue(), FLATTENING_OPTIONS);
        Set rhHids = HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidMatch hidMatch2;
            HidOccurrence occ2 = hid.getOccurrence();
            if (occ2 == null || !SignalReadWriteVisitor.isLeftHandSide(occ2, operator) && !operator.isRelease() && !operator.isDeassign() || (hidMatch2 = this.getHidMatchIncludingParent(hid)) == null) continue;
            hidMatch2.addWriteOccurence(occ2, operator.hasOccurrence(DEFPARAM_QUALIFIERS));
            hidMatch2.setConnectedElements(this.getConnectedElements(rhHids));
        }
        for (IHid hid : rhHids) {
            hidMatch = this.getHidMatchIncludingParent(hid);
            if (hidMatch == null) continue;
            occ = hid.getOccurrence();
            if (hidMatch.getAccess() == RWKind.WRITE) {
                hidMatch.addReadOccurence(occ);
            }
            hidMatch.setConnectedElements(this.getConnectedElements(lhHids));
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_ALIAS_QUALIFIER)) {
            for (IHid hid : rhHids) {
                hidMatch = this.rwMap.get(hid);
                if (hidMatch == null) continue;
                occ = hid.getOccurrence();
                if (!VlogRfReferencesUtils.canBeReadOrWritten((IRfNamedElement)hid.getElement())) continue;
                boolean isAliasBetweenPorts = true;
                for (IHid otherHid : rhHids) {
                    if (otherHid == hid || VlogRfReferencesUtils.canBeReadOrWritten((IRfNamedElement)otherHid.getElement())) continue;
                    isAliasBetweenPorts = false;
                    break;
                }
                if (!isAliasBetweenPorts) continue;
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
            }
        }
    }

    private Set<SearchHitConnectedElementInfo> getConnectedElements(Set<IHid> lhHids) {
        LinkedHashSet<SearchHitConnectedElementInfo> connectedElements = new LinkedHashSet<SearchHitConnectedElementInfo>();
        for (IHid lhHid : lhHids) {
            IRfNamedElement element = lhHid.getElement();
            int line = lhHid.getLine();
            int offset = lhHid.getOffset();
            if (element == null) continue;
            connectedElements.add(new SearchHitConnectedElementInfo(element, line, offset, this.fParserPath));
        }
        return connectedElements;
    }

    private HidMatch getHidMatchIncludingParent(IHid hid) {
        HidMatch hidMatch = this.rwMap.get(hid);
        if (hidMatch != null) {
            return hidMatch;
        }
        IHid parentHid = hid.getParentHid();
        while (parentHid != null) {
            if (this.rwMap.get(parentHid) != null && VlogRfReferencesUtils.isStructField(parentHid)) {
                return this.rwMap.get(parentHid);
            }
            parentHid = parentHid.getParentHid();
        }
        return null;
    }

    private void computeWriteAccessEventTriggerIncrementDecrementOperator(RfHidOperator operator, boolean isIncrementOrDecrement) {
        Set lhHids = HidUtils.flattenToUniqueHids((IHidObject)operator.getLHValue(), FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null) continue;
            HidOccurrence occ = hid.getOccurrence();
            if (isIncrementOrDecrement) {
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
                hidMatch.setConnectedElements(this.getConnectedElements(HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), FLATTENING_OPTIONS)));
                continue;
            }
            if (!this.isContained(occ, operator)) continue;
            hidMatch.addWriteOccurence(occ);
            hidMatch.setConnectedElements(this.getConnectedElements(HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), FLATTENING_OPTIONS)));
        }
    }

    private void computeWriteAccessArithmeticAssign(RfHidOperator operator) {
        Set lhHids = HidUtils.flattenToUniqueHids((IHidObject)operator.getLHValue(), FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidOccurrence occ;
            HidMatch hidMatch = this.getHidMatchIncludingParent(hid);
            if (hidMatch == null || !SignalReadWriteVisitor.isLeftHandSide(occ = hid.getOccurrence(), operator)) continue;
            hidMatch.addReadOccurence(occ);
            hidMatch.addWriteOccurence(occ);
            hidMatch.setConnectedElements(this.getConnectedElements(HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), FLATTENING_OPTIONS)));
        }
        LinkedHashSet<IRfNamedElement> elements = new LinkedHashSet<IRfNamedElement>();
        Set rHids = HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), FLATTENING_OPTIONS);
        for (IHid hid : rHids) {
            HidMatch hidMatch = this.getHidMatchIncludingParent(hid);
            if (hidMatch == null) continue;
            for (IHid lhHid : lhHids) {
                IRfNamedElement element = lhHid.getElement();
                if (element == null) continue;
                elements.add(element);
            }
            hidMatch.setConnectedElements(this.getConnectedElements(lhHids));
        }
    }

    private void computeWriteAccessForEachOperator(RfHidOperator operator) {
        IHidObject lhValue = operator.getLHValue();
        if (!(lhValue instanceof RfHidAccess)) {
            return;
        }
        RfHidAccess lhAccess = (RfHidAccess)lhValue;
        List selectHidObjects = lhAccess.getSelects();
        if (selectHidObjects == null || selectHidObjects.isEmpty()) {
            return;
        }
        for (IHidObject selectHidObject : selectHidObjects) {
            HidOperator selectHidOperator;
            Set rhHids;
            if (HidUtils.isHid((IHidObject)selectHidObject)) {
                Hid selectHid = (Hid)selectHidObject;
                HidMatch hidMatch = this.rwMap.get(selectHid);
                if (hidMatch == null) continue;
                HidOccurrence occ = selectHid.getOccurrence();
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
                continue;
            }
            if (!HidUtils.isOperator((IHidObject)selectHidObject) || (rhHids = HidUtils.flattenToUniqueHids((List)OptimizedUtils.asList((ListContainer)(selectHidOperator = (HidOperator)selectHidObject).getRHValues(), (boolean)false), FLATTENING_OPTIONS)) == null || rhHids.isEmpty()) continue;
            for (IHid rhHid : rhHids) {
                HidMatch hidMatch = this.rwMap.get(rhHid);
                if (hidMatch == null) continue;
                HidOccurrence occ = rhHid.getOccurrence();
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
            }
        }
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    private static boolean isLeftHandSide(HidOccurrence occ, RfHidOperator operator) {
        int operatorOffset = operator.getOccurrence().getOffset();
        int operatorOpenBoundary = operator.getOpenBoundary();
        int occurrenceOffset = occ.getOffset();
        int operatorVirtualOffset = operator.getOccurrence().getVirtualOffset();
        int occurrenceVirtualOffset = occ.getVirtualOffset();
        if (occurrenceVirtualOffset != -1 && operatorVirtualOffset != -1) {
            return occurrenceVirtualOffset < operatorVirtualOffset;
        }
        return occurrenceOffset < operatorOffset && occurrenceOffset >= operatorOpenBoundary;
    }

    private boolean isContained(HidOccurrence hidOcc, HidOperator op) {
        return hidOcc.getOffset() > op.getOpenBoundary() && hidOcc.getOffset() < op.getCloseBoundary();
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

