/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseCategoryFilteredFileSearchPage;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.text.CategoryFilterConfig;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceHidSearchQuery;
import ro.amiq.vlogdt.ui.search.text.FileLabelProvider;
import ro.amiq.vlogdt.ui.search.text.FileTreeContentProvider;
import ro.amiq.vlogdt.ui.search.text.SearchMatchKindLineElement;

public class FileSearchPage
extends BaseCategoryFilteredFileSearchPage
implements IAdaptable,
IFilterableView {
    private static final String SEE_DESIGN_INSTANCE_PATH_MESSAGE = "<a href=\"dummy\">See {0} for current breadcrumb instance path: </a>{1}";
    private static final String SEE_ALL_MATCHES_MESSAGE = "<a href=\"dummy\">See all {0}</a>";
    private static final String HIDE_REFERENCES_TO_OVERRIDDEN = "Hide References to Overridden";
    private static final String SHOW_ALL_SPECIALIZATIONS = "All specializations";
    private static final String HIDE_REFERENCES_TO_GETTER_SETTER = "Hide References to Getter/Setter";
    private static final String HIDE_REFERENCES_TO_UNELABORATED = "Hide Unelaborated Design References";
    private static final String HIDE_REFERENCES_OUTSIDE_CURRENT_DESIGN_CONTEXT = "Hide references outside current Design Instance Path";
    private Link link;
    private GridData linkGridData;
    private Composite linkParent;
    private static final CategoryFilterConfig HIDE_REFERENCES_OUTSIDE_CURRENT_DESIGN_CONTEXT_CONFIG = new CategoryFilterConfig("Hide references outside current Design Instance Path", "search.view.vlogdt.hide_references_ouside_instance_path"){

        public boolean filter(LineElement lineElement) {
            return lineElement.isOutsideCurrentDesignContext();
        }

        public boolean isHidden() {
            return true;
        }
    };
    private static final CategoryFilterConfig REFERENCES_TO_OVERRIDDEN_FILTER_CONFIG = new CategoryFilterConfig("Hide References to Overridden", "search.view.vlogdt.hide_references_to_overriden"){

        public boolean filter(LineElement lineElement) {
            if (!(lineElement instanceof SearchMatchKindLineElement)) {
                return false;
            }
            return ((SearchMatchKindLineElement)lineElement).isFunctionCallInherited();
        }
    };
    private static final CategoryFilterConfig UNELABORATED_FILTER_CONFIG = new CategoryFilterConfig("Hide Unelaborated Design References", "search.view.vlogdt.hide_unelaborated"){

        public boolean filter(LineElement lineElement) {
            return lineElement.isInUnelaboratedCode();
        }
    };
    private static final CategoryFilterConfig REFERENCES_TO_NON_TYPE_MATCHING_FILTER_CONFIG = new CategoryFilterConfig("All specializations", "search.view.vlogdt.hide_non_type_matching_specializations"){

        public boolean filter(LineElement lineElement) {
            if (!(lineElement instanceof SearchMatchKindLineElement)) {
                return false;
            }
            return ((SearchMatchKindLineElement)lineElement).isNonTypeCompatibleMatch();
        }
    };
    private static final CategoryFilterConfig REFERENCES_TO_GETTER_SETTER_FILTER_CONFIG = new CategoryFilterConfig("Hide References to Getter/Setter", "search.view.vlogdt.hide_references_to_getter_setter"){

        public boolean filter(LineElement lineElement) {
            return lineElement.isGetterAccess() || lineElement.isSetterAccess();
        }
    };

    protected BaseFileLabelProvider makeLabelProvider(BaseFileSearchPage page, int orderFlag, ILabelDecorator decorator) {
        return new FileLabelProvider((AbstractTextSearchViewPage)page, orderFlag, decorator);
    }

    protected IContentProvider makeFileTreeContentProvider(BaseFileSearchPage page, TreeViewer viewer, BaseFileLabelProvider innerLabelProvider) {
        return new FileTreeContentProvider(page, (AbstractTreeViewer)viewer, innerLabelProvider);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.addHyperlinkForReadersWriters();
    }

    private void addHyperlinkForReadersWriters() {
        Composite parent;
        this.linkParent = parent = this.getSearchContainer();
        this.linkGridData = new GridData(4, 128, true, false);
        this.link = new Link(parent, 0);
        this.link.moveAbove((Control)this.fTextFilter.getControl());
        this.link.setLayoutData((Object)this.linkGridData);
        this.link.setText(SEE_ALL_MATCHES_MESSAGE);
        this.linkGridData.exclude = true;
        this.link.setVisible(false);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = !PrefConst.getSearchViewVlogdtHideReferencesOutsideDesignContext();
                PrefConst.setSearchViewVlogdtHideReferencesOutsideDesignContext((boolean)newState);
                FileSearchPage.this.refresh(true);
            }
        });
    }

    public void refresh(boolean selectFirstMatch, boolean triggeredFromSetInput) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return;
        }
        ISearchQuery query = result.getQuery();
        if (query instanceof ReferenceHidSearchQuery) {
            this.changeHyperlinkState((ReferenceHidSearchQuery)query);
        }
        super.refresh(selectFirstMatch, triggeredFromSetInput);
    }

    private void changeHyperlinkState(ReferenceHidSearchQuery query) {
        boolean isVisible = query.hasDesignContextPath();
        this.linkGridData.exclude = !isVisible;
        this.link.setVisible(isVisible);
        if (!isVisible) {
            this.linkParent.layout();
            return;
        }
        boolean seeAllMatchesLabel = HIDE_REFERENCES_OUTSIDE_CURRENT_DESIGN_CONTEXT_CONFIG.isEnabled();
        if (seeAllMatchesLabel) {
            this.link.setText(query.getLabelForHyperlink(SEE_ALL_MATCHES_MESSAGE, seeAllMatchesLabel));
        } else {
            this.link.setText(query.getLabelForHyperlink(SEE_DESIGN_INSTANCE_PATH_MESSAGE, seeAllMatchesLabel));
        }
        this.linkParent.layout();
    }

    protected List<CategoryFilterConfig> getFilterConfigs() {
        ArrayList<CategoryFilterConfig> result = new ArrayList<CategoryFilterConfig>();
        result.add(REFERENCES_TO_NON_TYPE_MATCHING_FILTER_CONFIG);
        result.add(POST_CONFIG_MATCH_CONFIG);
        result.add(POSSIBLE_MATCH_CONFIG);
        result.add(HIDE_REFERENCES_OUTSIDE_CURRENT_DESIGN_CONTEXT_CONFIG);
        result.add(REFERENCES_TO_GETTER_SETTER_FILTER_CONFIG);
        result.add(REFERENCES_TO_OVERRIDDEN_FILTER_CONFIG);
        result.add(UNELABORATED_FILTER_CONFIG);
        return result;
    }
}

