/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.vlogdt.ui.search.NewTextSearchEngine;
import ro.amiq.vlogdt.ui.search.text.FileSearchResult;
import ro.amiq.vlogdt.ui.search.text.TextSearchResultCollector;

public class FileSearchQuery
extends BaseFileSearchQuery {
    protected boolean fForRefactor;
    protected boolean fIsStrictVirtualFunction;

    public FileSearchQuery(String searchType, String searchText, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, boolean isOnlyCompiled, int searchFor, boolean forRefactoring, boolean isStrictVirtualFunction) {
        super(searchType, searchText, searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, includeDeclarations, isOnlyCompiled, searchFor);
        this.fForRefactor = forRefactoring;
        this.fIsStrictVirtualFunction = isStrictVirtualFunction;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status;
        boolean searchInBinaries;
        Pattern searchPattern;
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        if (!this.isAccumulateResults()) {
            textResult.removeAll();
        }
        boolean isFileSearchOnly = (searchPattern = this.getSearchPattern()).pattern().length() == 0;
        boolean bl = searchInBinaries = !this.isScopeAllFileTypes();
        if (this.fCollector == null) {
            this.fCollector = new TextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
        }
        try {
            status = new NewTextSearchEngine(this.fLimitTo, this.fSearchFor, this.getSearchType(), this.fIncludeDeclarations, this.fOnlyCompiled).search((TextSearchScope)this.getScope(), this.fCollector, searchPattern, monitor);
        }
        finally {
            this.fCollector = null;
        }
        return status;
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{file}, (String[])new String[]{"*"}, (boolean)true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(result, isFileSearchOnly, true);
        return new NewTextSearchEngine(this.fLimitTo, this.fSearchFor, this.getSearchType(), this.fIncludeDeclarations, this.fOnlyCompiled).search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery baseSearchQuery) {
        return new FileSearchResult(baseSearchQuery);
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_verilog_label;
    }
}

