/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.smartcopy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyMorpher;
import ro.amiq.dvt.ui.smartcopy.IllegalMorphException;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.smartcopy.model.ISCModuleElement;
import ro.amiq.dvt.ui.smartcopy.model.ISCObject;
import ro.amiq.dvt.ui.smartcopy.model.ISCParameter;
import ro.amiq.dvt.ui.smartcopy.model.ISCPortData;
import ro.amiq.dvt.ui.smartcopy.model.ISCPortDirection;
import ro.amiq.dvt.ui.smartcopy.model.ISCVlogPort;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.ui.smartcopy.model.SCChecker;
import ro.amiq.vlogdt.ui.smartcopy.model.SCDesign;
import ro.amiq.vlogdt.ui.smartcopy.model.SCInterface;
import ro.amiq.vlogdt.ui.smartcopy.model.SCInterfacePort;
import ro.amiq.vlogdt.ui.smartcopy.model.SCModule;
import ro.amiq.vlogdt.ui.smartcopy.model.SCObject;
import ro.amiq.vlogdt.ui.smartcopy.model.SCParameter;
import ro.amiq.vlogdt.ui.smartcopy.model.SCPort;
import ro.amiq.vlogdt.ui.smartcopy.model.SCPortData;
import ro.amiq.vlogdt.ui.smartcopy.model.SCProgram;

public class SmartCopyMorpher
implements ISmartCopyMorpher,
ISCPortDirection {
    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public ISCObject getGeneralForm(IRfScopeElement scope, LanguageKind lang) {
        try {
            SmartCopyMorpher.checkNonNull(scope, lang);
            if (lang != this.getLanguageKind()) {
                SmartCopyMorpher.exception();
            }
            if (!(scope instanceof RfDefElement)) {
                SmartCopyMorpher.exception();
            }
            SCDesign result = null;
            RfNamedElement elem = ((RfDefElement)scope).getNamedElement();
            if (elem instanceof RfModule) {
                result = new SCModule(elem);
            } else if (elem instanceof RfInterface) {
                result = new SCInterface(elem);
            } else if (elem instanceof RfChecker) {
                result = new SCChecker(elem);
            } else if (elem instanceof RfProgram) {
                result = new SCProgram(elem);
            }
            return result;
        }
        catch (IllegalMorphException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return null;
        }
    }

    private static void exception() {
        throw new IllegalMorphException();
    }

    private static void checkNonNull(Object ... args) {
        SmartCopyUtilsCommon.checkNonNullMorph((Object[])args);
    }

    protected static String escape(String text) {
        return SmartCopyUtilsCommon.escapeTemplateText((String)text);
    }

    public static String morphName(Object origin) {
        String name;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof IRfNamedElement)) {
            SmartCopyMorpher.exception();
        }
        if ((name = ((IRfNamedElement)origin).getName()) == null) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(name);
    }

    public static String morphPortDirection(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        String direction = ((RfPort)origin).getDirectionString();
        boolean hasDirection = false;
        ISCPortDirection.VLOG_DIRECTION[] vLOG_DIRECTIONArray = ISCPortDirection.VLOG_DIRECTION.values();
        int n = vLOG_DIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCPortDirection.VLOG_DIRECTION dir = vLOG_DIRECTIONArray[n2];
            hasDirection = dir.getNiceName().equals(direction);
            if (hasDirection) break;
            ++n2;
        }
        if (!hasDirection) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(direction);
    }

    public static ISCPortData morphPortData(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        if (((RfPort)origin).getDataType() == null) {
            SmartCopyMorpher.exception();
        }
        return new SCPortData(origin);
    }

    public static ISCModuleElement morphPortInterface(Object origin) {
        RfPort rfPort;
        IRfNamedElement associatedBaseType;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort) || !((RfPort)origin).isInterfacePort()) {
            SmartCopyMorpher.exception();
        }
        if ((associatedBaseType = (rfPort = (RfPort)origin).getResolvedType(true)) instanceof RfModport) {
            associatedBaseType = ((RfModport)associatedBaseType).getEnclosingScope();
        }
        if (!(associatedBaseType instanceof IRfDesignElement)) {
            return null;
        }
        return new SCInterface(associatedBaseType);
    }

    public static String morphPortDataType(Object origin) {
        RfPort lPort;
        String implicitSpecificTypeName;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        if ((implicitSpecificTypeName = (lPort = (RfPort)origin).implicitSpecificTypeName()) == null) {
            implicitSpecificTypeName = RfBitVectorScalarType.REG.getName();
        }
        String type = lPort.getDataType().getScopeAndTypeName(implicitSpecificTypeName).trim();
        return SmartCopyMorpher.escape(type);
    }

    public static String morphPortDataNetType(Object origin) {
        RfPort lPort;
        String nettype;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        if ((nettype = (lPort = (RfPort)origin).getDataType().getNetType()) == null && lPort.isNet()) {
            nettype = lPort.implicitSpecificNetType();
        }
        return SmartCopyMorpher.escape(nettype);
    }

    public static String morphPortDataPackedDimension(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(((RfPort)origin).getPackedDimension());
    }

    public static String morphPortDataUnpackedDimension(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(((RfPort)origin).getUnpackedDimension());
    }

    public static String morphPortDataSign(Object origin) {
        byte sign;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        if ((sign = ((RfPort)origin).getDataType().getSign()) != 0 && sign != 1 && sign != 2) {
            SmartCopyMorpher.exception();
        }
        return sign == 0 ? "" : (sign == 1 ? "signed" : "unsigned");
    }

    public static List<ISCVlogPort> morphModulePorts(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof IRfDesignElement)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCObject> mPorts = new ArrayList<SCObject>();
        SCPort mPort = null;
        IRfDesignElement lModule = (IRfDesignElement)origin;
        List lPorts = lModule.getPortsWithPrefix("", 2);
        if (lPorts != null) {
            for (IRfPortElement lPort : lPorts) {
                try {
                    if (lPort.isInterfacePort()) {
                        SCInterfacePort lInterfacePort = new SCInterfacePort(lPort);
                        mPorts.add(lInterfacePort);
                        continue;
                    }
                    mPort = new SCPort(lPort);
                    mPorts.add(mPort);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mPorts);
    }

    public static List<ISCParameter> morphModuleParameters(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof IRfDesignElement)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCParameter> mParameters = new ArrayList<SCParameter>();
        SCParameter mParameter = null;
        IRfDesignElement lModule = (IRfDesignElement)origin;
        List lParameters = lModule.getLocalParameters();
        if (lParameters != null) {
            for (IRfNamedElement lParameter : lParameters) {
                if (!(lParameter instanceof RfField) || RfField.ParameterKind.PARAMETER != ((RfField)lParameter).getParameterKind()) continue;
                try {
                    mParameter = new SCParameter(lParameter);
                    mParameters.add(mParameter);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mParameters);
    }

    public static String morphParameterInitialValue(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfField)) {
            SmartCopyMorpher.exception();
        }
        String initialValue = ((RfField)origin).getInitialValue(false);
        return SmartCopyMorpher.escape(initialValue);
    }

    public static boolean morphParameterIsLocal(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfField)) {
            SmartCopyMorpher.exception();
        }
        return ((RfField)origin).isLocalParameter();
    }

    public static List<ISCVlogPort> morphPrimitivePorts(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPrimitive)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCPort> mPorts = new ArrayList<SCPort>();
        SCPort mPort = null;
        RfPrimitive lPrimitive = (RfPrimitive)origin;
        List<RfPort> lPorts = lPrimitive.getPortsWithPrefix("", 2);
        if (lPorts != null) {
            for (RfPort lPort : lPorts) {
                try {
                    mPort = new SCPort(lPort);
                    mPorts.add(mPort);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mPorts);
    }

    public static List<ISCParameter> morphPrimitiveParameters(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPrimitive)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCParameter> mParameters = new ArrayList<SCParameter>();
        SCParameter mParameter = null;
        RfPrimitive lPrimitive = (RfPrimitive)origin;
        List<RfField> lParameters = lPrimitive.getLocalParameters(128);
        if (lParameters != null) {
            for (RfField lParameter : lParameters) {
                try {
                    mParameter = new SCParameter(lParameter);
                    mParameters.add(mParameter);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mParameters);
    }
}

