/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.smartcopy.model;

import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.smartcopy.model.ISCPortData;
import ro.amiq.dvt.ui.smartcopy.model.SCAbstractObject;
import ro.amiq.vlogdt.ui.smartcopy.SmartCopyMorpher;

public class SCPortData
extends SCAbstractObject
implements ISCPortData {
    public String type;
    public String nettype;
    public String packedDimension;
    public String unpackedDimension;
    public String sign;

    public SCPortData(Object origin) {
        SmartCopyUtilsCommon.checkNonNullMorph((Object[])new Object[]{origin});
        this.origin = origin;
    }

    public String getType() {
        try {
            if (this.type == null) {
                this.type = SmartCopyMorpher.morphPortDataType(this.origin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.type);
    }

    public String getNetType() {
        try {
            if (this.nettype == null) {
                this.nettype = SmartCopyMorpher.morphPortDataNetType(this.origin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.nettype);
    }

    public String getPackedDimension() {
        try {
            if (this.packedDimension == null) {
                this.packedDimension = SmartCopyMorpher.morphPortDataPackedDimension(this.origin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.packedDimension);
    }

    public String getUnpackedDimension() {
        try {
            if (this.unpackedDimension == null) {
                this.unpackedDimension = SmartCopyMorpher.morphPortDataUnpackedDimension(this.origin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.unpackedDimension);
    }

    public String getSign() {
        try {
            if (this.sign == null) {
                this.sign = SmartCopyMorpher.morphPortDataSign(this.origin);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.sign);
    }

    public boolean hasPackedDimension() {
        this.getPackedDimension();
        return SmartCopyUtilsCommon.hasField((String)this.packedDimension);
    }

    public boolean hasUnpackedDimension() {
        this.getUnpackedDimension();
        return SmartCopyUtilsCommon.hasField((String)this.unpackedDimension);
    }

    public boolean hasSign() {
        this.getSign();
        return SmartCopyUtilsCommon.hasField((String)this.sign);
    }
}

