/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.vlogdt.model.problems.Bridge;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.ui.syntaxerrors.SyntaxErrorsManagerCommon;

public class SyntaxErrorsManager
extends SyntaxErrorsManagerCommon {
    private static SyntaxErrorsManager fInstance;

    private SyntaxErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(VlogProblemCategories.SVLOG_SYNTAX));
    }

    public static SyntaxErrorsManager getInstance() {
        if (fInstance == null) {
            fInstance = new SyntaxErrorsManager();
        }
        return fInstance;
    }

    @Override
    public void updateProblemsUI(IProject project, List<VlogProblem> unreportedErrors) {
        for (VlogProblem error : unreportedErrors) {
            DVTProblemManager.getInstance().reportProblem(Bridge.from(project, error, error.getFileName(), true));
        }
        DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).updateOutsideErrors(project);
    }

    @Override
    public void updateProblemsUI(IFile file, int buildKind) {
        DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).update(file, buildKind == 1);
    }

    @Override
    protected String getFilePath(IFile file) {
        IPath location = file.getLocation();
        if (location == null) {
            return "";
        }
        return BaseUtils.canonicPath((IPath)location);
    }
}

