/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.vlogdt.model.IVlogModel;
import ro.amiq.vlogdt.model.IVlogReparseListener;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.problems.Bridge;
import ro.amiq.vlogdt.parser.VlogProblem;

public abstract class SyntaxErrorsManagerCommon
implements IVlogReparseListener {
    public void startup() {
        VlogModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        VlogModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if ((type & 2) == 0 && (type & 4) == 0) {
            return;
        }
        if (resource == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return;
        }
        IFile file = (IFile)resource;
        String filePath = this.getFilePath(file);
        IVlogModel vlogModel = VlogModelManager.getInstance().getVlogModel();
        if (vlogModel == null) {
            return;
        }
        if (vlogModel.getIDVTFile(file) != null) {
            DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, VlogProblemCategories.SVLOG_SYNTAX, filePath);
        }
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                DVTProblemManager.getInstance().reportProblem(Bridge.from(project, (VlogProblem)error, filePath, buildKind == 1));
            }
        }
        if (warnings != null && !warnings.isEmpty()) {
            for (Object warning : warnings) {
                DVTProblemManager.getInstance().reportProblem(Bridge.from(project, (VlogProblem)warning, filePath, buildKind == 1));
            }
        }
        this.updateProblemsUI(file, buildKind);
    }

    public abstract void updateProblemsUI(IFile var1, int var2);

    public abstract void updateProblemsUI(IProject var1, List<VlogProblem> var2);

    protected abstract String getFilePath(IFile var1);
}

