/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.views.templates;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogTemplateContentAssistProcessor;
import ro.amiq.vlogdt.ui.views.templates.VlogBaseTemplateConfig;

public abstract class VlogBaseTemplateInserterCommon {
    protected VlogBaseTemplateConfig<?> config;

    protected VlogBaseTemplateInserterCommon(VlogBaseTemplateConfig<?> config) {
        this.config = config;
    }

    protected abstract DocumentTemplateContext getContext();

    protected abstract Template getTemplate();

    protected Template getDefaultTemplate() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream fileStream = JarUtils.getFileStream((String)"/templates/vlog.xml", VlogTemplateContentAssistProcessor.class);){
                TemplatePersistenceData[] templateData = new TemplateReaderWriter().read(fileStream, null);
                return Stream.of(templateData).map(TemplatePersistenceData::getTemplate).filter(template -> template.getName().equals(this.config.getTemplate())).findFirst().orElse(null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected TemplateBuffer handleTemplateEvaluateError(Exception e) {
        DVTLogger.INSTANCE.logError((Throwable)e);
        return null;
    }

    public String parse() {
        TemplateBuffer templateBuffer;
        block16: {
            Template template;
            Template template2 = template = this.config.isUseDefaultTemplate() ? this.getDefaultTemplate() : this.getTemplate();
            if (template == null) {
                return "";
            }
            try {
                templateBuffer = this.getContext().evaluate(template);
            }
            catch (BadLocationException | TemplateException e) {
                templateBuffer = this.handleTemplateEvaluateError((Exception)e);
                if (templateBuffer != null) break block16;
                return "";
            }
        }
        if (templateBuffer == null) {
            return "";
        }
        String evaluation = templateBuffer.getString();
        StringBuilder parsedEvaluation = new StringBuilder();
        TemplateVariable[] variables = templateBuffer.getVariables();
        HashMap<Integer, Integer> variablePositions = new HashMap<Integer, Integer>();
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            int[] nArray = variable.getOffsets();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int offset = nArray[n4];
                variablePositions.put(offset, variable.getLength());
                ++n4;
            }
            ++n2;
        }
        int currentEvaluationIndex = 0;
        boolean lastJavadocIsEmpty = false;
        Matcher matcher = DVTStringUtil.JAVADOC.matcher(evaluation);
        if (matcher.find()) {
            int groupStart = matcher.start();
            int groupEnd = matcher.end();
            if (currentEvaluationIndex < groupStart) {
                parsedEvaluation.append(this.parseNormal(evaluation.substring(currentEvaluationIndex, groupStart), currentEvaluationIndex, variablePositions, lastJavadocIsEmpty));
            }
            String javadoc = this.parseJavadoc(evaluation.substring(groupStart, groupEnd), groupStart, variablePositions);
            parsedEvaluation.append(javadoc);
            lastJavadocIsEmpty = javadoc.isEmpty();
            currentEvaluationIndex = groupEnd;
        }
        if (currentEvaluationIndex < evaluation.length()) {
            parsedEvaluation.append(this.parseNormal(evaluation.substring(currentEvaluationIndex), currentEvaluationIndex, variablePositions, lastJavadocIsEmpty));
        }
        String lineDelimiter = this.config.getLineDelimiter();
        int i = 0;
        while (i < -this.config.getLeadingNewlines()) {
            if (parsedEvaluation.indexOf(lineDelimiter) != 0) break;
            parsedEvaluation.delete(0, lineDelimiter.length());
            ++i;
        }
        i = 0;
        while (i < -this.config.getTrailingNewlines()) {
            int lastIndex = parsedEvaluation.lastIndexOf(lineDelimiter);
            if (lastIndex != parsedEvaluation.length() - lineDelimiter.length()) break;
            parsedEvaluation.delete(lastIndex, parsedEvaluation.length());
            ++i;
        }
        parsedEvaluation = new StringBuilder(DVTStringUtil.mapSplitLines((String)parsedEvaluation.toString(), (String)lineDelimiter, (line, index) -> {
            if (index == 0 && !this.config.isIndentFirstLine()) {
                return line;
            }
            if (!line.isEmpty() || this.config.isIndentNewlines()) {
                return String.valueOf(this.config.getIndent()) + line;
            }
            return "";
        }));
        if (this.config.isIndentStepOnFirstLine()) {
            parsedEvaluation.insert(0, this.config.getIndentStep());
        }
        StringBuilder leadingNewLinesBuilder = new StringBuilder();
        int i2 = 0;
        while (i2 < this.config.getLeadingNewlines()) {
            leadingNewLinesBuilder.append(lineDelimiter);
            ++i2;
        }
        if (leadingNewLinesBuilder.length() != 0) {
            parsedEvaluation.insert(0, leadingNewLinesBuilder.toString());
        }
        i2 = 0;
        while (i2 < this.config.getTrailingNewlines()) {
            parsedEvaluation.append(lineDelimiter);
            ++i2;
        }
        if (this.config.getTrailingNewlines() >= 0 && this.config.isSecondaryIndentOnLastLine()) {
            parsedEvaluation.append(this.config.getSecondaryIndent());
        }
        return parsedEvaluation.toString();
    }

    private String parseNormal(String input, int startIndex, Map<Integer, Integer> variablePositions, boolean lastJavadocIsEmpty) {
        String lineDelimiter = this.config.getLineDelimiter();
        String[] lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)input, (int)-1);
        ArrayList<String> keptLines = new ArrayList<String>();
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            String line = lines[lineIndex];
            StringBuilder parsedLine = new StringBuilder();
            if (lineIndex != 0 || !lastJavadocIsEmpty || !line.isEmpty()) {
                LineStatus lineStatus = LineStatus.POTENTIAL_KEEP;
                int charIndex = 0;
                while (charIndex <= line.length()) {
                    int offset = startIndex + charIndex;
                    Integer variableLength = variablePositions.get(offset);
                    if (variableLength != null) {
                        if (variableLength > 0) {
                            lineStatus = LineStatus.KEEP;
                        } else if (lineStatus == LineStatus.POTENTIAL_KEEP) {
                            lineStatus = LineStatus.POTENTIAL_SKIP;
                        }
                    }
                    if (charIndex != line.length()) {
                        char c = line.charAt(charIndex);
                        boolean isWhitespace = Character.isWhitespace(c);
                        if (!isWhitespace || variableLength == null || variableLength > 0) {
                            parsedLine.append(c);
                        }
                        if (!isWhitespace) {
                            lineStatus = LineStatus.KEEP;
                        }
                    }
                    ++charIndex;
                }
                if (lineStatus != LineStatus.POTENTIAL_SKIP) {
                    keptLines.add(parsedLine.toString());
                }
            }
            startIndex += lines[lineIndex].length() + lineDelimiter.length();
            ++lineIndex;
        }
        return DVTStringUtil.join(keptLines, (String)lineDelimiter);
    }

    private String parseJavadoc(String input, int startIndex, Map<Integer, Integer> variablePositions) {
        String javadocReplacement = this.config.getJavadocReplacement();
        if (javadocReplacement != null) {
            return javadocReplacement;
        }
        String lineDelimiter = this.config.getLineDelimiter();
        String[] lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)input);
        ArrayList<String> keptLines = new ArrayList<String>();
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            String line = lines[lineIndex];
            if (lineIndex == 0 || lineIndex == lines.length - 1) {
                keptLines.add(line);
            } else {
                boolean keepLine = false;
                boolean javadocLineStartFound = false;
                int charIndex = 0;
                while (charIndex <= line.length()) {
                    char c;
                    int offset = startIndex + charIndex;
                    Integer variableLength = variablePositions.get(offset);
                    if (variableLength != null) {
                        if (variableLength > 0) {
                            keepLine = true;
                            break;
                        }
                    } else if (charIndex != line.length() && !Character.isWhitespace(c = line.charAt(charIndex))) {
                        if (c == '*' && !javadocLineStartFound) {
                            javadocLineStartFound = true;
                        } else {
                            keepLine = true;
                            break;
                        }
                    }
                    ++charIndex;
                }
                if (keepLine) {
                    keptLines.add(line);
                }
            }
            startIndex += lines[lineIndex].length() + lineDelimiter.length();
            ++lineIndex;
        }
        return DVTStringUtil.join(keptLines, (String)lineDelimiter);
    }

    static enum LineStatus {
        POTENTIAL_KEEP,
        POTENTIAL_SKIP,
        KEEP;

    }
}

