/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.views.templates;

import java.util.ArrayList;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.utils.VlogTemplateConfigUtils;
import ro.amiq.vlogdt.ui.views.templates.VlogBaseTemplateConfig;

public class VlogConstraintTemplateConfig
extends VlogBaseTemplateConfig<VlogConstraintTemplateConfig> {
    public static final String CONSTRAINT_IMPLEMENTATION_TEMPLATE = "constraint_implementation";
    public static final String CONSTRAINT_PROTOTYPE_TEMPLATE = "constraint_prototype";
    public static final String CONSTRAINT_OVERRIDE_IMPLEMENTATION_TEMPLATE = "constraint_override_implementation";
    private boolean staticQualifier;
    private String identifier = "";
    private String todoComment = "";
    private String bodyRelativeIndent = "";
    private String body = "";
    private RfNamedElement cursorScope;
    private RfConstraint constraint;
    private boolean isExternImplementation;
    private boolean isExplicit;

    @Override
    protected VlogConstraintTemplateConfig getThis() {
        return this;
    }

    public VlogConstraintTemplateConfig setConstraintInfo(RfConstraint constraint, boolean enforceStaticQualifier) {
        this.constraint = constraint;
        this.staticQualifier = constraint.isObjectStatic() || enforceStaticQualifier;
        this.identifier = String.valueOf(this.isExternImplementation() ? String.valueOf(this.cursorScope.getName()) + "::" : "") + constraint.getName();
        this.todoComment = String.valueOf(this.getIndentStep()) + "// TODO Auto-generated constraint stub";
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setExplicit(boolean isExplicit) {
        this.isExplicit = isExplicit;
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setCursorScope(RfNamedElement cursorScope) {
        this.cursorScope = cursorScope;
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setExternImplementation(boolean isExternImplementation) {
        this.isExternImplementation = isExternImplementation;
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setBodyRelativeIndent(String bodyRelativeIndent) {
        this.bodyRelativeIndent = bodyRelativeIndent;
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setBody(String body) {
        return this.setBody(body, true, false);
    }

    public VlogConstraintTemplateConfig setBody(String body, boolean useIndentStep, boolean removeLastNewline) {
        this.body = VlogTemplateConfigUtils.setBody(body, this, this.bodyRelativeIndent, useIndentStep, removeLastNewline);
        return this.getThis();
    }

    public VlogConstraintTemplateConfig setTodoComment(String todoComment) {
        this.todoComment = todoComment;
        return this.getThis();
    }

    public RfConstraint getConstraint() {
        return this.constraint;
    }

    public String getQualifiers() {
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (this.isExplicit) {
            qualifiers.add("extern");
        }
        if (this.staticQualifier) {
            qualifiers.add("static");
        }
        return DVTStringUtil.join(qualifiers, (String)" ");
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public RfNamedElement getCursorScope() {
        return this.cursorScope;
    }

    public String getTodoComment() {
        return this.todoComment;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isExternImplementation() {
        return this.isExternImplementation;
    }
}

