/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.views.templates;

import java.util.ArrayList;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.ui.editor.utils.VlogTemplateConfigUtils;
import ro.amiq.vlogdt.ui.views.templates.VlogBaseTemplateConfig;

public class VlogMethodTemplateConfig
extends VlogBaseTemplateConfig<VlogMethodTemplateConfig> {
    public static final String METHOD_PROTOTYPE_TEMPLATE = "method_prototype";
    public static final String METHOD_IMPLEMENTATION_TEMPLATE = "method_implementation";
    public static final String METHOD_OVERRIDE_BODY_TEMPLATE = "method_override_body";
    public static final String CONSTRUCTOR_IMPLEMENTATION_TEMPLATE = "constructor_implementation";
    private static final String GETTER_PREFIX = "get_";
    private static final String SETTER_PREFIX = "set_";
    private RfNamedElement cursorScope;
    private RfFunction function;
    private boolean virtualQualifier;
    private boolean staticQualifier;
    private String accessQualifier = "";
    private String kind = "";
    private String lifetime = "";
    private String returnType = "";
    private String unqualifiedIdentifier = "";
    private String identifier = "";
    private String arguments = "";
    private String argumentNames = "";
    private String todoComment = "";
    private String superCall = "";
    private String endKeyword = "";
    private String body = "";
    private String bodyRelativeIndent = "";
    private boolean virtualBeforeAccess;
    private boolean insertKeywords = true;
    private boolean isFromOverrideWizard;
    private boolean isExternImplementation;

    @Override
    protected VlogMethodTemplateConfig getThis() {
        return this;
    }

    public RfFunction getFunction() {
        return this.function;
    }

    public VlogMethodTemplateConfig setFunction(RfTypesResolver resolver, RfFunction function) {
        this.function = function;
        this.virtualQualifier = function.isVirtual();
        this.staticQualifier = function.isObjectStatic();
        String string = function.isPrivate() ? "local" : (this.accessQualifier = function.isProtected() ? "protected" : "");
        this.lifetime = function.hasStorageStaticQualifier() ? "static" : (function.hasStorageAutomaticQualifier() ? "automatic" : "");
        this.unqualifiedIdentifier = function.getName();
        this.identifier = String.valueOf(this.isExternImplementation ? String.valueOf(this.cursorScope.getName()) + "::" : "") + this.unqualifiedIdentifier;
        this.kind = function.isTask() ? "task" : "function";
        this.returnType = function.isTask() ? "" : VlogFunctionSignatureUtils.getFunctionType(resolver, function, this.cursorScope, this.isExternImplementation);
        this.arguments = function.printArguments(resolver, this.cursorScope, true, null, false, true, MethodSignatureUseCase.METHOD_OVERRIDE_CODE_GENERATION, false, true);
        this.argumentNames = function.printArguments(resolver, this.cursorScope, true, null, false, true, MethodSignatureUseCase.METHOD_CALL, false, true);
        this.todoComment = "// TODO Auto-generated " + (function.isConstructor() ? "constructor" : this.kind) + " stub";
        this.superCall = VlogFunctionSignatureUtils.computeSuperCall(this.cursorScope, function, this.isFromOverrideWizard, this.isExternImplementation, this.documentOffset, this.returnType);
        this.endKeyword = "end" + this.kind;
        return this.getThis();
    }

    public RfNamedElement getCursorScope() {
        return this.cursorScope;
    }

    public VlogMethodTemplateConfig setCursorScope(RfNamedElement cursorScope) {
        this.cursorScope = cursorScope;
        return this.getThis();
    }

    public boolean hasVirtualQualifier() {
        return this.virtualQualifier;
    }

    public VlogMethodTemplateConfig setVirtualQualifier(boolean virtualQualifier) {
        this.virtualQualifier = virtualQualifier;
        return this.getThis();
    }

    public boolean hasStaticQualifier() {
        return this.staticQualifier;
    }

    public VlogMethodTemplateConfig setStaticQualifier(boolean staticQualifier) {
        this.staticQualifier = staticQualifier;
        return this.getThis();
    }

    public String getAccessQualifier() {
        return this.accessQualifier;
    }

    public VlogMethodTemplateConfig setAccessQualifier(String accessQualifier) {
        this.accessQualifier = accessQualifier;
        return this.getThis();
    }

    public String getQualifiers() {
        if (this.isExternImplementation || !this.insertKeywords) {
            return "";
        }
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (!this.accessQualifier.isEmpty()) {
            qualifiers.add(this.accessQualifier);
        }
        if (this.virtualQualifier) {
            if (this.virtualBeforeAccess) {
                qualifiers.add(0, "virtual");
            } else {
                qualifiers.add("virtual");
            }
        }
        if (this.staticQualifier) {
            qualifiers.add("static");
        }
        return DVTStringUtil.join(qualifiers, (String)" ");
    }

    public String getKind() {
        if (!this.insertKeywords) {
            return "";
        }
        return this.kind;
    }

    public VlogMethodTemplateConfig setKind(String kind) {
        this.kind = kind;
        return this.getThis();
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public VlogMethodTemplateConfig setLifetime(String lifetime) {
        this.lifetime = lifetime;
        return this.getThis();
    }

    public String getReturnType() {
        return this.returnType;
    }

    public VlogMethodTemplateConfig setReturnType(String returnType) {
        this.returnType = returnType;
        return this.getThis();
    }

    public String getUnqualifiedIdentifier() {
        return this.unqualifiedIdentifier;
    }

    public VlogMethodTemplateConfig setUnqualifiedIdentifier(String unqualifiedIdentifier) {
        this.unqualifiedIdentifier = unqualifiedIdentifier;
        return this.getThis();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public VlogMethodTemplateConfig setIdentifier(String identifier) {
        this.identifier = identifier;
        return this.getThis();
    }

    public String getArguments() {
        return this.arguments;
    }

    public VlogMethodTemplateConfig setArguments(String arguments) {
        this.arguments = arguments;
        return this.getThis();
    }

    public String getArgumentNames() {
        return this.argumentNames;
    }

    public VlogMethodTemplateConfig setArgumentNames(String argumentNames) {
        this.argumentNames = argumentNames;
        return this.getThis();
    }

    public String getTodoComment() {
        return this.todoComment;
    }

    public VlogMethodTemplateConfig setTodoComment(String todoComment) {
        this.todoComment = todoComment;
        return this.getThis();
    }

    public String getSuperCall() {
        return this.superCall;
    }

    public VlogMethodTemplateConfig setSuperCall(String superCall) {
        this.superCall = superCall;
        return this.getThis();
    }

    public String getEndKeyword() {
        return this.endKeyword;
    }

    public VlogMethodTemplateConfig setEndKeyword(String endKeyword) {
        this.endKeyword = endKeyword;
        return this.getThis();
    }

    public String getBody() {
        return this.body;
    }

    public VlogMethodTemplateConfig setBody(String body) {
        return this.setBody(body, true, false);
    }

    public VlogMethodTemplateConfig setBody(String body, boolean useIndentStep, boolean removeLastNewline) {
        this.body = VlogTemplateConfigUtils.setBody(body, this, this.bodyRelativeIndent, useIndentStep, removeLastNewline);
        return this.getThis();
    }

    public String getBodyRelativeIndent() {
        return this.bodyRelativeIndent;
    }

    public VlogMethodTemplateConfig setBodyRelativeIndent(String bodyRelativeIndent) {
        this.bodyRelativeIndent = bodyRelativeIndent;
        return this.getThis();
    }

    public boolean isVirtualBeforeAccess() {
        return this.virtualBeforeAccess;
    }

    public VlogMethodTemplateConfig setVirtualBeforeAccess(boolean virtualBeforeAccess) {
        this.virtualBeforeAccess = virtualBeforeAccess;
        return this.getThis();
    }

    public boolean isInsertKeywords() {
        return this.insertKeywords;
    }

    public VlogMethodTemplateConfig setInsertKeywords(boolean insertKeywords) {
        this.insertKeywords = insertKeywords;
        return this.getThis();
    }

    public boolean isFromOverrideWizard() {
        return this.isFromOverrideWizard;
    }

    public VlogMethodTemplateConfig setFromOverrideWizard(boolean isFromOverrideWizard) {
        this.isFromOverrideWizard = isFromOverrideWizard;
        return this.getThis();
    }

    public boolean isExternImplementation() {
        return this.isExternImplementation;
    }

    public VlogMethodTemplateConfig setExternImplementation(boolean isExternImplementation) {
        this.isExternImplementation = isExternImplementation;
        return this.getThis();
    }

    public VlogMethodTemplateConfig fillGetterInfo(RfField field) {
        String fieldName = field.getName();
        this.unqualifiedIdentifier = this.identifier = GETTER_PREFIX + fieldName;
        this.returnType = RfListType.splitUnpackedDimesnions(this.getFieldTypeName(field))[0];
        this.setBody("return " + fieldName + ";");
        this.setJavadocReplacement("// Get " + fieldName);
        return this.getThis();
    }

    public VlogMethodTemplateConfig fillSetterInfo(RfField field) {
        String fieldName = field.getName();
        this.unqualifiedIdentifier = this.identifier = SETTER_PREFIX + fieldName;
        this.returnType = "void";
        String[] splitTypeName = RfListType.splitUnpackedDimesnions(this.getFieldTypeName(field));
        this.arguments = String.valueOf(splitTypeName[0]) + " " + fieldName + splitTypeName[1];
        this.setBody("this." + fieldName + " = " + fieldName + ";");
        this.setJavadocReplacement("// Set " + fieldName);
        return this.getThis();
    }

    private String getFieldTypeName(RfField field) {
        IRfNamedElement fieldType = field.getAssociatedType(RfTypesResolver.create(RfTypesResolver.create((IRfScopeElement)field.getEnclosingScope(), field.getRfProject(), 14)));
        DataType fieldDataType = null;
        fieldDataType = fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum() ? ((RfStruct)fieldType).getEnumBaseDataType() : field.getDataType();
        String typeName = fieldDataType.getTypeName("", "", field.getFile().getParserPath(), false, true, true);
        return typeName == null || typeName.isEmpty() ? "void" : typeName;
    }
}

