/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.preproc.PreprocConst;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTConnectPositionToDocumentProvider;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.EncryptedPragmaInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.highlight.VlogSemanticHighlighter;
import ro.amiq.vlogdt.utils.UtilsCommon;

public class Utils
extends UtilsCommon {
    private static Utils fInstance;

    public static synchronized Utils getInstance() {
        if (fInstance == null) {
            fInstance = new Utils();
        }
        return fInstance;
    }

    @Override
    protected void connectInactiveCodePositions(IDocument document, RfFileDef fileDef) {
        this.addInactiveCodePositions(document, fileDef);
        ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
    }

    public void addInactiveCodePositions(IDocument document, RfFileDef fileDef) {
        try {
            if (document.containsPositionCategory("__dvt_inactive_code_position")) {
                document.removePositionCategory("__dvt_inactive_code_position");
            }
            document.addPositionCategory("__dvt_inactive_code_position");
            CodePreprocFileInfo infosForFile = this.getInactiveCodePositions(fileDef);
            if (infosForFile == null) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
                return;
            }
            infosForFile.addPositions(document, "__dvt_inactive_code_position");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void connectPragmaCodePositions(IDocument document, RfFileDef fileDef, DVTConnectPositionToDocumentProvider connectProvider) {
        try {
            if (fileDef == null) {
                return;
            }
            RfProject rfProject = fileDef.getRfProject();
            if (rfProject == null) {
                return;
            }
            VlogPreprocessingInfo preprocTable = rfProject.getPreprocessingTable();
            if (preprocTable == null) {
                return;
            }
            DVTSemanticFoldingProvider semanticFoldingProvider = connectProvider.getSemanticFoldingProvider();
            Set foldingPositions = semanticFoldingProvider.getSemanticFoldingPositions();
            if (document.containsPositionCategory("CUSTOM_PRAGMA")) {
                try {
                    document.removePositionCategory("CUSTOM_PRAGMA");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            document.addPositionCategory("CUSTOM_PRAGMA");
            if (BuildConfigManager.getCustomPragmas((IProject)rfProject.getProject()).isEmpty()) {
                return;
            }
            VlogFileInstance topInstance = preprocTable.getTopFileInstance();
            ArrayList customPragmaUsages = new ArrayList();
            try {
                topInstance.visitInstances(fileInstance -> {
                    ParserPath parserPath = fileInstance.getParserPath();
                    if (!parserPath.equals((Object)fileDef.getParserPath())) {
                        return true;
                    }
                    customPragmaUsages.addAll(fileInstance.getCustomPragmas());
                    return true;
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
            ro.amiq.dvt.ui.Utils.addCustomPragmasPositions(customPragmaUsages, (Set)foldingPositions, (IDocument)document);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private ArrayList<EncryptedPragmaInfo> getProtectedCodePositions(IDocument document, RfFileDef fileDef) {
        if (fileDef == null) {
            return null;
        }
        RfProject rfProject = fileDef.getRfProject();
        if (rfProject == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        if (preprocessingTable == null) {
            return null;
        }
        Map<ParserPath, Set<EncryptedPragmaInfo>> codeProtectedPragmaFileInfos = preprocessingTable.getEncrypedPragmaFileInfos();
        if (codeProtectedPragmaFileInfos == null) {
            return null;
        }
        Set<EncryptedPragmaInfo> pragmasInFile = codeProtectedPragmaFileInfos.get(fileDef.getParserPath());
        if (pragmasInFile == null) {
            return null;
        }
        return new ArrayList<EncryptedPragmaInfo>(pragmasInFile);
    }

    @Override
    protected void connectProtectedCodePositions(IDocument document, RfFileDef fileDef) {
        try {
            document.removePositionCategory("__dvt_protected_code_position");
            document.addPositionCategory("__dvt_protected_code_position");
            ArrayList<EncryptedPragmaInfo> infosForFile = this.getProtectedCodePositions(document, fileDef);
            if (infosForFile == null || infosForFile.size() % 2 != 0) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_protected_code_position");
                return;
            }
            int i = 0;
            while (i < infosForFile.size()) {
                int startOffset = document.getLineOffset(((EncryptedPragmaInfo)infosForFile.get(i)).getLine() - 1);
                int endOffset = document.getLineOffset(((EncryptedPragmaInfo)infosForFile.get(i + 1)).getLine() - 1) + 1;
                DVTDocumentUtils.addDocumentPosition((Object)document, (String)"__dvt_protected_code_position", (Object)new DVTPosition(startOffset, endOffset - startOffset));
                i += 2;
            }
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_protected_code_position");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void connectPreprocCodePositions(IDocument document, ParserPath parserPath) {
        if (document == null || parserPath == null) {
            return;
        }
        this.connectPVlogCodePositions(document, parserPath.path, PreprocConstCommon.PreprocFileType.P_FILE);
    }

    @Override
    public void connectGeneratedCodePositions(IDocument document, ParserPath parserPath, IProject project) {
        if (document == null || parserPath == null || project == null) {
            return;
        }
        String pFilePath = PreprocUtils.getInstance().getPPath(parserPath.path, project);
        this.connectPVlogCodePositions(document, pFilePath, PreprocConstCommon.PreprocFileType.G_FILE);
    }

    private void connectPVlogCodePositions(IDocument document, String pFilePath, PreprocConstCommon.PreprocFileType preprocFileType) {
        try {
            if (preprocFileType == null) {
                return;
            }
            String positionCategory = PreprocConst.getPositionCategory((PreprocConstCommon.PreprocFileType)preprocFileType);
            if (document.containsPositionCategory(positionCategory)) {
                document.removePositionCategory(positionCategory);
            }
            document.addPositionCategory(positionCategory);
            PreprocUtils.getInstance().addDocumentPositions(document, pFilePath, preprocFileType);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)positionCategory);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IResource getFileAdapter(IRfSingleLangProject rfProject, String fullPath) {
        block3: {
            try {
                if (fullPath == null || !fullPath.startsWith("__vlog__")) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(rfProject.getProject(), fullPath);
    }

    public void connectActiveOpenEditor(RfProject rfProject) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                if (rfProject.getFileEditors() == null) {
                    return;
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorPart editor = activePage.getActiveEditor();
                if (editor == null) {
                    return;
                }
                if (editor instanceof VlogEditor) {
                    IFile file = (IFile)editor.getAdapter(IResource.class);
                    if (file == null) {
                        return;
                    }
                    ParserPath parserPath = rfProject.resource2parser((IResource)file);
                    if (parserPath == null) {
                        return;
                    }
                    if (!rfProject.isCompiled(parserPath) && !PreprocUtils.getInstance().shouldSkipCompilation(rfProject.getProject(), parserPath)) {
                        VlogQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)((DVTEditor)editor));
                        return;
                    }
                    HashMap<Position, Position> cachedPositions = new HashMap<Position, Position>();
                    rfProject.connectFileToDocument(parserPath, (DVTEditor)editor, false, cachedPositions);
                    rfProject.notifyParsingEndUsingParserPath(new HashSet<ParserPath>(Arrays.asList(parserPath)));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public void addTopFile2ModelManager(String value) {
        VlogModelManager.getInstance().addTopFile(value);
    }

    public void runOnDisplayThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public static void refreshMarkers(RfProject rfProject) {
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])new Object[]{rfProject});
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])new Object[]{rfProject});
    }

    public IPath getStateLocation() {
        return VlogPlugin.getDefault().getStateLocation();
    }

    public void startUpdateBreadcrumbs(DVTEditor editor) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                Utils.internalSetReadOnlyBreadcrumbs(editor, false);
                ScopeBreadcrumbConfiguration scopeConfig = new ScopeBreadcrumbConfiguration(editor.getCursorScopeForBreadcrumb(true), editor.getCursor(), (IFile)editor.getAdapter(IResource.class), true);
                editor.updateBreadcrumb(ScopeBreadcrumbViewer.class, (AbstractBreadcrumbConfiguration)scopeConfig);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e.getMessage());
            }
        });
    }

    public static void setReadOnlyBreadcrumbs() {
        Job updateBCJob = new Job("Setting read-only Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                List visibleEditors = ro.amiq.dvt.ui.Utils.computeVisibleEditors();
                for (IEditorPart editor : visibleEditors) {
                    if (!(editor instanceof DVTEditor)) continue;
                    Utils.internalSetReadOnlyBreadcrumbs((DVTEditor)editor, true);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    private static void internalSetReadOnlyBreadcrumbs(DVTEditor editor, boolean isReadOnly) {
        if (editor == null) {
            return;
        }
        DHBreadcrumbViewer.setReadOnly((boolean)isReadOnly);
        VHBreadcrumbViewer.setReadOnly((boolean)isReadOnly);
        ScopeBreadcrumbViewer.setReadOnly((boolean)isReadOnly);
        List breadcrumbViewers = editor.getBreadcrumbViewers();
        for (AbstractBreadcrumbViewer breadcrumb : breadcrumbViewers) {
            if (!(breadcrumb instanceof ThickBreadcrumbViewer)) continue;
            ThickBreadcrumbViewer bcViewer = (ThickBreadcrumbViewer)breadcrumb;
            if (!(bcViewer instanceof VHBreadcrumbViewer) || isReadOnly) {
                bcViewer.changeReadOnlyState();
            }
            if (isReadOnly || !(bcViewer instanceof VHBreadcrumbViewer)) continue;
            ((VHBreadcrumbViewer)bcViewer).updateXVMFactory();
        }
    }

    public void updateEditors(IRfFileDef fileDef, DVTEditor dvtEditor) {
        if (fileDef == null || dvtEditor == null) {
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)fileDef, (DVTEditor)dvtEditor, (DVTSemanticHighlighter)new VlogSemanticHighlighter(dvtEditor.getDocument()), (AbstractUIPlugin)VlogPlugin.getDefault(), (String)"highlight.semantic");
        ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
        dvtEditor.updateEditorNotification(fileDef.getParserPath());
    }

    @Override
    public VlogSVlog getVlogParser(IProject project) {
        IVlogProject vlogProject = VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
        if (vlogProject == null) {
            return null;
        }
        return vlogProject.getVlogParser();
    }

    public static boolean isContentAssistInsertNamedArguments() {
        return PrefConst.getContentAssistInsertNamedArguments();
    }

    @Override
    protected String computeFactoryOverrideMessageWithHyperlink(GoToInfo goToInfo) {
        return String.valueOf(System.lineSeparator()) + goToInfo.text;
    }

    @Override
    protected String getMethodOverrideIndicationMessage(RfFunction parentFunction) {
        return parentFunction.getSignature();
    }
}

