/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.IDecoration;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTConnectPositionToDocumentProvider;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTEditorCommon;
import ro.amiq.dvt.ui.editor.DVTOverrideAnnotationProvider;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpectDef;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidExpressionBuilder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.ParamsProvider;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.Utils;

public abstract class UtilsCommon {
    private static final Set<Class<? extends IRfNamedElement>> CLASS_SCOPE = new HashSet<Class<? extends IRfNamedElement>>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add(RfClass.class);
            this.add(RfSpecializedClass.class);
        }
    };

    public String getFileExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((File)file);
    }

    public String getFileExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((String)fileName);
    }

    public String getFileNameNoExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((File)file);
    }

    public String getFileNameNoExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((String)fileName);
    }

    public String canonicPath(File file) {
        return ro.amiq.dvt.utils.Utils.canonicPath((File)file);
    }

    public String canonicPath(String pathString) {
        return ro.amiq.dvt.utils.Utils.canonicPath((String)pathString);
    }

    public String getFileName(File file) {
        return ro.amiq.dvt.utils.Utils.getFileName((File)file);
    }

    public String getFileName(String pathString) {
        return ro.amiq.dvt.utils.Utils.getFileName((String)pathString);
    }

    public void saveRFDM(RfProject rfProject, boolean incremental, boolean async, boolean reportProgress) {
        IProject project = rfProject.getProject();
        Persistence persistence = RfManager.getInstance().getPersistence(project);
        if (persistence == null) {
            return;
        }
        persistence.save(rfProject, incremental, async, reportProgress, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
    }

    public boolean isWriteDone(IProject project) {
        Persistence persistence = RfManager.getInstance().getPersistence(project);
        if (persistence == null) {
            return true;
        }
        return persistence.isWriteDone();
    }

    public int convertPositionToLine(RfFileDef defFile, int offset) {
        try {
            IDocument document = defFile.getDocument();
            return DVTDocumentUtils.convertPositionToLine((IDocument)document, (int)offset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public void connectPositionToDocument(IDocument document, RfFileDef fileDef, DVTConnectPositionToDocumentProvider connectProvider, boolean isEditorVisible) {
        try {
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            DVTOverrideAnnotationProvider annotationProvider = connectProvider.getOverrideAnnotationProvider();
            if (annotationProvider == null) {
                return;
            }
            boolean connectOnlyVisualPositions = annotationProvider.isConnectOnlyVisualPositions();
            if (!connectOnlyVisualPositions) {
                document.removePositionCategory("REFLECTION");
                document.addPositionCategory("REFLECTION");
            }
            this.connectRecursive(fileDef, document, connectProvider, isEditorVisible);
            if (isEditorVisible) {
                this.connectPreprocCodePositions(document, fileDef.getParserPath());
                this.connectGeneratedCodePositions(document, fileDef.getParserPath(), fileDef.getRfProject().getProject());
                this.connectInactiveCodePositions(document, fileDef);
                this.connectPragmaCodePositions(document, fileDef, connectProvider);
                this.connectProtectedCodePositions(document, fileDef);
            }
            this.computeFactoryOverrideAnnotations(document, fileDef, annotationProvider);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void computeFactoryOverrideAnnotations(IDocument document, RfFileDef fileDef, DVTOverrideAnnotationProvider annotationProvider) throws BadLocationException {
        if (fileDef.getParserPath() == null || fileDef.getRfProject() == null) {
            return;
        }
        if (XXVMBuilder.INSTANCE.getFactoryOverrides() == null) {
            return;
        }
        Map additions = annotationProvider.getAdditions();
        List factoryOverrideElements = XXVMBuilder.INSTANCE.getFactoryOverrides().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (IXXVMFactoryOverrideElement factoryOverrideElement : factoryOverrideElements) {
            List factoryOverridenComponents = factoryOverrideElement.getAppliedOnComponents();
            if (factoryOverridenComponents == null) continue;
            factoryOverridenComponents = factoryOverridenComponents.stream().filter(component -> {
                GoToInfo createCall = component.getCreateCallGoToInfo();
                if (createCall == null) {
                    return false;
                }
                return Objects.equals(rfFileDef.getParserPath().path, createCall.filePath);
            }).collect(Collectors.toList());
            for (IXXVMObject factoryOverridenComponent : factoryOverridenComponents) {
                GoToInfo createCallGoToInfo;
                List overridesChain = factoryOverrideElement.getOverridesInChain();
                GoToInfo setTypeOverrideGoToInfo = overridesChain.isEmpty() ? factoryOverrideElement.getGoToInfo() : ((IXXVMFactoryOverrideElement)overridesChain.get(overridesChain.size() - 1)).getGoToInfo();
                if (setTypeOverrideGoToInfo == null || (createCallGoToInfo = factoryOverridenComponent.getCreateCallGoToInfo()) == null) continue;
                DVTPosition position = new DVTPosition(document.getLineOffset(createCallGoToInfo.line - 1), 0);
                DVTEditorCommon.OverrideIndicator overrideIndicator = new DVTEditorCommon.OverrideIndicator(4, "affected by factory override " + this.computeFactoryOverrideMessageWithHyperlink(setTypeOverrideGoToInfo), (IRfFileDef)fileDef.getRfProject().getFileDefUsingParserPath(new ParserPath(setTypeOverrideGoToInfo.filePath)), setTypeOverrideGoToInfo.line, "ro.amiq.vlogdt.ui.editor.VlogEditor");
                additions.put(overrideIndicator, position);
            }
        }
    }

    protected void connectRecursive(RfDefElement root, IDocument document, DVTConnectPositionToDocumentProvider connectionProvider, boolean isEditorVisible) throws BadPositionCategoryException {
        DVTOverrideAnnotationProvider annotationProvider = connectionProvider.getOverrideAnnotationProvider();
        DVTSemanticFoldingProvider semanticFoldingProvider = connectionProvider.getSemanticFoldingProvider();
        if (annotationProvider == null || semanticFoldingProvider == null) {
            return;
        }
        Collection<RfDefElement> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        Map cachedPositions = annotationProvider.getCachedPositions();
        Map additions = annotationProvider.getAdditions();
        Set foldingPositions = semanticFoldingProvider.getSemanticFoldingPositions();
        DVTEditor editor = connectionProvider.getEditor();
        for (RfDefElement child : children) {
            if (!annotationProvider.isConnectOnlyVisualPositions()) {
                child.connectPositionToDocument(document, cachedPositions, connectionProvider.getReflectionPositions());
            }
            if (isEditorVisible) {
                this.addOverrideIndicators(additions, child);
            }
            if (isEditorVisible && semanticFoldingProvider.shouldAddFolding()) {
                this.addSemanticFoldingPositions(foldingPositions, child, document, editor);
            }
            if (child.getChildren() == children) continue;
            this.connectRecursive(child, document, connectionProvider, isEditorVisible);
        }
    }

    public void cleanSemanticMarkers(IProject project) {
        SemanticErrorsManager.getInstance().clean(project);
    }

    public void triggerSemanticMarkers(IRfSingleLangProject rfProject, List<RfSemanticError> semanticErrors, boolean toConsole) {
        SemanticErrorsManager.getInstance().reparsed(rfProject.getProject(), semanticErrors, toConsole);
    }

    protected CodePreprocFileInfo getInactiveCodePositions(RfFileDef fileDef) {
        if (fileDef == null) {
            return null;
        }
        RfProject rfProject = fileDef.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return this.getInactiveCodePositions(rfProject, fileDef.getParserPath());
    }

    public CodePreprocFileInfo getInactiveCodePositions(RfProject rfProject, String path) {
        return this.getInactiveCodePositions(rfProject, new ParserPath(path));
    }

    public CodePreprocFileInfo getInactiveCodePositions(RfProject rfProject, ParserPath parserPath) {
        if (rfProject == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        if (preprocessingTable == null) {
            return null;
        }
        Map<ParserPath, CodePreprocFileInfo> codePreprocFileInfos = preprocessingTable.getCodePreprocFileInfos();
        if (codePreprocFileInfos == null) {
            return null;
        }
        return codePreprocFileInfos.get(parserPath);
    }

    public int getCodeFoldingNofLines() {
        return VlogPlugin.getDefault().getPreferenceStore().getInt("editor.numberOfLines");
    }

    public void addCovergroupShadowIndication(RfNamedElement covergroup, Map<Annotation, Position> additions, int aditionOffset, IDecoration decoration, boolean asViewDecoration) {
        if (asViewDecoration) {
            decoration.addOverlay(DVTImages.DESC_OVR_SHADOWS, 2);
        } else {
            this.addCovergroupShadowIndicationToAdditions(covergroup, additions, aditionOffset);
        }
    }

    public void addCovergroupShadowIndicationToAdditions(RfNamedElement covergroup, Map<Annotation, Position> additions, int aditionOffset) {
        if (covergroup == null) {
            return;
        }
        String covergroupName = covergroup.getName();
        RfNamedElement clazz = covergroup.getEnclosingScope();
        RfMembersHolder parentCovergroup = null;
        while (clazz != null && clazz instanceof RfClass) {
            if ((clazz = ((RfClass)clazz).getParent()) != null && (parentCovergroup = clazz.getLocalMember(RfCovergroup.class, covergroupName, true)) != null) break;
        }
        if (parentCovergroup == null) {
            return;
        }
        RfDefElement parentDecl = parentCovergroup.getDeclaration();
        if (parentDecl == null || parentDecl.getDefFile() == null || parentDecl.getDefFile().getParserPath() == null) {
            return;
        }
        StringBuilder message = new StringBuilder("shadows ").append("covergroup ");
        message.append(ro.amiq.dvt.ui.Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(parentCovergroup.printScope()) + covergroupName), (IRfDefElement)parentDecl));
        DVTPosition position = new DVTPosition(aditionOffset, 0);
        additions.put((Annotation)new DVTEditorCommon.OverrideIndicator(2, message.toString(), (IRfFileDef)parentDecl.getDefFile(), parentDecl.getStartLine(), "ro.amiq.vlogdt.ui.editor.VlogEditor"), (Position)position);
    }

    public void addConstraintOverrideIndication(RfNamedElement constraint, Map<Annotation, Position> additions, int aditionOffset, IDecoration decoration, boolean asViewDecoration) {
        if (asViewDecoration) {
            decoration.addOverlay(DVTImages.DESC_OVR_OVERRIDES, 2);
        } else {
            this.addConstraintOverrideIndicationToAdditions(constraint, additions, aditionOffset);
        }
    }

    public void addConstraintOverrideIndicationToAdditions(RfNamedElement constraint, Map<Annotation, Position> additions, int aditionOffset) {
        if (constraint == null) {
            return;
        }
        String constraintName = constraint.getName();
        RfNamedElement clazz = constraint.getEnclosingScope();
        RfMembersHolder parentConstraint = null;
        while (clazz != null && clazz instanceof RfClass) {
            if ((clazz = ((RfClass)clazz).getParent()) != null && (parentConstraint = clazz.getLocalMember(RfConstraint.class, constraintName, true)) != null) break;
        }
        if (parentConstraint == null) {
            return;
        }
        RfDefElement parentDecl = parentConstraint.getDeclaration();
        if (parentDecl == null || parentDecl.getDefFile() == null || parentDecl.getDefFile().getParserPath() == null) {
            return;
        }
        StringBuilder message = new StringBuilder("overrides ").append("constraint ");
        message.append(ro.amiq.dvt.ui.Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(parentConstraint.printScope()) + constraintName), (IRfDefElement)parentDecl));
        DVTPosition position = new DVTPosition(aditionOffset, 0);
        additions.put((Annotation)new DVTEditorCommon.OverrideIndicator(0, message.toString(), (IRfFileDef)parentDecl.getDefFile(), parentDecl.getStartLine(), "ro.amiq.vlogdt.ui.editor.VlogEditor"), (Position)position);
    }

    public RfFunction getMethodParent(RfNamedElement function) {
        if (function == null) {
            return null;
        }
        RfNamedElement extendedClass = function.getEnclosingScope();
        RfFunction parentFunction = null;
        if (function instanceof RfPredefinedFunction) {
            parentFunction = (RfFunction)function;
            if (extendedClass != null && extendedClass instanceof RfClass && (extendedClass = ((RfClass)extendedClass).getParent()) != null && (parentFunction = (RfFunction)extendedClass.getLocalMember(RfPredefinedFunction.class, function.getName(), false)).hasNoDefs(false)) {
                parentFunction = (RfFunction)function;
            }
        } else {
            parentFunction = RfBatchUtils.getParentFunction((RfFunction)function);
        }
        return parentFunction;
    }

    public int getMethodOverrideIndicationKind(RfFunction parentFunction, boolean isConstructor, String message, boolean isVirtual) {
        int overrideIndicatorKind = 2;
        if (isConstructor) {
            overrideIndicatorKind = 0;
        } else if (isVirtual) {
            IRfNamedElement enclosingScope;
            if (!message.startsWith("virtual ") && !message.contains(" virtual ")) {
                message = message.startsWith("extern ") ? "extern virtual " + message.substring("extern ".length()) : "virtual " + message;
            }
            if ((enclosingScope = parentFunction.getEnclosingScope(CLASS_SCOPE)) != null && enclosingScope instanceof RfClass) {
                overrideIndicatorKind = ((RfClass)enclosingScope).isInterfaceClass() || parentFunction.isPure() ? 1 : 0;
            }
        } else {
            overrideIndicatorKind = 2;
        }
        return overrideIndicatorKind;
    }

    public String getMethodOverrideIndicationPrefix(int overrideIndicatorKind) {
        String overrideIndicatorPrefix = null;
        switch (overrideIndicatorKind) {
            case 2: {
                overrideIndicatorPrefix = "shadows ";
                break;
            }
            case 1: {
                overrideIndicatorPrefix = "implements ";
                break;
            }
            case 0: {
                overrideIndicatorPrefix = "overrides ";
                break;
            }
            case 4: {
                overrideIndicatorPrefix = "factory overrides";
            }
        }
        return overrideIndicatorPrefix;
    }

    protected void addDesignInstanceFoldingPositions(Set<DVTSemanticFoldingPosition> foldingPositions, IDocument document, RfDefElement element, DVTEditor editor) throws BadLocationException, BadPartitioningException {
        DataType instanceDataType;
        DVTSemanticFoldingPosition portBlockPosition;
        if (editor == null || !(element instanceof RfFieldDef)) {
            return;
        }
        RfNamedElement namedElement = element.getNamedElement();
        if (!(namedElement instanceof RfInstance)) {
            return;
        }
        RfInstance instance = (RfInstance)namedElement;
        List<IHidOperator> instancePortConnections = instance.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_PORT_CONNECTION}, true);
        if (instancePortConnections != null && !instancePortConnections.isEmpty() && (portBlockPosition = this.computeFoldingPositionFromInstanceHids(instancePortConnections, document, instance, editor, HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER)) != null) {
            foldingPositions.add(portBlockPosition);
        }
        if ((instanceDataType = instance.getDataType()) == null) {
            return;
        }
        HidOperatorVisitor visitor = new HidOperatorVisitor(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY);
        RfHidHolder paramValuesHolder = instanceDataType.getParamValuesHolder();
        if (paramValuesHolder == null) {
            return;
        }
        paramValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
        List instanceParameters = visitor.getObjects();
        if (instanceParameters == null || instanceParameters.isEmpty()) {
            return;
        }
        DVTSemanticFoldingPosition parameterBlockPosition = this.computeFoldingPositionFromInstanceHids(instanceParameters, document, instance, editor, HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER);
        if (parameterBlockPosition != null) {
            foldingPositions.add(parameterBlockPosition);
        }
    }

    protected DVTSemanticFoldingPosition computeFoldingPositionFromInstanceHids(List<IHidOperator> operators, IDocument document, RfInstance instance, DVTEditor editor, long qualifier) throws BadLocationException, BadPartitioningException {
        int firstParameterOffset = ro.amiq.dvt.utils.Utils.getOperatorFirstOffset(operators, (int)0);
        if (firstParameterOffset < 0 || firstParameterOffset > document.getLength()) {
            return null;
        }
        int lParenOffset = 0;
        try {
            lParenOffset = DVTFileUtils.getInstance().getCharOffset('(', firstParameterOffset, false, 100, document);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IRegion blockInfo = document.getLineInformationOfOffset(lParenOffset);
        int startOffset = blockInfo.getOffset();
        if (startOffset < 0 || startOffset > document.getLength()) {
            return null;
        }
        int matchingBracketOffset = DVTFileUtils.getInstance().getMatchingBracketOffset(lParenOffset, editor, document);
        if (matchingBracketOffset == -1) {
            return null;
        }
        IRegion endInfo = document.getLineInformationOfOffset(matchingBracketOffset);
        int endOffset = endInfo.getOffset() + endInfo.getLength() + 1;
        if (endOffset < 0 || endOffset > document.getLength()) {
            return null;
        }
        if (endOffset <= startOffset) {
            return null;
        }
        String category = qualifier == HidOperatorQualifier.IS_PORT_CONNECTION.value() ? "instance_port_block" : "instance_parameter_block";
        return new DVTSemanticFoldingPosition(startOffset, endOffset - startOffset, category);
    }

    protected void addActionBlocksFoldingPosition(Set<DVTSemanticFoldingPosition> foldingPositions, IDocument document, RfDefElement element) throws BadLocationException {
        if (!(element instanceof RfActionBlockDef)) {
            return;
        }
        RfActionBlock actionBlock = (RfActionBlock)((RfActionBlockDef)element).getNamedElement();
        if (actionBlock == null) {
            return;
        }
        if (!actionBlock.isAlways()) {
            return;
        }
        IRegion foldingRegion = DVTUtilsCommon.INSTANCE.getFoldingRegion((IRfDefElement)element, document);
        if (foldingRegion == null) {
            return;
        }
        DVTSemanticFoldingPosition alwaysPosition = new DVTSemanticFoldingPosition(foldingRegion.getOffset(), foldingRegion.getLength(), "always");
        foldingPositions.add(alwaysPosition);
    }

    protected void addSemanticFoldingPositions(Set<DVTSemanticFoldingPosition> foldingPositions, RfDefElement element, IDocument document, DVTEditor editor) {
        try {
            this.addActionBlocksFoldingPosition(foldingPositions, document, element);
            this.addDesignInstanceFoldingPositions(foldingPositions, document, element, editor);
            this.addAssertionFoldingPositions(foldingPositions, document, element);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void addAssertionFoldingPositions(Set<DVTSemanticFoldingPosition> foldingPositions, IDocument document, RfDefElement element) throws BadLocationException {
        if (!(element instanceof RfAssertExpectDef)) {
            return;
        }
        IRegion foldingRegion = DVTUtilsCommon.INSTANCE.getFoldingRegion((IRfDefElement)element, document);
        if (foldingRegion == null) {
            return;
        }
        DVTSemanticFoldingPosition assertionPosition = new DVTSemanticFoldingPosition(foldingRegion.getOffset(), foldingRegion.getLength(), "assertion");
        foldingPositions.add(assertionPosition);
    }

    public void addMethodOverrideIndication(RfNamedElement function, Map<Annotation, Position> additions, int aditionOffset, IDecoration decoration, boolean asViewDecoration) {
        RfDefElement parentImpl;
        RfFunction parentFunction = this.getMethodParent(function);
        if (parentFunction == null) {
            return;
        }
        boolean isVirtual = false;
        if (!(function instanceof RfPredefinedFunction)) {
            isVirtual = ((RfFunction)function).isParentVirtual();
        }
        String message = this.getMethodOverrideIndicationMessage(parentFunction);
        DVTPosition position = new DVTPosition(aditionOffset, 0);
        boolean isTask = ((RfFunction)function).isTask();
        boolean isConstructor = !isTask && ((RfFunction)function).isConstructor();
        RfDefElement parentDecl = parentFunction.getDeclaration();
        if (PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype() && (parentImpl = parentFunction.getImplementation()) != null) {
            parentDecl = parentImpl;
        }
        if (parentDecl == null || parentDecl.getDefFile() == null || parentDecl.getDefFile().getParserPath() == null) {
            return;
        }
        int overrideIndicatorKind = 2;
        String overrideIndicatorPrefix = "shadows ";
        RfFileDef overrideIndicatorFile = parentDecl.getDefFile();
        int overrideIndicatorLine = parentDecl.getStartLine();
        if (function instanceof RfPredefinedFunction) {
            if (parentFunction instanceof RfPredefinedFunction && parentFunction != function) {
                overrideIndicatorKind = 2;
            } else {
                overrideIndicatorKind = 1;
                overrideIndicatorFile = null;
                overrideIndicatorLine = 0;
            }
        } else {
            overrideIndicatorKind = this.getMethodOverrideIndicationKind(parentFunction, isConstructor, message, isVirtual);
        }
        overrideIndicatorPrefix = this.getMethodOverrideIndicationPrefix(overrideIndicatorKind);
        if (asViewDecoration) {
            switch (overrideIndicatorKind) {
                case 2: {
                    decoration.addOverlay(DVTImages.DESC_OVR_SHADOWS, 2);
                    break;
                }
                case 1: {
                    decoration.addOverlay(DVTImages.DESC_OVR_IMPLEMENTS, 2);
                    break;
                }
                case 0: {
                    decoration.addOverlay(DVTImages.DESC_OVR_OVERRIDES, 2);
                    break;
                }
                case 4: {
                    decoration.addOverlay(DVTImages.DESC_OVR_OVERRIDES, 2);
                }
            }
        } else {
            DVTEditorCommon.OverrideIndicator overrideIndicator = new DVTEditorCommon.OverrideIndicator(overrideIndicatorKind, String.valueOf(overrideIndicatorPrefix) + ro.amiq.dvt.ui.Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)message, (IRfDefElement)parentDecl), (IRfFileDef)overrideIndicatorFile, overrideIndicatorLine, "ro.amiq.vlogdt.ui.editor.VlogEditor");
            additions.put((Annotation)overrideIndicator, (Position)position);
        }
    }

    protected void addOverrideIndicators(Map<Annotation, Position> additions, RfDefElement child) {
        RfNamedElement enclosingClass;
        RfNamedElement field;
        RfFileDef defFile = child.getDefFile();
        if (defFile == null || defFile.getParserPath() == null) {
            return;
        }
        if (child.getReparseInfo() != null) {
            return;
        }
        if (child instanceof RfConstraintDef) {
            RfNamedElement constraint = child.getNamedElement();
            this.addConstraintOverrideIndication(constraint, additions, child.getStartOffset(), null, false);
        } else if (child instanceof RfCovergroupDef) {
            RfNamedElement covergroup = child.getNamedElement();
            if (!covergroup.isAnonymous()) {
                this.addCovergroupShadowIndication(covergroup, additions, child.getStartOffset(), null, false);
            }
        } else if (child instanceof RfFunctionDef) {
            RfNamedElement function = child.getNamedElement();
            this.addMethodOverrideIndication(function, additions, child.getStartOffset(), null, false);
        } else if (child instanceof RfFieldDef && (field = child.getNamedElement()) != null && (enclosingClass = field.getEnclosingScope()) instanceof RfClass) {
            RfClass extendedClass = ((RfClass)enclosingClass).getParent();
            while (extendedClass != null) {
                RfField shadowedField = extendedClass.getLocalMember(RfField.class, field.getName(), true);
                if (shadowedField != null) {
                    String shadowedFieldSignature = shadowedField.getSignature();
                    RfDefElement shadowedFieldDecl = shadowedField.getDeclaration();
                    if (shadowedFieldDecl == null) break;
                    DVTPosition position = new DVTPosition(child.getStartOffset(), 0);
                    DVTEditorCommon.OverrideIndicator overrideIndicator = new DVTEditorCommon.OverrideIndicator(2, "shadows " + ro.amiq.dvt.ui.Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)shadowedFieldSignature, (IRfDefElement)shadowedFieldDecl), (IRfFileDef)shadowedFieldDecl.getDefFile(), shadowedFieldDecl.getStartLine(), "ro.amiq.vlogdt.ui.editor.VlogEditor");
                    additions.put((Annotation)overrideIndicator, (Position)position);
                    break;
                }
                extendedClass = extendedClass.getParent();
            }
        }
    }

    public int computeInsertOffsetConsideringTimescale(IDocument document, int insertionOffset, RfDefElement declaration) {
        try {
            if (declaration == null) {
                return insertionOffset;
            }
            RfProject rfProject = declaration.getRfProject();
            if (rfProject == null) {
                return insertionOffset;
            }
            int timeScaleEndOffset = this.computeTimeScaleEndOffset(declaration);
            if (timeScaleEndOffset < 0) {
                return insertionOffset;
            }
            insertionOffset = timeScaleEndOffset;
            CodePreprocFileInfo preprocessingDirectivesPositions = Utils.getInstance().getInactiveCodePositions(rfProject, declaration.getParserPath());
            if (preprocessingDirectivesPositions == null) {
                return insertionOffset;
            }
            CodePreprocLineInfo[] preprocLineInfo = preprocessingDirectivesPositions.getSortedRawPreprocLineInfo();
            if (preprocLineInfo == null || preprocLineInfo.length == 0 || preprocLineInfo[0] == null || document.getLineOffset(preprocLineInfo[0].getLine()) + preprocLineInfo[0].getColumn() > insertionOffset) {
                return insertionOffset;
            }
            List<List<Integer>> preprocLinesRangesForDocument = preprocessingDirectivesPositions.getPreprocUsageOffsetRangesForDocument(document);
            for (List<Integer> range : preprocLinesRangesForDocument) {
                Integer startOffset = range.get(0);
                Integer endOffset = range.get(1);
                if (insertionOffset < startOffset || insertionOffset > endOffset) continue;
                return endOffset;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return insertionOffset;
    }

    private int computeTimeScaleEndOffset(IRfDefElement declaration) {
        TimeScaleOperatorVisitor visitor = new TimeScaleOperatorVisitor();
        if (declaration.getNamedElement() instanceof IRfDesignElement) {
            ((IRfDesignElement)declaration.getNamedElement()).visitHidObject(null, (IHidVisitor)visitor);
        }
        return visitor.getOffset();
    }

    protected abstract String getMethodOverrideIndicationMessage(RfFunction var1);

    protected abstract String computeFactoryOverrideMessageWithHyperlink(GoToInfo var1);

    protected abstract void connectPragmaCodePositions(IDocument var1, RfFileDef var2, DVTConnectPositionToDocumentProvider var3);

    protected abstract void connectInactiveCodePositions(IDocument var1, RfFileDef var2);

    protected abstract void connectProtectedCodePositions(IDocument var1, RfFileDef var2);

    public abstract void connectPreprocCodePositions(IDocument var1, ParserPath var2);

    public abstract void connectGeneratedCodePositions(IDocument var1, ParserPath var2, IProject var3);

    protected abstract VlogSVlog getVlogParser(IProject var1);

    public synchronized IHidObject parsePattern(String pattern, String defaultKeywordSet, Map<String, String> extensionKeywordsetMap, IBuildConfigParserConstants.ToolCompat toolCompat, boolean isAssert, RfProject rfProject) {
        if (pattern == null || pattern.isEmpty() || rfProject == null) {
            return null;
        }
        IProject project = rfProject.getProject();
        VlogSVlog parser = this.getVlogParser(project);
        if (parser == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessing = rfProject.getPreprocessingTable();
        Set translatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)project);
        Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
        boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
        boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
        boolean disableParallelLexParse = BuildConfigManager.isDisableParallelLexParse((IProject)project);
        boolean enableIncludeEnvVarExpansion = BuildConfigManager.isEnableIncludeEnvVarExpansion((IProject)project);
        boolean isSvxEnable = BuildConfigManager.isSvxMode((IProject)project);
        boolean isCpreprocEnable = BuildConfigManager.isCpreprocEnabled((IProject)project);
        boolean isSkipProtectedCode = BuildConfigManager.isSkipProtectedCode((IProject)project);
        boolean disableTaskTags = BuildConfigManager.isTagMemoryConsumptionDebug((IProject)project);
        boolean disableComments = BuildConfigManager.isCommentMemoryConsumptionDebug((IProject)project);
        boolean collectMacroCallsWithoutParams = false;
        boolean collectMacroCallsWithParams = false;
        DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)project);
        boolean compactMacros = BuildConfigManager.isCompactMacros((IProject)project);
        BuildConfigProperty buildConfigTimscaleProperty = BuildConfigManager.getTimescaleConfigurationProperty((IProject)project);
        BuildConfigProperty buildConfigOverrideTimscaleProperty = BuildConfigManager.getOverrideTimescaleConfigurationProperty((IProject)project);
        HidImplicit[] buildConfigTimscale = Utils.getInstance().computeTimescale(buildConfigTimscaleProperty);
        HidImplicit[] buildConfigOverrideTimscale = Utils.getInstance().computeTimescale(buildConfigOverrideTimscaleProperty);
        RfHidExpressionBuilder exprBuilder = RfHidExpressionBuilder.makeBuilder(rfProject, rfProject, rfProject, true);
        ParamsProvider extendParams = new ParamsProvider();
        extendParams.setExprBuilder(exprBuilder);
        parser.parseFile(isAssert ? 6 : 5, "dummy lint check", null, "dummy lint check", Collections.emptyList(), toolCompat, preprocessing, defaultKeywordSet, false, extensionKeywordsetMap, pattern, null, null, null, null, null, false, 1000, collectMacroCallsWithoutParams, collectMacroCallsWithParams, rfProject, false, false, false, commentsPreferences, null, null, false, true, null, translatePragmas, extendParams, -1, disableParallelLexParse, false, taskNames, caseSensitiveTaskTags, hideTaskTags, enableIncludeEnvVarExpansion, isSvxEnable, isCpreprocEnable, isSkipProtectedCode, false, disableTaskTags, disableComments, BuildConfigManager.shouldPrintLibScanDebug((IProject)project), compactMacros, null, true, buildConfigTimscale, buildConfigOverrideTimscale);
        List gatheredValues = exprBuilder.getGatheredValues();
        if (gatheredValues == null || gatheredValues.isEmpty()) {
            return null;
        }
        return (IHidObject)gatheredValues.get(0);
    }

    public HidImplicit[] computeTimescale(BuildConfigProperty timescaleConfigurationProperty) {
        if (timescaleConfigurationProperty == null) {
            return null;
        }
        String value = timescaleConfigurationProperty.getValue();
        int divIndex = value.indexOf(47);
        if (divIndex <= 0) {
            return null;
        }
        String timeunit = value.substring(0, divIndex).trim();
        String timeprecision = value.substring(divIndex + 1).trim();
        return new HidImplicit[]{RfHidImplicit.makeImplicit(timeunit, 283), RfHidImplicit.makeImplicit(timeprecision, 283)};
    }

    public class TimeScaleOperatorVisitor
    implements IHidVisitor<HidOperator> {
        int offset = -1;

        public boolean visit(HidOperator hidObject) {
            if (!(hidObject instanceof IRfHidOperatorLayer)) {
                return true;
            }
            if (!((IRfHidOperatorLayer)hidObject).isTimeprecision() && !((IRfHidOperatorLayer)hidObject).isTimeunit()) {
                return true;
            }
            this.offset = Math.max(this.offset, hidObject.getCloseBoundary());
            return true;
        }

        public Class<HidOperator> getType() {
            return HidOperator.class;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

