/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.utils.ICompiledFilesContributor;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;

public abstract class VlogCompiledFilesContributorCommon
implements ICompiledFilesContributor {
    public List<File> getCompiledFiles(IProject project) {
        return this.getCompiledFilesList(project, true);
    }

    public List<File> getCompiledFilesList(IProject project, boolean getAllFiles) {
        if (project == null) {
            return Collections.emptyList();
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return Collections.emptyList();
        }
        LinkedList<String> allFiles = new LinkedList<String>();
        VlogFileInstance topFilesInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topFilesInstance == null) {
            return Collections.emptyList();
        }
        List<VlogFileInstance> topFiles = topFilesInstance.getIncludedInstances();
        this.collectIncludedFiles(allFiles, topFiles, project.getName(), getAllFiles);
        ArrayList<File> finalFiles = new ArrayList<File>();
        allFiles.stream().forEach(s -> {
            boolean bl = finalFiles.add(new File((String)s));
        });
        return finalFiles;
    }

    private void collectIncludedFiles(Collection<String> result, List<VlogFileInstance> topFiles, String projectName, boolean getAllFiles) {
        if (topFiles == null || topFiles.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < topFiles.size()) {
            File file = new File(topFiles.get((int)i).getParserPath().path);
            if (!this.filter(file, projectName)) {
                result.add(file.getAbsolutePath());
            }
            this.collectIncludedFiles(result, topFiles.get(i).getIncludedInstances(), projectName, getAllFiles);
            ++i;
        }
    }

    protected boolean filter(File file, String projectName) {
        if (file.getName().equals("__vlog__" + projectName + "__top.sv.libdirs")) {
            return true;
        }
        return file.getName().equals("__vlog__" + projectName + "__top.sv.libfile");
    }

    public LanguageKind getKind() {
        return LanguageKind.VLOG;
    }
}

