/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.VlogFileLabelProvider;
import ro.amiq.vlogdt.ui.editor.VlogFileEditorInput;
import ro.amiq.vlogdt.utils.VlogFileUtilsCommon;

public class VlogFileUtils
extends VlogFileUtilsCommon {
    private static volatile VlogFileUtils fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private VlogFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogFileUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VlogFileUtils();
            }
        }
        return fInstance;
    }

    public void openEditor(File file, int line, String selectIdentifier) {
        try {
            if (file.exists()) {
                VlogFileEditorInput editorInput = new VlogFileEditorInput(file);
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)"ro.amiq.vlogdt.ui.editor.VlogEditor");
                this.selectAndReveal(line, selectIdentifier, editorPart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void openEditorAndSetCursor(File file, int offset) {
        try {
            if (file.exists()) {
                VlogFileEditorInput editorInput = new VlogFileEditorInput(file);
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)"ro.amiq.vlogdt.ui.editor.VlogEditor");
                DVTEditor dvtEditor = (DVTEditor)editorPart;
                dvtEditor.selectAndReveal(offset, 0);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Object selectFile(final Object[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final Object[] result = new Object[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new VlogFileLabelProvider2());
                dialog.setElements(files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("The selected file is referenced by multiple linked resources in the workspace.\nSelect a workspace resource to open the file.");
                if (dialog.open() == 0) {
                    result[0] = dialog.getFirstResult();
                }
            }
        });
        return result[0];
    }

    public IProject selectProject(IProject[] projects, String message, IProject defaultSelection) {
        return Utils.selectProject((IProject[])projects, (String)message, (ILabelProvider)new VlogFileLabelProvider2(), (IProject)defaultSelection);
    }

    private void internalOpenEditor(IProject project, File classicFile, int line, String selectIdentifier) {
        IFile candidate = this.getProjectFile(project, classicFile.getAbsolutePath());
        if (candidate == null) {
            this.openEditor(classicFile, line, selectIdentifier);
            return;
        }
        this.openEditor(candidate, line, selectIdentifier);
    }

    public void openFile(IProject project, String knownPath, int line) {
        this.openFile(project, knownPath, line, null);
    }

    public void openFile(IProject project, String knownPath, int line, String selectIdentifier) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        File classicFile = new File(knownPath);
        if (classicFile.isAbsolute() && classicFile.exists()) {
            this.internalOpenEditor(project, classicFile, line, selectIdentifier);
            return;
        }
        Set<Object> candidates = this.computeIncDirCandidates(project, knownPath);
        if (!candidates.isEmpty()) {
            Object choice = this.selectFile(candidates.toArray());
            if (choice != null) {
                if (choice instanceof IFile) {
                    this.openEditor((IFile)choice, line, selectIdentifier);
                }
                if (choice instanceof File) {
                    this.openEditor((File)choice, line, selectIdentifier);
                }
            } else {
                Object firstCandidate = candidates.iterator().next();
                if (firstCandidate instanceof IFile) {
                    this.openEditor((IFile)firstCandidate, line, selectIdentifier);
                } else if (firstCandidate instanceof File) {
                    this.openEditor((File)firstCandidate, line, selectIdentifier);
                }
            }
            return;
        }
        classicFile = new File(customPath);
        this.internalOpenEditor(project, classicFile, line, selectIdentifier);
    }

    public RfFileDef getFileDef(RfProject rfProject, ParserPath parserPath, ITextEditor editor, boolean enableQuick) {
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null && enableQuick) {
            if (rfProject.isCompiled(parserPath)) {
                return null;
            }
            IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule((IFile)editor.getEditorInput().getAdapter(IFile.class));
            vlogFile.scheduleReparse(enableQuick, true, 0L, true);
            return rfProject.getFileDefUsingParserPath(parserPath);
        }
        return fileDef;
    }

    static class VlogFileLabelProvider2
    extends VlogFileLabelProvider {
        VlogFileLabelProvider2() {
        }

        @Override
        protected String decorateText(String input, Object element) {
            if (element instanceof File) {
                return ((File)element).getAbsolutePath();
            }
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toOSString();
            }
            if (element instanceof IFolder) {
                return ((IFolder)element).getProjectRelativePath().toOSString();
            }
            return input;
        }
    }

    static class VlogProjectLabelProvider
    extends WorkbenchLabelProvider {
        VlogProjectLabelProvider() {
        }

        protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
            return input;
        }

        protected String decorateText(String input, Object element) {
            if (element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return input;
        }
    }
}

