/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.model.reflection.RfClass;

public abstract class VlogFileUtilsCommon
extends DVTFileUtils {
    public static String computeEnclosingClassIndent(RfClass enclosingScope, DVTEditor textEditor) {
        if (textEditor == null) {
            return "";
        }
        IDocument document = textEditor.getDocument();
        if (document == null) {
            return "";
        }
        if (enclosingScope == null) {
            return "";
        }
        return DVTDocumentUtils.getIndent((int)enclosingScope.getDeclaration().getStartOffset(), (IDocument)document);
    }

    public Set<Object> computeIncDirCandidates(IProject project, String knownPath) {
        List incDirsPath = BuildConfigManager.getIncdirs((IProject)project, null);
        HashSet<Object> candidates = new HashSet<Object>();
        String fileSeparator = System.getProperty("file.separator");
        for (String incDirPath : incDirsPath) {
            String fullFileName = String.valueOf(incDirPath) + fileSeparator + knownPath;
            String tempPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(fullFileName);
            File classicFile = new File(tempPath);
            if (!classicFile.exists()) continue;
            IFile findProjectFile = this.findProjectFile(project, classicFile.getAbsolutePath());
            if (findProjectFile != null) {
                candidates.add(findProjectFile);
                continue;
            }
            candidates.add(classicFile);
        }
        return candidates;
    }
}

