/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.comment.formatter.CommentLinkResolver;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.utils.VlogLinkResolver;

public abstract class VlogLinkResolverCommon
extends CommentLinkResolver {
    public static final String CLASS_TYPE_PARAMETER_START = "#(";
    public static final String CLASS_TYPE_PARAMETER_END = ")";
    private static final Pattern SPLIT_DECLARED_TYPES = Pattern.compile("(, |,| )");

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public static Collection<IRfNamedElement> getInitialCandidatesFromScope(IRfScopeElement scope) {
        if (scope == null) {
            return null;
        }
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        while (scope != null) {
            if (scope instanceof RfNamedElement) {
                result.add((RfNamedElement)scope);
            }
            if (scope instanceof RfPackage) {
                NullProtectedList<ImportInfo> allImports = ((RfNamedElement)scope).getAllImportDeclarations();
                for (ImportInfo info : allImports) {
                    IRfPackageElement pack = info.getPackage();
                    if (!(pack instanceof RfPackage)) continue;
                    result.add((IRfNamedElement)pack);
                }
            }
            scope = scope.getEnclosingScope();
        }
        return result;
    }

    public IRfNamedElement recursiveFindElement(IRfNamedElement scope, String[] parsedElementPath, int pathIndex, long timeoutTime) throws Exception {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new Exception("Tooltip timeout in resolving link " + String.join((CharSequence)".", parsedElementPath));
        }
        if (!(scope instanceof RfNamedElement) || parsedElementPath == null) {
            return null;
        }
        if (scope.getRfProject() == null) {
            return null;
        }
        RfNamedElement currentScope = (RfNamedElement)scope;
        if (pathIndex >= parsedElementPath.length) {
            return scope;
        }
        List<RfNamedElement> members = VlogLinkResolverCommon.getCandidatesInScope(currentScope);
        if (members == null) {
            return null;
        }
        String[] elementTypeParams = VlogLinkResolverCommon.extractTypeNames(parsedElementPath[pathIndex]);
        String className = VlogLinkResolverCommon.extractClassName(parsedElementPath[pathIndex]);
        IRfNamedElement result = null;
        for (RfNamedElement member : members) {
            if (!parsedElementPath[pathIndex].equals(member.getName()) && !VlogLinkResolverCommon.isElementWithGenericParams(member, parsedElementPath[pathIndex], elementTypeParams, className) || (result = this.recursiveFindElement(member, parsedElementPath, pathIndex + 1, timeoutTime)) == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isElementWithGenericParams(RfNamedElement member, String originalElementPathName, String[] elementTypeParams, String className) {
        if (!(member instanceof RfClass) || member.getLocalParameters(256).isEmpty()) {
            return false;
        }
        member = ((RfClass)member).getDefaultSpecialization(null);
        if (VlogLinkResolverCommon.removeWhitespaces(originalElementPathName).equals(VlogLinkResolverCommon.removeWhitespaces(member.getQualifiedName((IRfScopeElement)null, (ElementPath)null, 7)))) {
            return true;
        }
        if (className == null || !className.equals(member.getName())) {
            return false;
        }
        Set<String> typeParams = member.getTypeParamNames();
        if (elementTypeParams == null || typeParams.size() != elementTypeParams.length) {
            return false;
        }
        int i = 0;
        while (i < elementTypeParams.length) {
            if (!typeParams.contains(elementTypeParams[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String removeWhitespaces(String text) {
        return text.replace(" ", "");
    }

    public static String extractClassName(String classNameWithParams) {
        if (classNameWithParams == null || classNameWithParams.isEmpty() || !classNameWithParams.contains(CLASS_TYPE_PARAMETER_START)) {
            return null;
        }
        int indexEnd = classNameWithParams.indexOf(CLASS_TYPE_PARAMETER_START);
        String name = classNameWithParams.substring(0, indexEnd);
        if (name == null) {
            return null;
        }
        return name.trim();
    }

    public static String[] extractTypeNames(String className) {
        if (className == null || className.isEmpty() || !className.contains(CLASS_TYPE_PARAMETER_START)) {
            return null;
        }
        int indexStart = className.indexOf(CLASS_TYPE_PARAMETER_START) + CLASS_TYPE_PARAMETER_START.length();
        if (indexStart < 0 || indexStart > className.length()) {
            return null;
        }
        int indexEnd = className.indexOf(CLASS_TYPE_PARAMETER_END);
        if (indexEnd < 0 || indexEnd > className.length() || indexStart > indexEnd) {
            return null;
        }
        String declaredTypes = className.substring(indexStart, indexEnd);
        String[] types = DVTStringUtil.split((Pattern)SPLIT_DECLARED_TYPES, (String)declaredTypes);
        return types;
    }

    public static RfNamedElement searchForMacro(IRfNamedElement scope, String macroName) {
        List<RfNamedElement> result;
        if (scope == null || macroName == null) {
            return null;
        }
        IRfSingleLangProject rfProject = scope.getRfProject();
        if (!(rfProject instanceof RfProject)) {
            return null;
        }
        IRfDefElement declaration = scope.getDeclaration();
        if (declaration != null) {
            int scopeStartLine = declaration.getStartLine();
            VlogMacroInfo result2 = ((RfProject)rfProject).getMacroBeforeLineInFile(macroName, declaration.getParserPath(), scopeStartLine);
            if (result2 != null) {
                return result2;
            }
        }
        if ((result = ((RfProject)rfProject).getMacrosWithPrefix(macroName, 1)) != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public static RfNamedElement searchForMacro(IRfNamedElement scope, String macroName, int offset, IDocument document) {
        if (scope == null || macroName == null || document == null || offset == -1) {
            return null;
        }
        IRfSingleLangProject rfProject = scope.getRfProject();
        if (!(rfProject instanceof RfProject)) {
            return null;
        }
        IRfDefElement declaration = scope.getDeclaration();
        if (declaration == null) {
            return null;
        }
        try {
            VlogMacroInfo result = ((RfProject)rfProject).getMacroBeforeLineInFile(macroName, declaration.getParserPath(), document.getLineOfOffset(offset));
            if (result != null) {
                return result;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static List<RfNamedElement> getCandidatesInScope(RfNamedElement element) {
        if (element instanceof RfTypeAlias) {
            element = (RfNamedElement)((RfTypeAlias)element).getTranslatedType();
        }
        if (element == null) {
            return null;
        }
        Collection<RfNamedElement> tempMembers = element.getMembers();
        if (tempMembers == null) {
            return null;
        }
        LinkedList<RfNamedElement> membersQueue = new LinkedList<RfNamedElement>(tempMembers);
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        while (!membersQueue.isEmpty()) {
            RfNamedElement member = (RfNamedElement)membersQueue.poll();
            if (member instanceof RfDuplicate) {
                membersQueue.addAll(VlogLinkResolverCommon.getElementsFromDuplicate((RfDuplicate)member));
                continue;
            }
            if (member instanceof RfForwardTypedef) continue;
            RfNamedElement enclosingScope = member.getEnclosingScope();
            if (!VlogLinkResolverCommon.isType(member) && !VlogLinkResolverCommon.isType(enclosingScope)) continue;
            result.add(member);
        }
        return result;
    }

    private static boolean isType(RfNamedElement element) {
        return element instanceof RfListType || element instanceof RfClass || element instanceof RfInterface || element instanceof RfModule || element instanceof RfCoverpoint || element instanceof RfCovergroup || element instanceof RfModport || element instanceof RfClockingBlock || element instanceof RfPackage || element instanceof RfProgram || element instanceof RfPrimitive || element instanceof RfStruct || element instanceof RfField;
    }

    private static Collection<RfNamedElement> getElementsFromDuplicate(RfDuplicate member) {
        Collection<RfNamedElement> functions = member.getMembers();
        if (functions == null) {
            return new ArrayList<RfNamedElement>();
        }
        return functions;
    }

    public IFile getIFileFromElement(IRfNamedElement element) {
        if (element == null || !(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement defElem = ((RfNamedElement)element).getDeclaration();
        if (defElem == null) {
            return null;
        }
        RfFileDef defFile = defElem.getDefFile();
        if (defFile == null) {
            return null;
        }
        Object fileObj = defFile.getAdapter(IResource.class);
        if (!(fileObj instanceof IFile)) {
            return null;
        }
        return (IFile)fileObj;
    }

    public IRfNamedElement getNamedElementFromPath(String path, IProject project) {
        RfElementPath elementPath = RfElementPath.fromString((String)path, VlogLinkResolver.class);
        if (elementPath == null) {
            return null;
        }
        return elementPath.toNamedElement(project);
    }

    public List<IRfNamedElement> getPackageCandidates(String packageName, IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return VlogLinkResolverCommon.getPackageCandidatesFromProject(packageName, rfProject);
    }

    public static List<IRfNamedElement> getPackageCandidatesFromProject(String packageName, RfProject rfProject) {
        if (rfProject == null) {
            return null;
        }
        List<RfPackage> packages = rfProject.getAllPackages(true);
        if (packages == null) {
            return null;
        }
        ArrayList<IRfNamedElement> packageCandidates = new ArrayList<IRfNamedElement>();
        int i = 0;
        while (i < packages.size()) {
            if (packageName.equals(packages.get(i).getName())) {
                packageCandidates.add(packages.get(i));
            }
            ++i;
        }
        if (packageCandidates.isEmpty()) {
            return null;
        }
        return packageCandidates;
    }

    public IFile getFile(IRfNamedElement element, IProject project) {
        if (element instanceof VlogMacroInfo) {
            VlogFileInstance fileInstance = ((VlogMacroInfo)element).getFileInstance();
            if (fileInstance == null) {
                return null;
            }
            ParserPath parserPath = fileInstance.getParserPath();
            if (parserPath == null) {
                return null;
            }
            return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, parserPath.getCanonicalPath());
        }
        return this.getIFileFromElement(element);
    }

    public IRfNamedElement solveHyperlinkForAllCandidates(IRfNamedElement element, Collection<IRfNamedElement> candidates, String[] parsedLink, long timeoutTime) {
        try {
            RfNamedElement potentialMacro;
            IRfNamedElement foundElement = null;
            for (IRfNamedElement candidate : candidates) {
                foundElement = this.recursiveFindElement(candidate, parsedLink, 0, timeoutTime);
                if (foundElement == null) continue;
                return foundElement;
            }
            if (parsedLink.length != 1) {
                return foundElement;
            }
            if (!candidates.isEmpty()) {
                IRfNamedElement firstCandidate = candidates.iterator().next();
                if (candidates.size() == 1 && firstCandidate instanceof IRfPackageElement) {
                    return foundElement;
                }
            }
            if ((potentialMacro = VlogLinkResolverCommon.searchForMacro(element, parsedLink[0])) != null) {
                return potentialMacro;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static RfNamedElement resolveNamedElementFromCandidates(Collection<IRfNamedElement> candidates, String[] types, int offset, IDocument document) {
        for (IRfNamedElement candidate : candidates) {
            RfNamedElement resolvedElement;
            if (!(candidate instanceof RfNamedElement) || (resolvedElement = VlogLinkResolverCommon.recursiveResolveElement((RfNamedElement)candidate, types, 0)) == null) continue;
            return resolvedElement;
        }
        if (types.length != 1 || candidates.isEmpty()) {
            return null;
        }
        IRfNamedElement firstCandidate = candidates.iterator().next();
        if (candidates.size() == 1 && firstCandidate instanceof IRfPackageElement) {
            return null;
        }
        for (IRfNamedElement candidate : candidates) {
            RfNamedElement potentialMacro = VlogLinkResolver.searchForMacro(candidate, types[0], offset, document);
            if (potentialMacro == null) continue;
            return potentialMacro;
        }
        return null;
    }

    private static RfNamedElement recursiveResolveElement(RfNamedElement currentElement, String[] types, int index) {
        if (currentElement == null || types == null) {
            return null;
        }
        if (currentElement.getRfProject() == null) {
            return null;
        }
        RfNamedElement element = currentElement;
        if (index >= types.length) {
            return element;
        }
        List<RfNamedElement> members = VlogLinkResolver.getCandidatesInScope(element);
        if (members == null) {
            return null;
        }
        String[] elementTypeParams = VlogLinkResolver.extractTypeNames(types[index]);
        String className = VlogLinkResolver.extractClassName(types[index]);
        for (RfNamedElement member : members) {
            RfNamedElement resolvedElement;
            if (!types[index].equals(member.getName()) && !VlogLinkResolver.isElementWithGenericParams(member, types[index], elementTypeParams, className) || (resolvedElement = VlogLinkResolverCommon.recursiveResolveElement(member, types, index + 1)) == null) continue;
            return resolvedElement;
        }
        return null;
    }

    public static boolean isInCommentPartition(IDocument document, int offset) {
        String typedRegion = RfBatchUtils.getTypedRegion(document, offset).getType();
        return "__vlog_sl_comment".equals(typedRegion) || "__vlog_ml_comment".equals(typedRegion);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRfScope getRfScopeOfElementForCommentOffset(ITextEditor textEditor, IDocument document, int offset, IRfSingleLangProject project) throws BadLocationException {
        if (!(project instanceof RfProject)) {
            return null;
        }
        line = document.getLineOfOffset(offset);
        while (VlogLinkResolverCommon.isInCommentPartition(document, offset)) {
            line = document.getLineOfOffset(offset);
            offset = document.getLineOffset(line + 1);
        }
        try {
            block11: {
                if (offset < 0) {
                    return null;
                }
                scanner = new DVTCharacterScanner(100, document, offset, true);
                ch = (char)scanner.read();
                if (ch == '\uffff') {
                    return null;
                }
                do {
                    if (Character.isWhitespace(ch)) continue;
                    skipMaxEmptyLinesAbove = (Integer)BuildConfigManager.getDVTConfig((IProject)project.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ABOVE_MAX_EMPTY_LINES);
                    newLine = document.getLineOfOffset(scanner.getOffset());
                    if (newLine - line > skipMaxEmptyLinesAbove + 1) {
                        return null;
                    }
                    break block11;
                } while ((ch = (char)scanner.read()) != '\uffff');
                return null;
            }
            if (VlogLinkResolverCommon.isInCommentPartition(document, scanner.getOffset())) {
                return null;
            }
            while (Character.isJavaIdentifierPart(ch)) {
                ch = (char)scanner.read();
                if (ch != '\uffff') continue;
                return null;
            }
            if (true) ** GOTO lbl38
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return RfUtils.getRfScope(textEditor, document, offset);
        do {
            if ((ch = (char)scanner.read()) != '\uffff') continue;
            return null;
lbl38:
            // 2 sources

        } while (Character.isWhitespace(ch));
        offset = scanner.getOffset();
        return RfUtils.getRfScope(textEditor, document, offset);
    }

    public Collection<IRfNamedElement> getInitialCandidates(IRfNamedElement element, ITextEditor editor) {
        IRfScopeElement scope = element instanceof VlogMacroInfo ? RfUtils.getRfScope(editor, this.getDocument(editor), ((VlogMacroInfo)element).getRealOffset()) : element.getEnclosingScope();
        return VlogLinkResolverCommon.getInitialCandidatesFromScope(scope);
    }

    protected abstract IDocument getDocument(ITextEditor var1);
}

