/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.uvm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfGUISearchUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.search.AggregateSearchQuery;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.uvm.XvmProjectChecker;

public class PredefinedSearchHandler
extends AbstractHandler {
    private static final String NAME_PREDEFINED_SEARCH = "predefinedSearchName";
    private static final String VAL_FACTORY_OVERRIDES = "factoryOverrides";
    private static final String LABEL_FACTORY_OVERRIDES = "UVM Factory Overrides";
    private static final String VAL_CONFIG_DB_GET = "configDbGet";
    private static final String LABEL_CONFIG_DB_GET = "UVM Config DB Getters";
    private static final String VAL_CONFIG_DB_SET = "configDbSet";
    private static final String LABEL_CONFIG_DB_SET = "UVM Config DB Setters";
    private FileTextSearchScope fScope;
    private RfPackage fUvmPkg;
    private RfPackage fOvmPkg;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null || TestHelper.isTestMode()) {
            project = ProjectSelectionDialog.selectProject();
        }
        if ((this.fUvmPkg = XvmProjectChecker.checkXvmProject(project, RfXvmFactory.RfXvmType.UVM)) == null && (this.fOvmPkg = XvmProjectChecker.checkXvmProject(project, RfXvmFactory.RfXvmType.OVM)) == null) {
            MessageDialog.openInformation((Shell)Utils.getActiveShell(), (String)"Not an XVM Project", (String)("Project '" + project.getName() + "' is not an XVM based SystemVerilog project."));
            return null;
        }
        this.fScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", true), (boolean)false);
        AggregateSearchQuery query = null;
        if (VAL_FACTORY_OVERRIDES.equals(event.getParameter(NAME_PREDEFINED_SEARCH))) {
            query = this.makeFactoryOverridesQuery(project);
        } else if (VAL_CONFIG_DB_GET.equals(event.getParameter(NAME_PREDEFINED_SEARCH))) {
            query = this.makeConfigDbGetQuery(project);
        } else if (VAL_CONFIG_DB_SET.equals(event.getParameter(NAME_PREDEFINED_SEARCH))) {
            query = this.makeConfigDbSetQuery(project);
        }
        if (TestHelper.isTestMode()) {
            return TestHelper.testRunQuery((ISearchQuery)query);
        }
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return null;
    }

    private AggregateSearchQuery makeConfigDbSetQuery(IProject project) {
        if (!VlogRfGUIReferencesUtils.synchFiles((IProject)project)) {
            return null;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        candidates.addAll(this.makeConfigDbSetQuery(RfXvmFactory.RfXvmType.OVM));
        candidates.addAll(this.makeConfigDbSetQuery(RfXvmFactory.RfXvmType.UVM));
        AggregateSearchQuery result = new AggregateSearchQuery(this.fScope, LABEL_CONFIG_DB_SET, project);
        for (IRfNamedElement candidate : candidates) {
            BaseFileSearchQuery query = RfGUISearchUtils.getQuery((IProject)project, (IRfNamedElement)candidate, (String)"ro.amiq.vlogdt.VlogNature");
            if (query == null) continue;
            result.addQuery(query);
        }
        return result;
    }

    private List<IRfNamedElement> makeConfigDbSetQuery(RfXvmFactory.RfXvmType type) {
        RfClass uvmConfigDb;
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        RfPackage xvmPkg = null;
        xvmPkg = type == RfXvmFactory.RfXvmType.OVM ? this.fOvmPkg : this.fUvmPkg;
        if (xvmPkg == null) {
            return candidates;
        }
        String typeName = type.toString().toLowerCase();
        RfClass xvmComponent = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_component", 1, 1);
        if (xvmComponent != null) {
            candidates.add(xvmComponent.getFunctionWithPrefix("set_config_int", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("set_config_string", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("set_config_object", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        if (type == RfXvmFactory.RfXvmType.UVM && (uvmConfigDb = xvmPkg.getClassWithPrefix("uvm_config_db", 1, 1)) != null) {
            candidates.add(uvmConfigDb.getFunctionWithPrefix("set", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        return candidates;
    }

    private AggregateSearchQuery makeConfigDbGetQuery(IProject project) {
        if (!VlogRfGUIReferencesUtils.synchFiles((IProject)project)) {
            return null;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        candidates.addAll(this.makeConfigDbGetQuery(RfXvmFactory.RfXvmType.OVM));
        candidates.addAll(this.makeConfigDbGetQuery(RfXvmFactory.RfXvmType.UVM));
        AggregateSearchQuery result = new AggregateSearchQuery(this.fScope, LABEL_CONFIG_DB_GET, project);
        for (IRfNamedElement candidate : candidates) {
            BaseFileSearchQuery query = RfGUISearchUtils.getQuery((IProject)project, (IRfNamedElement)candidate, (String)"ro.amiq.vlogdt.VlogNature");
            if (query == null) continue;
            result.addQuery(query);
        }
        return result;
    }

    private List<IRfNamedElement> makeConfigDbGetQuery(RfXvmFactory.RfXvmType type) {
        RfClass uvmConfigDb;
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        RfPackage xvmPkg = null;
        xvmPkg = type == RfXvmFactory.RfXvmType.OVM ? this.fOvmPkg : this.fUvmPkg;
        if (xvmPkg == null) {
            return candidates;
        }
        String typeName = type.toString().toLowerCase();
        RfClass xvmComponent = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_component", 1, 1);
        if (xvmComponent != null) {
            candidates.add(xvmComponent.getFunctionWithPrefix("get_config_int", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("get_config_string", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("get_config_object", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        if (type == RfXvmFactory.RfXvmType.UVM && (uvmConfigDb = xvmPkg.getClassWithPrefix("uvm_config_db", 1, 1)) != null) {
            candidates.add(uvmConfigDb.getFunctionWithPrefix("get", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        return candidates;
    }

    private AggregateSearchQuery makeFactoryOverridesQuery(IProject project) {
        if (!VlogRfGUIReferencesUtils.synchFiles((IProject)project)) {
            return null;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        candidates.addAll(this.makeFactoryOverridesQuery(RfXvmFactory.RfXvmType.OVM));
        candidates.addAll(this.makeFactoryOverridesQuery(RfXvmFactory.RfXvmType.UVM));
        AggregateSearchQuery result = new AggregateSearchQuery(this.fScope, LABEL_FACTORY_OVERRIDES, project);
        for (IRfNamedElement candidate : candidates) {
            BaseFileSearchQuery query = RfGUISearchUtils.getQuery((IProject)project, (IRfNamedElement)candidate, (String)"ro.amiq.vlogdt.VlogNature");
            if (query == null) continue;
            result.addQuery(query);
        }
        return result;
    }

    private List<IRfNamedElement> makeFactoryOverridesQuery(RfXvmFactory.RfXvmType type) {
        RfClass xvmObjectRegistry;
        RfClass xvmComponentRegistry;
        RfClass xvmFactory;
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        RfPackage xvmPkg = null;
        xvmPkg = type == RfXvmFactory.RfXvmType.OVM ? this.fOvmPkg : this.fUvmPkg;
        if (xvmPkg == null) {
            return candidates;
        }
        String typeName = type.toString().toLowerCase();
        RfClass xvmComponent = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_component", 1, 1);
        if (xvmComponent != null) {
            candidates.add(xvmComponent.getFunctionWithPrefix("set_type_override_by_type", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("set_inst_override_by_type", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("set_type_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponent.getFunctionWithPrefix("set_inst_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        if ((xvmFactory = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_factory", 1, 1)) != null) {
            candidates.add(xvmFactory.getFunctionWithPrefix("set_inst_override_by_type", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmFactory.getFunctionWithPrefix("set_inst_override_by_name", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmFactory.getFunctionWithPrefix("set_type_override_by_type", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmFactory.getFunctionWithPrefix("set_type_override_by_name", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        if ((xvmComponentRegistry = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_component_registry", 1, 1)) != null) {
            candidates.add(xvmComponentRegistry.getFunctionWithPrefix("set_type_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmComponentRegistry.getFunctionWithPrefix("set_inst_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        if ((xvmObjectRegistry = xvmPkg.getClassWithPrefix(String.valueOf(typeName) + "_object_registry", 1, 1)) != null) {
            candidates.add(xvmObjectRegistry.getFunctionWithPrefix("set_type_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
            candidates.add(xvmObjectRegistry.getFunctionWithPrefix("set_inst_override", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        }
        return candidates;
    }
}

