/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.help.IHelpContentProducer;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.help.Utils;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class ContentProducer
implements IHelpContentProducer {
    String fPluginID;
    String fPrefPage;
    String fRootPath;

    public ContentProducer(String pluginID, String prefPage) {
        this.fPluginID = pluginID;
        this.fPrefPage = prefPage;
    }

    public InputStream getInputStream(String arg0, String arg1, Locale arg2) throws NullPointerException {
        String fullPath;
        block7: {
            if (!DVTHelp.getHelpTest()) {
                return this.getLicenseNotLoadedMessage();
            }
            String path = Utils.getDVTPreference(String.valueOf(this.fPluginID) + ".path");
            if (path.equals("")) {
                return this.getNotConfiguredMessage();
            }
            this.fRootPath = String.valueOf(path) + File.separator;
            try {
                fullPath = String.valueOf(this.fRootPath) + arg1.split("\\?")[0];
                if (!fullPath.contains("ro.amiq.dvt.help")) break block7;
                if (fullPath.contains("ro.amiq.dvt.help.dummy.html")) {
                    return this.getSourceUnavailableMessage();
                }
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return this.getSourceUnavailableMessage();
            }
        }
        if (arg1.contains(".htm") || arg1.contains(".html")) {
            String fileContent = this.getFileContent(fullPath);
            String processedFileContent = this.processHTML(fileContent);
            return Utils.stringToInputStream(processedFileContent);
        }
        return new FileInputStream(new File(fullPath));
    }

    InputStream getSourceUnavailableMessage() {
        return Utils.stringToInputStream("<html><body><head><link rel=\"STYLESHEET\" href=\"../ro.amiq.dvt.help.html/book.css\" charset=\"ISO-8859-1\" type=\"text/css\"></head><h1>Help sourcefiles are not accessible.</h1> <hr> Please check the configured path to the location of the help files. See Window -> Preferences -> Help -> " + this.fPrefPage + " </body></html>");
    }

    InputStream getNotConfiguredMessage() {
        return Utils.stringToInputStream("<html><body><head><link rel=\"STYLESHEET\" href=\"../ro.amiq.dvt.help.html/book.css\" charset=\"ISO-8859-1\" type=\"text/css\"></head><h1>Path to the help source files is not configured.</h1> <hr> You need to configure the path to the location of the help files. See Window -> Preferences -> Help -> " + this.fPrefPage + " </body></html>");
    }

    InputStream getLicenseNotLoadedMessage() {
        return Utils.stringToInputStream("<html><body><head><link rel=\"STYLESHEET\" href=\"../ro.amiq.dvt.help.html/book.css\" charset=\"ISO-8859-1\" type=\"text/css\"></head><h1>License for feature <i>dvt</i> not loaded");
    }

    protected abstract String processHTML(String var1);

    protected String getFileContent(String fullPath) throws IOException {
        return Utils.getFileContent(fullPath);
    }
}

