/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.File;
import java.util.regex.Matcher;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.help.Utils;

public class HelpDirectoryFieldEditor
extends DirectoryFieldEditor {
    public HelpDirectoryFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(0);
        this.createControl(parent);
    }

    protected boolean doCheckState() {
        String fileName = this.replaceSysVars(this.getTextControl().getText());
        if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
            return true;
        }
        File file = new File(fileName);
        return file.isDirectory();
    }

    private String replaceSysVars(String input) {
        Matcher matcher = Utils.getSysVarPattern().matcher(input);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String sysVarValue;
                String sysVarName;
                if ((sysVarName = matcher.group(1)) == null) {
                    sysVarName = matcher.group(2);
                }
                if ((sysVarValue = System.getenv(sysVarName)) == null) {
                    this.setErrorMessage("System variable " + sysVarName + " could not be resolved.");
                    return input;
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(sysVarValue));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            input = sb.toString();
        }
        this.setErrorMessage(null);
        return input;
    }
}

