/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.help.HelpDirectoryFieldEditor;
import ro.amiq.dvt.help.HelpPopupMessage;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class HelpPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String fPluginID;
    private String fLabelText;
    private String fExamplePath;
    private Composite fFieldComposite;
    private Button fEnabledButton;
    private DirectoryFieldEditor fDirectoryFieldEditor;

    public HelpPreferencePage(String description, String pluginID, String labelText, String examplePath) {
        super(1);
        this.fPluginID = pluginID;
        this.fLabelText = labelText;
        this.fExamplePath = examplePath;
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription(description);
    }

    public void init(IWorkbench _workbench) {
    }

    protected Control createContents(Composite parent) {
        if (!DVTHelp.getHelpTest()) {
            Text fLicenseData = new Text(parent, 2);
            fLicenseData.setText("No DVT license loaded!");
            fLicenseData.setEditable(false);
            DVTColorUtil.INSTANCE.setBackground((Control)fLicenseData, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
            fLicenseData.setFont(parent.getFont());
            return super.createContents(parent);
        }
        this.addContents(parent);
        this.createFieldEditors();
        this.initialize();
        this.checkState();
        return parent;
    }

    protected void addContents(final Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fEnabledButton = new Button(parent, 32);
        this.fEnabledButton.setFont(parent.getFont());
        this.fEnabledButton.setText("Enable this manual");
        this.fEnabledButton.addMouseListener((MouseListener)new EnableHandler());
        this.fEnabledButton.setSelection(!this.getPreferenceStore().getString(String.valueOf(this.fPluginID) + ".enabled").equals("false"));
        Label label = new Label(parent, 64);
        label.setText("\nFill in the " + this.fLabelText + ".");
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fFieldComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fFieldComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fFieldComposite.setLayoutData((Object)layoutData);
        this.fFieldComposite.setFont(parent.getFont());
        final GridData labelData = new GridData(4, 4, true, true);
        Rectangle rect = parent.getMonitor().getClientArea();
        labelData.widthHint = rect.width / 4;
        Label label2 = new Label(parent, 64);
        label2.setText("\nFor example: " + this.fExamplePath + "\n\nNote: Changes will be reflected in the table of contents only after you reopen the Help Contents window.");
        label2.setFont(parent.getFont());
        label2.setLayoutData((Object)labelData);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = parent.getBounds();
                labelData.widthHint = bounds.width;
                parent.layout();
            }
        });
    }

    protected void createFieldEditors() {
        if (!DVTHelp.getHelpTest()) {
            return;
        }
        this.fDirectoryFieldEditor = new HelpDirectoryFieldEditor(String.valueOf(this.fPluginID) + ".path", "", this.fFieldComposite);
        this.addField((FieldEditor)this.fDirectoryFieldEditor);
        this.fDirectoryFieldEditor.setEnabled(!this.getPreferenceStore().getString(String.valueOf(this.fPluginID) + ".enabled").equals("false"), this.fFieldComposite);
    }

    public boolean performOk() {
        if (this.fDirectoryFieldEditor == null) {
            return true;
        }
        String oldPathString = this.getPreferenceStore().getString(String.valueOf(this.fPluginID) + ".path");
        String newPathString = this.fDirectoryFieldEditor.getStringValue();
        Path newPath = new Path(newPathString);
        Path oldPath = new Path(oldPathString);
        boolean oldEnabled = !this.getPreferenceStore().getString(String.valueOf(this.fPluginID) + ".enabled").equals("false");
        boolean newEnabled = this.fEnabledButton.getSelection();
        super.performOk();
        this.getPreferenceStore().setValue(String.valueOf(this.fPluginID) + ".enabled", "" + this.fEnabledButton.getSelection());
        if (oldPath.equals((Object)newPath) && oldEnabled == newEnabled || this.getPreferenceStore().getBoolean("ro.amiq.dvt.help.reindex") || DVTHelp.getHelpConfigurationDirectory() == null) {
            return true;
        }
        if (!this.getPreferenceStore().getBoolean("ro.amiq.dvt.help.reindex")) {
            this.getPreferenceStore().setValue("ro.amiq.dvt.help.reindex", true);
        }
        new HelpPopupMessage().open();
        return true;
    }

    private class EnableHandler
    extends MouseAdapter {
        private EnableHandler() {
        }

        public void mouseUp(MouseEvent e) {
            HelpPreferencePage.this.fDirectoryFieldEditor.setEnabled(HelpPreferencePage.this.fEnabledButton.getSelection(), HelpPreferencePage.this.fFieldComposite);
        }
    }
}

