/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.TocEntry;
import ro.amiq.dvt.help.Utils;

public class HtmlBookScanner
extends DefaultHandler {
    private String fBookTitle;
    private TocEntry[] fTocLevels = new TocEntry[10];
    private int fCurrentLevel;
    private boolean fWaitingTitle;
    private boolean fWaitingHref;
    private String fHref;
    private ArrayList<String> fHierarchyTags = new ArrayList();
    private ArrayList<String> fEntryTags = new ArrayList();

    public HtmlBookScanner() {
        this.fHierarchyTags.add("h2");
        this.fHierarchyTags.add("p");
        this.fHierarchyTags.add("dd");
        this.fEntryTags.add("a");
    }

    public Book scan(String pathToBook) {
        BufferedReader tocHtml;
        File tocHtmlFile = new File(String.valueOf(pathToBook) + "/" + Utils.getBookFromPath(pathToBook) + "TOC.html");
        if (!tocHtmlFile.exists()) {
            return null;
        }
        File copyHtmlFile = new File(String.valueOf(pathToBook) + "/titlecopy.html");
        if (!copyHtmlFile.exists()) {
            copyHtmlFile = new File(String.valueOf(pathToBook) + "/trademarks.html");
        }
        if (!copyHtmlFile.exists()) {
            return null;
        }
        String copyHtmlFileName = copyHtmlFile.exists() ? "titlecopy.html" : "trademarks.html";
        try {
            tocHtml = new BufferedReader(new FileReader(tocHtmlFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        String blockquote = this.extractTitleAndBlockquote(tocHtml);
        if (blockquote == null) {
            return null;
        }
        this.fTocLevels[0] = new Book(this.fBookTitle, copyHtmlFileName, pathToBook);
        this.fCurrentLevel = 0;
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.parse(new InputSource(this.stringToInputStream(blockquote.toString())));
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return (Book)this.fTocLevels[0];
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.fHierarchyTags.contains(qName)) {
            this.fCurrentLevel = this.fHierarchyTags.indexOf(qName) + 1;
            this.fWaitingHref = true;
        } else if (this.fEntryTags.contains(qName) && atts.getLength() == 1 && atts.getQName(0).equals("href") && this.fWaitingHref) {
            this.fHref = atts.getValue(0);
            this.fWaitingTitle = true;
            this.fWaitingHref = false;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.fHierarchyTags.contains(qName)) {
            this.fWaitingHref = false;
        } else if (this.fEntryTags.contains(qName)) {
            this.fWaitingTitle = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fWaitingTitle) {
            TocEntry t = new TocEntry(new String(ch, start, length), this.fHref);
            this.fTocLevels[this.fCurrentLevel - 1].addTopic(t);
            this.fTocLevels[this.fCurrentLevel] = t;
        }
    }

    private InputStream stringToInputStream(String s) {
        try {
            byte[] bytes = null;
            bytes = s.getBytes("UTF-8");
            return new ByteArrayInputStream(bytes);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private String extractTitleAndBlockquote(BufferedReader tocHtml) {
        boolean blockquoteON = false;
        StringBuilder blockquote = new StringBuilder();
        try {
            String line;
            while ((line = tocHtml.readLine()) != null) {
                if (blockquoteON) {
                    blockquote.append(line);
                    if (!line.matches("</blockquote>")) {
                        continue;
                    }
                    break;
                }
                Matcher titleMatcher = Pattern.compile("<title>(.*) -- Table Of Contents</title>", 2).matcher(line);
                if (titleMatcher.matches()) {
                    this.fBookTitle = titleMatcher.group(1);
                }
                if (!line.matches("<blockquote>")) continue;
                blockquote.append(line);
                blockquoteON = true;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return blockquote.toString();
    }
}

