/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.util.ArrayList;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.TocEntry;

public class HtmlTocGenerator {
    public static String generate(ArrayList<Book> books) {
        StringBuilder result = new StringBuilder();
        for (Book helpBook : books) {
            result.append(HtmlTocGenerator.generate(helpBook));
        }
        return result.toString();
    }

    public static String generate(Book book) {
        StringBuilder result = new StringBuilder();
        result.append("<head>");
        result.append("<meta http-equiv=\"Content-Language\" content=\"en-us\">");
        result.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">");
        result.append("<script src=\"mktree.js\" language=\"javascript\"></script>");
        result.append("<link rel=\"stylesheet\" href=\"mktree.css\">");
        result.append("<title>Getting Started</title>");
        result.append("</head>");
        result.append("<h2>" + book.getLabel() + "</h2>");
        result.append("<ul class=\"mktree\" id=\"toc_tree\">");
        for (TocEntry t : book.getTopics()) {
            result.append(HtmlTocGenerator.generate(t, 1));
        }
        result.append("</ul>");
        result.append("<hr>\n");
        return result.toString();
    }

    private static String generate(TocEntry topic, int level) {
        StringBuilder result = new StringBuilder();
        if (topic.getTopics() != null) {
            result.append("<li><a href=\"" + topic.getHref() + "\">" + topic.getLabel() + "</a>\n");
            if (!topic.getTopics().isEmpty()) {
                result.append("<ul>");
            }
            for (TocEntry t : topic.getTopics()) {
                result.append(HtmlTocGenerator.generate(t, level + 1));
            }
            if (!topic.getTopics().isEmpty()) {
                result.append("</ul>");
            }
            result.append("</li>");
            return result.toString();
        }
        return "";
    }
}

