/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.ITocContribution;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IHelpTestChangeListener;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.TocContribution;
import ro.amiq.dvt.help.TocEntry;
import ro.amiq.dvt.help.Utils;

public class TocProvider
extends AbstractTocProvider
implements IPropertyChangeListener,
IHelpTestChangeListener {
    protected String fPluginID;
    String fBookTitle;

    public TocProvider(String pluginID, String bookTitle) {
        this.fPluginID = pluginID;
        this.fBookTitle = bookTitle;
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DVTHelp.addLicenseChangeLister((IHelpTestChangeListener)this);
    }

    public ITocContribution[] getTocContributions(String locale) {
        if (!DVTHelp.getHelpTest() || DVTPlugin.getDefault().getPreferenceStore().getString(String.valueOf(this.fPluginID) + ".enabled").equals("false")) {
            return new ITocContribution[0];
        }
        Book book = null;
        String bookPath = Utils.getDVTPreference(String.valueOf(this.fPluginID) + ".path");
        book = Utils.scanBook(bookPath);
        ITocContribution[] tocContributions = new ITocContribution[1];
        if (book == null) {
            book = this.getDefaultBook();
        } else {
            book.setLabel(String.valueOf(this.fBookTitle) + " - " + book.getLabel());
        }
        tocContributions[0] = new TocContribution(book, this.fPluginID);
        return tocContributions;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().contains(this.fPluginID)) {
            this.contentChanged();
        }
    }

    protected Book getDefaultBook() {
        Book defaultBook = new Book(this.fBookTitle, "html/ro.amiq.dvt.help.dummy.html", "");
        defaultBook.addTopic(new TocEntry("Help content not available", "html/ro.amiq.dvt.help.dummy.html"));
        return defaultBook;
    }

    public void licenseChanged() {
        this.contentChanged();
    }
}

