/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.TocEntry;

public class TocXmlParser
extends DefaultHandler {
    private String fBookTitle;
    private TocEntry[] fTocLevels = new TocEntry[10];
    private int fCurrentLevel;

    public Book scan(InputSource is) {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.parse(is);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return (Book)this.fTocLevels[0];
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        ++this.fCurrentLevel;
        if (qName.equals("toc")) {
            if (this.fBookTitle == null) {
                this.fCurrentLevel = 0;
                this.fBookTitle = atts.getValue("label");
                this.fTocLevels[this.fCurrentLevel] = new Book(this.fBookTitle, atts.getValue("topic"), "");
            }
        } else if (qName.equals("topic")) {
            TocEntry t = new TocEntry(atts.getValue("label"), atts.getValue("href"));
            this.fTocLevels[this.fCurrentLevel - 1].addTopic(t);
            this.fTocLevels[this.fCurrentLevel] = t;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        --this.fCurrentLevel;
    }
}

