/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.HtmlTocGenerator;
import ro.amiq.dvt.help.JsBookScanner;
import ro.amiq.dvt.help.XmlBookScanner;
import ro.amiq.dvt.help.XmlTocGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;

public class Utils {
    private static final Pattern fSysVarPattern = Pattern.compile("\\$\\{?([a-zA-Z0-9_]+)\\}?|%([a-zA-Z0-9_]+)%", 8);

    public static String getDVTPreference(String key) {
        String result = DVTPlugin.getDefault().getPreferenceStore().getString(key);
        if (key.endsWith(".path") && (result = Utils.replaceSysVars(result)) == null) {
            return "";
        }
        return result;
    }

    public static String getBookFromPath(String pathToBook) {
        return pathToBook.split("/")[pathToBook.split("/").length - 1];
    }

    public static String getHtmlToc(String bookPath) {
        JsBookScanner jsBookScanner = new JsBookScanner();
        Book book = jsBookScanner.scan(bookPath);
        if (book == null) {
            XmlBookScanner xmlBookScanner = new XmlBookScanner();
            book = xmlBookScanner.scan(bookPath);
            if (book == null) {
                return null;
            }
            return HtmlTocGenerator.generate(book);
        }
        return HtmlTocGenerator.generate(book);
    }

    public static String getXmlToc(String bookPath) {
        JsBookScanner jsBookScanner = new JsBookScanner();
        Book book = jsBookScanner.scan(bookPath);
        if (book == null) {
            XmlBookScanner xmlBookScanner = new XmlBookScanner();
            book = xmlBookScanner.scan(bookPath);
            if (book == null) {
                return null;
            }
            return XmlTocGenerator.generate(book);
        }
        return XmlTocGenerator.generate(book);
    }

    public static Book scanBook(String bookPath) {
        JsBookScanner jsBookScanner = new JsBookScanner();
        Book book = jsBookScanner.scan(bookPath);
        if (book == null) {
            XmlBookScanner xmlBookScanner = new XmlBookScanner();
            book = xmlBookScanner.scan(bookPath);
            if (book == null) {
                return null;
            }
            return book;
        }
        return book;
    }

    public static InputStream stringToInputStream(String s) {
        try {
            byte[] bytes = null;
            bytes = s.getBytes("UTF-8");
            return new ByteArrayInputStream(bytes);
        }
        catch (UnsupportedEncodingException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static String getFileContent(String fullPath) throws IOException {
        return Utils.getFileContent(fullPath, "UTF-8");
    }

    public static String getFileContent(String fullPath, String encoding) throws IOException {
        String line;
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(fullPath), encoding);
        BufferedReader br = new BufferedReader(r);
        String fileContent = "";
        while ((line = br.readLine()) != null) {
            fileContent = fileContent.concat(String.valueOf(line) + "\n");
        }
        return fileContent;
    }

    static String unescapeHtmlUtf(String input) {
        int value = 0;
        Matcher m = Pattern.compile("&#([xX]|)([0-9A-Fa-f]+);").matcher(input);
        boolean result = m.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                value = m.group(1).equals("x") || m.group(1).equals("X") ? Integer.parseInt(m.group(2), 16) : Integer.parseInt(m.group(2));
                m.appendReplacement(sb, new String(Character.toChars(value)));
            } while (result = m.find());
            m.appendTail(sb);
            input = sb.toString();
        }
        return input;
    }

    public static String unescapeJsUtf(String input) {
        int value = 0;
        Matcher m = Pattern.compile("\\\\u([0-9a-fA-F]{4})").matcher(input);
        boolean result = m.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                value = Integer.parseInt(m.group(1), 16);
                m.appendReplacement(sb, new String(Character.toChars(value)));
            } while (result = m.find());
            m.appendTail(sb);
            input = sb.toString();
        }
        return input;
    }

    public static String fixUTFTrademarks(String input) {
        try {
            String copyright = new String(new int[]{169}, 0, 1);
            String registered = new String(new int[]{174}, 0, 1);
            input = input.replaceAll(copyright, "&#a9;");
            input = input.replaceAll(registered, "&#ae;");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return input;
    }

    public static String replaceSysVars(String input) {
        Matcher matcher = fSysVarPattern.matcher(input);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String sysVarValue;
                String sysVarName;
                if ((sysVarName = matcher.group(1)) == null) {
                    sysVarName = matcher.group(2);
                }
                if ((sysVarValue = System.getenv(sysVarName)) == null) {
                    return null;
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(sysVarValue));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            input = sb.toString();
        }
        return input;
    }

    public static Pattern getSysVarPattern() {
        return fSysVarPattern;
    }
}

