/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import ro.amiq.dvt.help.Book;
import ro.amiq.dvt.help.TocEntry;
import ro.amiq.dvt.help.Utils;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XmlBookScanner
extends DefaultHandler {
    private String fBookTitle;
    private String fBookPath;
    private TocEntry[] fTocLevels = new TocEntry[10];
    private int fCurrentLevel;

    public Book scan(String pathToBook) {
        this.fBookPath = pathToBook;
        File bookXml = new File(String.valueOf(pathToBook) + "/" + Utils.getBookFromPath(pathToBook) + ".xml");
        if (!bookXml.exists()) {
            bookXml = new File(String.valueOf(pathToBook) + "/topicset.xml");
        }
        if (!bookXml.exists()) {
            return null;
        }
        File copyHtml = new File(String.valueOf(pathToBook) + "/titlecopy.html");
        if (!copyHtml.exists()) {
            copyHtml = new File(String.valueOf(pathToBook) + "/trademarks.html");
        }
        if (!copyHtml.exists()) {
            return null;
        }
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            String xmlContent = Utils.getFileContent(bookXml.getAbsolutePath());
            String newContent = xmlContent.replace("&nbsp;", "&amp;nbsp;");
            ByteArrayInputStream is = new ByteArrayInputStream(newContent.getBytes("UTF-8"));
            xr.parse(new InputSource(is));
        }
        catch (SAXException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return (Book)this.fTocLevels[0];
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        ++this.fCurrentLevel;
        if (qName.equals("manual")) {
            if (this.fBookTitle == null) {
                this.fCurrentLevel = 0;
                this.fBookTitle = atts.getValue("text");
                this.fTocLevels[this.fCurrentLevel] = new Book(this.fBookTitle, atts.getValue("href"), this.fBookPath);
            }
        } else if (qName.equals("topic")) {
            TocEntry t = new TocEntry(atts.getValue("text"), atts.getValue("href"));
            this.fTocLevels[this.fCurrentLevel - 1].addTopic(t);
            this.fTocLevels[this.fCurrentLevel] = t;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        --this.fCurrentLevel;
    }
}

