/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import java.net.Socket;
import java.util.Random;
import ro.amiq.dvt.patcher.Patcher;

public enum ChromiumBrowser {
    INSTANCE;


    public void init(boolean enabled) {
        try {
            if (enabled) {
                Patcher.INSTANCE.logInfo("chromium browser is enabled", null);
                Integer debuggingPort = ChromiumBrowser.getDebuggingPort();
                if (debuggingPort != null) {
                    System.setProperty("dvt.chromium.remote-debugging-port.value", debuggingPort.toString());
                    System.setProperty("chromium.args", String.valueOf(System.getProperty("chromium.args")) + ";--remote-debugging-port=" + debuggingPort + ";");
                    Patcher.INSTANCE.logInfo("chromium browser remote debugging port is " + debuggingPort, null);
                }
                if (Patcher.INSTANCE.getOS().equals("linux") && System.getProperty("chromium.init_threads", "false").equals("true")) {
                    try {
                        com.equo.chromium.ChromiumBrowser.earlyInit();
                        Patcher.INSTANCE.logInfo("chromium browser early init", null);
                    }
                    catch (Throwable t) {
                        Patcher.INSTANCE.logError("chromium browser early init failed", t);
                    }
                }
            } else {
                Patcher.INSTANCE.logInfo("chromium browser is disabled", null);
            }
        }
        catch (Throwable t) {
            Patcher.INSTANCE.logError(null, t);
        }
    }

    private static Integer getDebuggingPort() {
        try {
            int debuggingPort = Integer.parseInt(System.getProperty("dvt.chromium.remote-debugging-port"));
            if (debuggingPort == 0) {
                return ChromiumBrowser.generateRandomPort();
            }
            if (debuggingPort >= 1024 && debuggingPort <= 65535) {
                return debuggingPort;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static Integer generateRandomPort() {
        Random random = new Random();
        int i = 0;
        while (i < 10) {
            int port = random.nextInt(64511) + 1024;
            try {
                Throwable throwable = null;
                Object var4_4 = null;
                try {
                    Socket ignored = new Socket("localhost", port);
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return port;
            }
            ++i;
        }
        return null;
    }
}

