/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import ro.amiq.dvt.patcher.Patcher;

public class Constants {
    public static final String ID = "ro.amiq.dvt.patcher";
    public static final String STARTED_PROP = "ro.amiq.dvt.patcher.started";
    public static final String ENABLED_PROP = "ro.amiq.dvt.patcher.enabled";
    public static final String CONTAINERS_PROP = "ro.amiq.dvt.patcher.containers";
    public static final boolean ENABLED = System.getProperty("ro.amiq.dvt.patcher.enabled", "true").equals("true");
    public static final String[] CONTAINERS = Constants.computeContainers();

    private static String[] computeContainers() {
        String containerPaths;
        ArrayList<String> containers = new ArrayList<String>();
        String selfContainer = Constants.computeSelf();
        if (selfContainer != null) {
            containers.add(selfContainer);
        }
        if ((containerPaths = System.getProperty(CONTAINERS_PROP)) != null && !containerPaths.isEmpty()) {
            String[] containerPathsSplit;
            String[] stringArray = containerPathsSplit = containerPaths.split(File.pathSeparator);
            int n = containerPathsSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String containerPath = stringArray[n2];
                if (!containerPath.trim().isEmpty()) {
                    containers.add(containerPath);
                }
                ++n2;
            }
        }
        try {
            File patchesDir;
            String userDir = System.getenv("DVT_USER_DIR");
            if (userDir == null) {
                userDir = String.valueOf(System.getProperty("user.home")) + File.separatorChar + ".dvt";
            }
            if ((patchesDir = new File(userDir, "patches")).exists()) {
                File[] dotPatchesFiles;
                File[] fileArray = dotPatchesFiles = patchesDir.listFiles(file -> (file.getName().endsWith(".jar") || file.isDirectory()) && file.canRead());
                int n = dotPatchesFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    File file2 = fileArray[n3];
                    containers.add(file2.getAbsolutePath());
                    ++n3;
                }
            }
        }
        catch (Exception exception) {}
        return containers.toArray(new String[containers.size()]);
    }

    private static String computeSelf() {
        URL soruceCodeLocation = Patcher.class.getProtectionDomain().getCodeSource().getLocation();
        Path path = null;
        try {
            path = Paths.get(soruceCodeLocation.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            String stringPath = soruceCodeLocation.getPath();
            try {
                path = Paths.get(stringPath, new String[0]);
            }
            catch (InvalidPathException invalidPathException) {
                stringPath = stringPath.replaceFirst("^/(.:/)", "$1");
                try {
                    path = Paths.get(stringPath, new String[0]);
                }
                catch (InvalidPathException invalidPathException2) {}
            }
        }
        if (path != null) {
            return path.toString();
        }
        return null;
    }
}

