/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiMap<K, V> {
    private final Map<K, Value<V>> fMap = new LinkedHashMap<K, Value<V>>();

    public void put(K key, V value) {
        Value<V> existingObject = this.fMap.get(key);
        if (existingObject == null) {
            this.fMap.put(key, new Value<V>(value));
        } else {
            existingObject.add(value);
        }
    }

    public List<V> get(K key) {
        Value<V> result = this.fMap.get(key);
        if (result != null) {
            return result.get();
        }
        return Collections.emptyList();
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    private static final class Value<W> {
        private W fSingleValue;
        private List<W> fMultiValue;

        public Value(W value) {
            this.fSingleValue = value;
        }

        public void add(W value) {
            if (this.fMultiValue == null) {
                this.fMultiValue = new LinkedList<W>();
            }
            this.fMultiValue.add(this.fSingleValue);
            this.fMultiValue.add(value);
            this.fSingleValue = null;
        }

        public List<W> get() {
            if (this.fMultiValue != null) {
                return Collections.unmodifiableList(this.fMultiValue);
            }
            return Collections.singletonList(this.fSingleValue);
        }
    }
}

