/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import ro.amiq.dvt.patcher.MultiMap;
import ro.amiq.dvt.patcher.PatcherWeavingHook;

public enum Patcher {
    INSTANCE;

    private String fOS;
    private String fArch;
    private String fWS;
    private MultiMap<String, Bundle> fBundles;
    private ServiceRegistration<?> fHookServiceReference;
    private ServiceReference<ExtendedLogService> fLogServiceReference;
    private ExtendedLogService fLogService;
    private Logger fLogger;

    public void start(BundleContext context) throws Exception {
        this.registerLogger(context);
        if (!this.readEnvironmentInfo(context)) {
            this.logError("could not read environment information", null);
            return;
        }
        if (!this.readBundlesList(context)) {
            this.logError("could not read bundles information", null);
            return;
        }
        this.logInfo("started", null);
        System.setProperty("ro.amiq.dvt.patcher.started", "true");
        this.fHookServiceReference = context.registerService(WeavingHook.class.getName(), (Object)PatcherWeavingHook.INSTANCE, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fHookServiceReference != null) {
            this.fHookServiceReference.unregister();
        }
        this.unregisterLogger(context);
    }

    public String getOS() {
        return this.fOS;
    }

    public String getArch() {
        return this.fArch;
    }

    public String getWS() {
        return this.fWS;
    }

    public MultiMap<String, Bundle> getBundles() {
        return this.fBundles;
    }

    private boolean readEnvironmentInfo(BundleContext context) {
        boolean result = false;
        ServiceReference environmentServiceReference = context.getServiceReference(EnvironmentInfo.class);
        if (environmentServiceReference != null) {
            EnvironmentInfo environmentService = (EnvironmentInfo)context.getService(environmentServiceReference);
            if (environmentService != null) {
                this.fOS = environmentService.getOS();
                this.fArch = environmentService.getOSArch();
                this.fWS = environmentService.getWS();
                result = this.fOS != null && this.fArch != null && this.fWS != null;
                environmentService = null;
            }
            context.ungetService(environmentServiceReference);
        }
        return result;
    }

    private boolean readBundlesList(BundleContext context) {
        Bundle[] bundles;
        this.fBundles = new MultiMap();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            this.fBundles.put(bundle.getSymbolicName(), bundle);
            ++n2;
        }
        return !this.fBundles.isEmpty();
    }

    private void registerLogger(BundleContext context) {
        this.fLogServiceReference = context.getServiceReference(ExtendedLogService.class);
        if (this.fLogServiceReference != null) {
            this.fLogService = (ExtendedLogService)context.getService(this.fLogServiceReference);
            if (this.fLogService != null) {
                this.fLogger = this.fLogService.getLogger("org.eclipse.equinox.logger");
            }
        }
    }

    private void unregisterLogger(BundleContext context) {
        this.fLogger = null;
        this.fLogService = null;
        if (this.fLogServiceReference != null) {
            context.ungetService(this.fLogServiceReference);
        }
    }

    public void logDebug(String message, Throwable throwable) {
        this.log(4, message, throwable);
    }

    public void logInfo(String message, Throwable throwable) {
        this.log(3, message, throwable);
    }

    public void logWarning(String message, Throwable throwable) {
        this.log(2, message, throwable);
    }

    public void logError(String message, Throwable throwable) {
        this.log(1, message, throwable);
    }

    private void log(int level, String message, Throwable throwable) {
        if (this.fLogger != null) {
            this.fLogger.log(level, "DVT Patcher: " + (message == null ? "" : message), throwable);
        }
    }
}

