/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import ro.amiq.dvt.patcher.ChromiumBrowser;
import ro.amiq.dvt.patcher.Clazz;
import ro.amiq.dvt.patcher.Constants;
import ro.amiq.dvt.patcher.Filter;
import ro.amiq.dvt.patcher.MultiMap;
import ro.amiq.dvt.patcher.Patcher;
import ro.amiq.dvt.patcher.Patchset;
import ro.amiq.dvt.patcher.PatchsetEnablement;
import ro.amiq.dvt.patcher.PatchsetParser;

public enum PatcherWeavingHook implements WeavingHook
{
    INSTANCE;

    private final MultiMap<String, Clazz> fClassPatches;

    private PatcherWeavingHook() {
        Patcher.INSTANCE.logInfo("begin initializing weaving hook", null);
        Map<String, Patchset> loadedPatchsets = this.loadPachsets();
        Map<String, Patchset> enabledPatchsets = this.filterEnabledPatchsets(loadedPatchsets);
        ChromiumBrowser.INSTANCE.init(enabledPatchsets.containsKey("chromium-browser"));
        this.fClassPatches = this.filterValidPatchsets(enabledPatchsets);
        Patcher.INSTANCE.logInfo("end initializing weaving hook", null);
    }

    private Map<String, Patchset> loadPachsets() {
        LinkedHashMap<String, Patchset> result = new LinkedHashMap<String, Patchset>();
        String[] stringArray = Constants.CONTAINERS;
        int n = Constants.CONTAINERS.length;
        int n2 = 0;
        while (n2 < n) {
            String container = stringArray[n2];
            Patcher.INSTANCE.logInfo("reading patchset container [ " + container + " ]", null);
            List<Patchset> patchsets = PatchsetParser.parse(container);
            if (patchsets.isEmpty()) {
                Patcher.INSTANCE.logInfo("skipping patchset container [ " + container + " ] with no patchsets", null);
            } else {
                for (Patchset patchset : patchsets) {
                    Patchset oldPatchset = result.put(patchset.name, patchset);
                    if (oldPatchset == null) continue;
                    Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + container + " ] is overwriting an exsiting patchset from patchset container [ " + oldPatchset.container + " ]", null);
                }
            }
            ++n2;
        }
        return result;
    }

    private Map<String, Patchset> filterEnabledPatchsets(Map<String, Patchset> input) {
        LinkedHashMap<String, Patchset> result = new LinkedHashMap<String, Patchset>();
        for (Patchset patchset : input.values()) {
            PatchsetEnablement userEnabled = PatchsetEnablement.isEnabled(patchset.name);
            if (patchset.enabled) {
                if (userEnabled == PatchsetEnablement.NA || userEnabled == PatchsetEnablement.TRUE) {
                    result.put(patchset.name, patchset);
                    continue;
                }
                Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] is disabled by user", null);
                continue;
            }
            if (userEnabled == PatchsetEnablement.NA) {
                Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] is disabled by default", null);
                continue;
            }
            if (userEnabled == PatchsetEnablement.FALSE) {
                Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] is disabled by default and by user", null);
                continue;
            }
            Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] is enabled by user", null);
            result.put(patchset.name, patchset);
        }
        return result;
    }

    private MultiMap<String, Clazz> filterValidPatchsets(Map<String, Patchset> input) {
        MultiMap<String, Clazz> result = new MultiMap<String, Clazz>();
        for (Patchset patchset : input.values()) {
            Filter selectedFilter = null;
            block1: for (Filter filter : patchset.filters) {
                if (filter.arch != null && !filter.arch.equals(Patcher.INSTANCE.getArch()) || filter.os != null && !filter.os.equals(Patcher.INSTANCE.getOS()) || filter.ws != null && !filter.ws.equals(Patcher.INSTANCE.getWS())) continue;
                for (Clazz clazz : filter.classes) {
                    List<Bundle> installedBundles = Patcher.INSTANCE.getBundles().get(clazz.bundle);
                    if (installedBundles.isEmpty()) {
                        Patcher.INSTANCE.logInfo("skipping filter in patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] because there is no bundle [ " + clazz.bundle + " ] for class [ " + clazz.name + " ]", null);
                        continue block1;
                    }
                    Version matchingVersion = null;
                    for (Bundle installedBundle : installedBundles) {
                        if (!clazz.version.includes(installedBundle.getVersion())) continue;
                        matchingVersion = installedBundle.getVersion();
                        break;
                    }
                    if (matchingVersion == null) {
                        Patcher.INSTANCE.logInfo("skipping filter in patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] because there is no bundle [ " + clazz.bundle + " ] with version [ " + clazz.version.toString() + " ] for class [ " + clazz.name + " ]", null);
                        continue block1;
                    }
                    List<Clazz> existingClasses = result.get(clazz.name);
                    for (Clazz existingClass : existingClasses) {
                        if (!existingClass.bundle.equals(clazz.bundle) || !existingClass.version.includes(matchingVersion)) continue;
                        Patcher.INSTANCE.logInfo("skipping filter in patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] because there is already a patchset for bundle [ " + clazz.bundle + " ] for class [ " + clazz.name + " ]", null);
                        continue block1;
                    }
                }
                selectedFilter = filter;
                break;
            }
            if (selectedFilter == null) {
                Patcher.INSTANCE.logInfo("skipping patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] because no filter matches", null);
                continue;
            }
            for (Clazz clazz : selectedFilter.classes) {
                result.put(clazz.name, clazz);
            }
            Patcher.INSTANCE.logInfo("patchset [ " + patchset.name + " ] in patchset container [ " + patchset.container + " ] will be applied", null);
        }
        return result;
    }

    public void weave(WovenClass wovenClass) {
        List<Clazz> classPatch = this.fClassPatches.get(wovenClass.getClassName());
        if (classPatch.isEmpty()) {
            return;
        }
        String bundleName = wovenClass.getBundleWiring().getBundle().getSymbolicName();
        Version bundleVersion = wovenClass.getBundleWiring().getBundle().getVersion();
        for (Clazz clazz : classPatch) {
            if (!clazz.bundle.equals(bundleName) || !clazz.version.includes(bundleVersion)) continue;
            wovenClass.setBytes(clazz.replacement);
            if (!clazz.dynamicImports.isEmpty()) {
                wovenClass.getDynamicImports().addAll(clazz.dynamicImports);
            }
            Patcher.INSTANCE.logInfo("patch applied for class [ " + clazz.name + " ] in bundle [ " + clazz.bundle + " ] with version [ " + clazz.version.toString() + " ]", null);
            break;
        }
    }
}

