/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.patcher;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.amiq.dvt.patcher.Clazz;
import ro.amiq.dvt.patcher.Filter;
import ro.amiq.dvt.patcher.Patcher;
import ro.amiq.dvt.patcher.Patchset;

public class PatchsetParser {
    private static final String TAG_PATCHSET = "patchset";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_CLASS = "class";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_OS = "os";
    private static final String ATTR_ARCH = "arch";
    private static final String ATTR_WS = "ws";
    private static final String ATTR_BUNDLE = "bundle";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_REPLACEMENT = "replacement";
    private static final String ATTR_DYNAMIC_IMPORTS = "dynamic-imports";
    private static final ScriptEngine SCRIPT_ENGINE;
    private final String fContainer;
    private final InputStreamProvider fISProvider;

    static {
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
            if (scriptEngine == null) {
                Patcher.INSTANCE.logError("no script engine available for patchset parser, patchsets with non boolean expressions will not be enabled", null);
            }
        }
        catch (Exception e) {
            Patcher.INSTANCE.logError("exception while initializaing script engine for patchset parser", e);
        }
        SCRIPT_ENGINE = scriptEngine;
    }

    private PatchsetParser(String container) {
        if (container == null || container.isEmpty()) {
            throw new IllegalArgumentException("container value is null or empty");
        }
        this.fContainer = container;
        File containerFile = new File(this.fContainer);
        if (!containerFile.canRead()) {
            throw new IllegalArgumentException("patchset container [ " + this.fContainer + " ] is not readable");
        }
        if (containerFile.isDirectory()) {
            this.fISProvider = new InputStreamProvider(){
                private final File fContainerFile;
                private final List<InputStream> fOpenedInputStreams;
                {
                    this.fContainerFile = new File(PatchsetParser.this.fContainer);
                    this.fOpenedInputStreams = new ArrayList<InputStream>();
                }

                @Override
                public InputStream getInputStream(String path) throws FileNotFoundException {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(this.fContainerFile, path)));
                    this.fOpenedInputStreams.add(is);
                    return is;
                }

                @Override
                public void close() {
                    for (InputStream inputStream : this.fOpenedInputStreams) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.fOpenedInputStreams.clear();
                }
            };
        } else if (containerFile.getName().endsWith(".jar") && containerFile.isFile()) {
            try {
                this.fISProvider = new InputStreamProvider(){
                    private final JarFile fContainerFile;
                    private final List<InputStream> fOpenedInputStreams;
                    {
                        this.fContainerFile = new JarFile(PatchsetParser.this.fContainer);
                        this.fOpenedInputStreams = new ArrayList<InputStream>();
                    }

                    @Override
                    public InputStream getInputStream(String path) throws FileNotFoundException {
                        JarEntry entry = this.fContainerFile.getJarEntry(path);
                        if (entry == null) {
                            throw new FileNotFoundException(path);
                        }
                        try {
                            InputStream is = this.fContainerFile.getInputStream(entry);
                            this.fOpenedInputStreams.add(is);
                            return is;
                        }
                        catch (IOException iOException) {
                            throw new FileNotFoundException(path);
                        }
                    }

                    @Override
                    public void close() {
                        for (InputStream inputStream : this.fOpenedInputStreams) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        this.fOpenedInputStreams.clear();
                        try {
                            this.fContainerFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                };
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("patchset container [ " + this.fContainer + " ] unkown format");
            }
        } else {
            throw new IllegalArgumentException("patchset container [ " + this.fContainer + " ] unkown format");
        }
    }

    private List<Patchset> parse() {
        LinkedList<Patchset> result = new LinkedList<Patchset>();
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(this.fISProvider.getInputStream("patchsets.xml"));
        }
        catch (FileNotFoundException e) {
            Patcher.INSTANCE.logError("patchset container [ " + this.fContainer + " ] doesn't contain resource [ " + e.getMessage() + " ]", null);
            return result;
        }
        catch (ParserConfigurationException e) {
            Patcher.INSTANCE.logError("exception while reading patchset container [ " + this.fContainer + " ]", e);
            return result;
        }
        catch (SAXException e) {
            Patcher.INSTANCE.logError("exception while reading patchset container [ " + this.fContainer + " ]", e);
            return result;
        }
        catch (IOException e) {
            Patcher.INSTANCE.logError("exception while reading patchset container [ " + this.fContainer + " ]", e);
            return result;
        }
        NodeList patchsetNodes = document.getElementsByTagName(TAG_PATCHSET);
        int i = 0;
        while (i < patchsetNodes.getLength()) {
            Element patchsetNode = (Element)patchsetNodes.item(i);
            String patchsetName = patchsetNode.getAttribute(ATTR_NAME);
            if (patchsetName == null || patchsetName.isEmpty()) {
                Patcher.INSTANCE.logError("skipping patchset with null name in patchset container [ " + this.fContainer + " ]", null);
            } else {
                String patchsetEnabledValue = patchsetNode.getAttribute(ATTR_ENABLED);
                if (patchsetEnabledValue != null && !patchsetEnabledValue.isEmpty()) {
                    Object patchsetEnabled = Boolean.FALSE;
                    try {
                        if (SCRIPT_ENGINE != null) {
                            patchsetEnabled = SCRIPT_ENGINE.eval(patchsetEnabledValue);
                            if (!(patchsetEnabled instanceof Boolean)) {
                                patchsetEnabled = Boolean.FALSE;
                                Patcher.INSTANCE.logError("skipping patchset with non-boolean expression for enabled attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                            }
                        } else {
                            patchsetEnabled = Boolean.parseBoolean(patchsetEnabledValue);
                        }
                    }
                    catch (Exception e) {
                        patchsetEnabled = Boolean.FALSE;
                        Patcher.INSTANCE.logError("skipping patchset with invalid expression for enabled attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", e);
                    }
                    ArrayList<Filter> filters = new ArrayList<Filter>();
                    NodeList filterNodes = patchsetNode.getElementsByTagName(TAG_FILTER);
                    int j = 0;
                    while (j < filterNodes.getLength()) {
                        block36: {
                            String filterWS;
                            String filterArch;
                            Element filterNode = (Element)filterNodes.item(j);
                            String filterOS = filterNode.getAttribute(ATTR_OS);
                            if (filterOS != null && filterOS.isEmpty()) {
                                filterOS = null;
                            }
                            if ((filterArch = filterNode.getAttribute(ATTR_ARCH)) != null && filterArch.isEmpty()) {
                                filterArch = null;
                            }
                            if ((filterWS = filterNode.getAttribute(ATTR_WS)) != null && filterWS.isEmpty()) {
                                filterWS = null;
                            }
                            ArrayList<Clazz> classes = new ArrayList<Clazz>();
                            NodeList classNodes = filterNode.getElementsByTagName(TAG_CLASS);
                            int k = 0;
                            while (k < classNodes.getLength()) {
                                Element classNode = (Element)classNodes.item(k);
                                String className = classNode.getAttribute(ATTR_NAME);
                                if (className == null || className.isEmpty()) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class name attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                String classBundle = classNode.getAttribute(ATTR_BUNDLE);
                                if (classBundle == null || classBundle.isEmpty()) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class bundle attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                String classVersionValue = classNode.getAttribute(ATTR_VERSION);
                                if (classVersionValue == null || classVersionValue.isEmpty()) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class version attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                VersionRange classVersion = null;
                                try {
                                    classVersion = new VersionRange(classVersionValue);
                                }
                                catch (Exception e) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class version attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", e);
                                    break block36;
                                }
                                String classReplacementValue = classNode.getAttribute(ATTR_REPLACEMENT);
                                if (classReplacementValue == null || classReplacementValue.isEmpty()) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class replacement attribute in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                byte[] classReplacement = null;
                                try {
                                    InputStream is = this.fISProvider.getInputStream(classReplacementValue);
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    int n = 0;
                                    byte[] buffer = new byte[8192];
                                    while (-1 != (n = is.read(buffer))) {
                                        os.write(buffer, 0, n);
                                    }
                                    classReplacement = os.toByteArray();
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    Patcher.INSTANCE.logError("skipping filter with invalid class replacement attribute (replacement file [ " + classReplacementValue + " ] not found) in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                catch (IOException iOException) {
                                    Patcher.INSTANCE.logError("skipping filter with error while reading class replacement (replacement file [ " + classReplacementValue + " ] not found) in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                                    break block36;
                                }
                                HashSet<String> dynamicImports = new HashSet<String>();
                                String dynamicImportsValue = classNode.getAttribute(ATTR_DYNAMIC_IMPORTS);
                                if (dynamicImportsValue != null && !dynamicImportsValue.isEmpty()) {
                                    String[] dynamicImportsValueSplit;
                                    String[] stringArray = dynamicImportsValueSplit = dynamicImportsValue.split(",");
                                    int n = dynamicImportsValueSplit.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String dynamicImport = stringArray[n2];
                                        if (dynamicImport != null && !dynamicImport.trim().isEmpty()) {
                                            dynamicImports.add(dynamicImport.trim());
                                        }
                                        ++n2;
                                    }
                                }
                                classes.add(new Clazz(className, classBundle, classVersion, classReplacement, dynamicImports));
                                ++k;
                            }
                            if (classes.isEmpty()) {
                                Patcher.INSTANCE.logInfo("skipping filter with no class replacements in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                            } else {
                                filters.add(new Filter(filterOS, filterArch, filterWS, classes));
                            }
                        }
                        ++j;
                    }
                    if (filters.isEmpty()) {
                        Patcher.INSTANCE.logInfo("skipping patchset with no filters in patchset [ " + patchsetName + " ] in patchset container [ " + this.fContainer + " ]", null);
                    } else {
                        result.add(new Patchset(this.fContainer, patchsetName, Boolean.TRUE.equals(patchsetEnabled), filters));
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private void close() {
        if (this.fISProvider != null) {
            this.fISProvider.close();
        }
    }

    public static List<Patchset> parse(String container) {
        List<Patchset> result = Collections.emptyList();
        try (PatchsetParser parser = null;){
            try {
                parser = new PatchsetParser(container);
                result = parser.parse();
            }
            catch (IllegalArgumentException e) {
                Patcher.INSTANCE.logError(e.getMessage(), null);
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception e) {
                Patcher.INSTANCE.logError("exception while reading patchset container [ " + container + " ]", e);
                if (parser != null) {
                    parser.close();
                }
            }
        }
        return result;
    }

    private static interface InputStreamProvider {
        public InputStream getInputStream(String var1) throws FileNotFoundException;

        public void close();
    }
}

