/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p4nodes.LinearSegmentsNodePlacer;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public final class DotDebugUtil {
    private DotDebugUtil() {
    }

    public static void writeDebugGraph(LGraph lgraph, int slotIndex, String name) {
        try {
            Writer writer = DotDebugUtil.createWriter(lgraph, slotIndex, name);
            writer.write("digraph {\n");
            writer.write("    rankdir=LR;\n");
            DotDebugUtil.writeLayer(writer, -1, lgraph.getLayerlessNodes());
            int layerNumber = -1;
            for (Layer layer : lgraph) {
                DotDebugUtil.writeLayer(writer, ++layerNumber, layer.getNodes());
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException iOException) {}
    }

    public static void writeDebugGraph(LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        try {
            Writer writer = DotDebugUtil.createWriter(layeredGraph);
            writer.write("digraph {\n");
            Iterator<LinearSegmentsNodePlacer.LinearSegment> segmentIterator = segmentList.iterator();
            Iterator<List<LinearSegmentsNodePlacer.LinearSegment>> successorsIterator = outgoingList.iterator();
            while (segmentIterator.hasNext()) {
                LinearSegmentsNodePlacer.LinearSegment segment = segmentIterator.next();
                List<LinearSegmentsNodePlacer.LinearSegment> successors = successorsIterator.next();
                writer.write("  " + segment.hashCode() + "[label=\"" + segment + "\"]\n");
                for (LinearSegmentsNodePlacer.LinearSegment successor : successors) {
                    writer.write("  " + segment.hashCode() + "->" + successor.hashCode() + "\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void writeDebugGraph(LGraph layeredGraph, int layerIndex, List<OrthogonalRoutingGenerator.HyperNode> hypernodes, String debugPrefix, String label) {
        try {
            Writer writer = DotDebugUtil.createWriter(layeredGraph, layerIndex, debugPrefix, label);
            writer.write("digraph {\n");
            for (OrthogonalRoutingGenerator.HyperNode hypernode : hypernodes) {
                writer.write("  " + hypernode.hashCode() + "[label=\"" + hypernode.toString() + "\"]\n");
            }
            for (OrthogonalRoutingGenerator.HyperNode hypernode : hypernodes) {
                for (OrthogonalRoutingGenerator.Dependency dependency : hypernode.getOutgoing()) {
                    writer.write("  " + hypernode.hashCode() + "->" + dependency.getTarget().hashCode() + "[label=\"" + dependency.getWeight() + "\"]\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeLayer(Writer writer, int layerNumber, List<LNode> nodes) throws IOException {
        if (nodes.isEmpty()) {
            return;
        }
        int nodeNumber = -1;
        for (LNode node : nodes) {
            ++nodeNumber;
            writer.write("        " + ((Object)((Object)node)).hashCode());
            StringBuffer options = new StringBuffer();
            options.append("label=\"");
            if (node.getType() == LNode.NodeType.NORMAL) {
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                }
            } else {
                Object origin;
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                } else {
                    options.append("n_" + node.id + " ");
                }
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT && (origin = node.getProperty(InternalProperties.ORIGIN)) instanceof LNode) {
                    options.append("(" + ((LNode)((Object)origin)).toString() + ")");
                }
            }
            options.append("(" + layerNumber + "," + nodeNumber + ")\",");
            if (node.getType() == LNode.NodeType.NORMAL) {
                options.append("shape=box,");
            } else {
                options.append("style=\"rounded,filled\",");
                String color = node.getType().getColor();
                if (color != null) {
                    options.append("color=\"" + color + "\",");
                }
            }
            options.deleteCharAt(options.length() - 1);
            if (options.length() > 0) {
                writer.write("[" + options + "]");
            }
            writer.write(";\n");
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    writer.write("    " + ((Object)((Object)node)).hashCode() + " -> " + ((Object)((Object)edge.getTarget().getNode())).hashCode());
                    writer.write(";\n");
                }
            }
        }
    }

    private static Writer createWriter(LGraph layeredGraph) throws IOException {
        String path = DotDebugUtil.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DotDebugUtil.getDebugOutputFileBaseName(layeredGraph)) + "linseg-dep";
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    private static Writer createWriter(LGraph graph, int slotIndex, String name) throws IOException {
        String path = DotDebugUtil.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DotDebugUtil.getDebugOutputFileBaseName(graph)) + "fulldebug-slot" + String.format("%1$02d", slotIndex) + "-" + name;
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    private static Writer createWriter(LGraph layeredGraph, int layerIndex, String debugPrefix, String label) throws IOException {
        String path = DotDebugUtil.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DotDebugUtil.getDebugOutputFileBaseName(layeredGraph)) + debugPrefix + "-l" + layerIndex + "-" + label;
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    private static String getDebugOutputPath() {
        String path = System.getProperty("user.home");
        path = path.endsWith(File.separator) ? String.valueOf(path) + "tmp" + File.separator + "klay" : String.valueOf(path) + File.separator + "tmp" + File.separator + "klay";
        return path;
    }

    private static String getDebugOutputFileBaseName(LGraph graph) {
        return String.valueOf(Integer.toString(graph.hashCode() & 0xFFFF)) + "-";
    }
}

