/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.labels.LabelManagementOptions;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.ILayoutPhaseFactory;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.intermediate.NodePromotionStrategy;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.GraphCompactionStrategy;
import de.cau.cs.kieler.klay.layered.p5edges.EdgeRouterFactory;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

final class GraphConfigurator {
    private static final int INITIAL_CONFIGURATION_SIZE = 30;
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.NODE_MARGIN_CALCULATOR).addBeforePhase4(IntermediateProcessorStrategy.LABEL_AND_NODE_SIZE_PROCESSOR).addBeforePhase5(IntermediateProcessorStrategy.LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR);
    private static final IntermediateProcessingConfiguration LABEL_MANAGEMENT_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LABEL_MANAGEMENT_PROCESSOR);
    private final Map<Object, ILayoutPhase> phaseCache = Maps.newHashMap();
    private final Map<IntermediateProcessorStrategy, ILayoutProcessor> intermediateProcessorCache = Maps.newHashMap();
    private static final float MIN_EDGE_SPACING = 2.0f;

    GraphConfigurator() {
    }

    private void configureGraphProperties(LGraph lgraph) {
        Integer randomSeed;
        Direction direction;
        lgraph.checkProperties(new IProperty[]{InternalProperties.SPACING, InternalProperties.BORDER_SPACING, Properties.THOROUGHNESS, InternalProperties.ASPECT_RATIO});
        float spacing = ((Float)lgraph.getProperty(InternalProperties.SPACING)).floatValue();
        if (((Float)lgraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue() * spacing < 2.0f) {
            lgraph.setProperty((IProperty)Properties.EDGE_SPACING_FACTOR, Float.valueOf(2.0f / spacing));
        }
        if ((direction = (Direction)lgraph.getProperty(LayoutOptions.DIRECTION)) == Direction.UNDEFINED) {
            lgraph.setProperty(LayoutOptions.DIRECTION, LGraphUtil.getDirection(lgraph));
        }
        if ((randomSeed = (Integer)lgraph.getProperty(Properties.RANDOM_SEED)) == 0) {
            lgraph.setProperty(InternalProperties.RANDOM, new Random());
        } else {
            lgraph.setProperty(InternalProperties.RANDOM, new Random(randomSeed.intValue()));
        }
        Spacings spacings = new Spacings(lgraph);
        lgraph.setProperty(InternalProperties.SPACINGS, spacings);
    }

    public void prepareGraphForLayout(LGraph lgraph) {
        this.configureGraphProperties(lgraph);
        ILayoutPhase cycleBreaker = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(Properties.CYCLE_BREAKING));
        ILayoutPhase layerer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(Properties.NODE_LAYERING));
        ILayoutPhase crossingMinimizer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(Properties.CROSS_MIN));
        ILayoutPhase nodePlacer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(Properties.NODE_PLACER));
        ILayoutPhase edgeRouter = this.cachedLayoutPhase(EdgeRouterFactory.factoryFor((EdgeRouting)lgraph.getProperty(InternalProperties.EDGE_ROUTING)));
        IntermediateProcessingConfiguration intermediateProcessingConfiguration = IntermediateProcessingConfiguration.createEmpty();
        lgraph.setProperty(InternalProperties.CONFIGURATION, intermediateProcessingConfiguration);
        intermediateProcessingConfiguration.addAll(cycleBreaker.getIntermediateProcessingConfiguration(lgraph)).addAll(layerer.getIntermediateProcessingConfiguration(lgraph)).addAll(crossingMinimizer.getIntermediateProcessingConfiguration(lgraph)).addAll(nodePlacer.getIntermediateProcessingConfiguration(lgraph)).addAll(edgeRouter.getIntermediateProcessingConfiguration(lgraph)).addAll(this.getPhaseIndependentIntermediateProcessingConfiguration(lgraph));
        ArrayList algorithm = Lists.newArrayListWithCapacity((int)30);
        lgraph.setProperty(InternalProperties.PROCESSORS, algorithm);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_1));
        algorithm.add(cycleBreaker);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_2));
        algorithm.add(layerer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_3));
        algorithm.add(crossingMinimizer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_4));
        algorithm.add(nodePlacer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_5));
        algorithm.add(edgeRouter);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.AFTER_PHASE_5));
    }

    private ILayoutPhase cachedLayoutPhase(ILayoutPhaseFactory factory) {
        ILayoutPhase layoutPhase = this.phaseCache.get(factory);
        if (layoutPhase == null) {
            layoutPhase = factory.create();
            this.phaseCache.put(factory, layoutPhase);
        }
        return layoutPhase;
    }

    private List<ILayoutProcessor> getIntermediateProcessorList(IntermediateProcessingConfiguration configuration, IntermediateProcessingConfiguration.Slot slot) {
        Set<IntermediateProcessorStrategy> processors = configuration.getProcessors(slot);
        ArrayList<ILayoutProcessor> result = new ArrayList<ILayoutProcessor>(processors.size());
        for (IntermediateProcessorStrategy processor : processors) {
            ILayoutProcessor processorImpl = this.intermediateProcessorCache.get((Object)processor);
            if (processorImpl == null) {
                processorImpl = processor.create();
                this.intermediateProcessorCache.put(processor, processorImpl);
            }
            result.add(processorImpl);
        }
        return result;
    }

    private IntermediateProcessingConfiguration getPhaseIndependentIntermediateProcessingConfiguration(LGraph lgraph) {
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(BASELINE_PROCESSING_CONFIGURATION);
        if (((Boolean)lgraph.getProperty(Properties.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        } else {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) != null) {
            configuration.addAll(LABEL_MANAGEMENT_ADDITIONS);
        }
        switch ((Direction)lgraph.getProperty(LayoutOptions.DIRECTION)) {
            case LEFT: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.LEFT_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.LEFT_DIR_POSTPROCESSOR);
                break;
            }
            case DOWN: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.DOWN_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.DOWN_DIR_POSTPROCESSOR);
                break;
            }
            case UP: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.UP_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.UP_DIR_POSTPROCESSOR);
                break;
            }
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.COMMENT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        if (lgraph.getProperty(Properties.NODE_PROMOTION) != NodePromotionStrategy.NONE) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.NODE_PROMOTION);
        }
        if (lgraph.getProperty(Properties.POST_COMPACTION) != GraphCompactionStrategy.NONE && lgraph.getProperty(InternalProperties.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL) {
            configuration.addAfterPhase5(IntermediateProcessorStrategy.HORIZONTAL_COMPACTOR);
        }
        if (graphProperties.contains((Object)GraphProperties.PARTITIONS)) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.PARTITION_PREPROCESSOR);
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PARTITION_POSTPROCESSOR);
        }
        return configuration;
    }
}

