/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class IntermediateProcessingConfiguration {
    private List<Set<IntermediateProcessorStrategy>> strategy = new ArrayList<Set<IntermediateProcessorStrategy>>(Slot.SLOT_COUNT);

    private IntermediateProcessingConfiguration() {
        int i = 0;
        while (i < Slot.SLOT_COUNT) {
            this.strategy.add(EnumSet.noneOf(IntermediateProcessorStrategy.class));
            ++i;
        }
    }

    public static IntermediateProcessingConfiguration createEmpty() {
        return new IntermediateProcessingConfiguration();
    }

    public static IntermediateProcessingConfiguration fromExisting(IntermediateProcessingConfiguration existing) {
        IntermediateProcessingConfiguration configuration = new IntermediateProcessingConfiguration();
        configuration.addAll(existing);
        return configuration;
    }

    public Set<IntermediateProcessorStrategy> getProcessors(Slot slot) {
        return Collections.unmodifiableSet(this.strategy.get(slot.ordinal()));
    }

    public IntermediateProcessingConfiguration addBeforePhase1(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.BEFORE_PHASE_1.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addBeforePhase2(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.BEFORE_PHASE_2.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addBeforePhase3(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.BEFORE_PHASE_3.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addBeforePhase4(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.BEFORE_PHASE_4.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addBeforePhase5(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.BEFORE_PHASE_5.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addAfterPhase5(IntermediateProcessorStrategy processor) {
        this.strategy.get(Slot.AFTER_PHASE_5.ordinal()).add(processor);
        return this;
    }

    public IntermediateProcessingConfiguration addAll(Slot slot, Collection<IntermediateProcessorStrategy> processors) {
        if (processors != null) {
            this.strategy.get(slot.ordinal()).addAll(processors);
        }
        return this;
    }

    public IntermediateProcessingConfiguration addAll(IntermediateProcessingConfiguration operand) {
        if (operand != null) {
            int i = 0;
            while (i < Slot.SLOT_COUNT) {
                this.strategy.get(i).addAll((Collection<IntermediateProcessorStrategy>)operand.strategy.get(i));
                ++i;
            }
        }
        return this;
    }

    public void removeLayoutProcessor(Slot slot, IntermediateProcessorStrategy processor) {
        this.strategy.get(slot.ordinal()).remove((Object)processor);
    }

    public void clear() {
        for (Set<IntermediateProcessorStrategy> set : this.strategy) {
            set.clear();
        }
    }

    public static enum Slot {
        BEFORE_PHASE_1,
        BEFORE_PHASE_2,
        BEFORE_PHASE_3,
        BEFORE_PHASE_4,
        BEFORE_PHASE_5,
        AFTER_PHASE_5;

        public static final int SLOT_COUNT;

        static {
            SLOT_COUNT = AFTER_PHASE_5.ordinal() + 1;
        }
    }
}

