/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.klay.layered.DebugUtil;
import de.cau.cs.kieler.klay.layered.GraphConfigurator;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.components.ComponentsProcessor;
import de.cau.cs.kieler.klay.layered.compound.CompoundGraphPostprocessor;
import de.cau.cs.kieler.klay.layered.compound.CompoundGraphPreprocessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.ContentAlignment;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class KlayLayered {
    private GraphConfigurator graphConfigurator = new GraphConfigurator();
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private CompoundGraphPreprocessor compoundGraphPreprocessor = new CompoundGraphPreprocessor();
    private CompoundGraphPostprocessor compoundGraphPostprocessor = new CompoundGraphPostprocessor();

    public void doLayout(LGraph lgraph, IKielerProgressMonitor monitor) {
        IKielerProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 1.0f);
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        List<LGraph> components = this.componentsProcessor.split(lgraph);
        if (components.size() == 1) {
            this.layout(components.get(0), theMonitor);
        } else {
            float compWork = 1.0f / (float)components.size();
            for (LGraph comp : components) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.layout(comp, theMonitor.subTask(compWork));
            }
        }
        this.componentsProcessor.combine(components, lgraph);
        this.resizeGraph(lgraph);
        theMonitor.done();
    }

    public void doCompoundLayout(LGraph lgraph, IKielerProgressMonitor monitor) {
        IKielerProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 3.0f);
        this.compoundGraphPreprocessor.process(lgraph, theMonitor.subTask(1.0f));
        this.recursiveLayout(lgraph, theMonitor.subTask(1.0f));
        this.compoundGraphPostprocessor.process(lgraph, theMonitor.subTask(1.0f));
        theMonitor.done();
    }

    private void recursiveLayout(LGraph lgraph, IKielerProgressMonitor monitor) {
        monitor.begin("Recursive layout", 2.0f);
        if (!lgraph.getLayerlessNodes().isEmpty()) {
            float workPerSubgraph = 1.0f / (float)lgraph.getLayerlessNodes().size();
            for (LNode node : lgraph.getLayerlessNodes()) {
                LGraph nestedGraph = (LGraph)node.getProperty(InternalProperties.NESTED_LGRAPH);
                if (nestedGraph == null) continue;
                this.recursiveLayout(nestedGraph, monitor.subTask(workPerSubgraph));
                this.graphLayoutToNode(node, nestedGraph);
            }
            this.graphConfigurator.prepareGraphForLayout(lgraph);
            this.layout(lgraph, monitor);
        }
        this.resizeGraph(lgraph);
        monitor.done();
    }

    public TestExecutionState prepareLayoutTest(LGraph lgraph) {
        TestExecutionState state = new TestExecutionState();
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        if (this.componentsProcessor == null) {
            this.componentsProcessor = new ComponentsProcessor();
        }
        state.graphs = this.componentsProcessor.split(lgraph);
        return state;
    }

    public boolean isLayoutTestFinished(TestExecutionState state) {
        LGraph graph = state.graphs.get(0);
        List algorithm = (List)graph.getProperty(InternalProperties.PROCESSORS);
        return algorithm != null && state.step >= algorithm.size();
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor> phase, boolean inclusive, TestExecutionState state) {
        List algorithm = (List)state.graphs.get(0).getProperty(InternalProperties.PROCESSORS);
        boolean phaseExists = false;
        ListIterator algorithmIterator = algorithm.listIterator(state.step);
        int phaseIndex = state.step;
        while (algorithmIterator.hasNext() && !phaseExists) {
            if (((ILayoutProcessor)algorithmIterator.next()).getClass().equals(phase)) {
                phaseExists = true;
                if (!inclusive) continue;
                ++phaseIndex;
                continue;
            }
            ++phaseIndex;
        }
        if (!phaseExists) {
            System.err.println("Given processor " + phase + " not part of the remaining algorithm.");
        }
        algorithmIterator = algorithm.listIterator(state.step);
        while (state.step < phaseIndex) {
            this.layoutTest(state.graphs, (ILayoutProcessor)algorithmIterator.next());
            ++state.step;
        }
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor> phase, TestExecutionState state) {
        this.runLayoutTestUntil(phase, true, state);
    }

    public void runLayoutTestStep(TestExecutionState state) {
        if (this.isLayoutTestFinished(state)) {
            throw new IllegalStateException("Current layout test run has finished.");
        }
        List algorithm = (List)state.graphs.get(0).getProperty(InternalProperties.PROCESSORS);
        this.layoutTest(state.graphs, (ILayoutProcessor)algorithm.get(state.step));
        ++state.step;
    }

    public List<ILayoutProcessor> getLayoutTestConfiguration(TestExecutionState state) {
        return (List)state.graphs.get(0).getProperty(InternalProperties.PROCESSORS);
    }

    private void layout(LGraph lgraph, IKielerProgressMonitor monitor) {
        boolean monitorStarted = monitor.isRunning();
        if (!monitorStarted) {
            monitor.begin("Component Layout", 1.0f);
        }
        List algorithm = (List)lgraph.getProperty(InternalProperties.PROCESSORS);
        float monitorProgress = 1.0f / (float)algorithm.size();
        if (((Boolean)lgraph.getProperty(LayoutOptions.DEBUG_MODE)).booleanValue()) {
            System.out.println("KLay Layered uses the following " + algorithm.size() + " modules:");
            int i = 0;
            for (ILayoutProcessor processor : algorithm) {
                System.out.println("   Slot " + String.format("%1$02d", i++) + ": " + processor.getClass().getName());
            }
            int slotIndex = 0;
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                DebugUtil.writeDebugGraph(lgraph, slotIndex++, processor.getClass().getSimpleName());
                processor.process(lgraph, monitor.subTask(monitorProgress));
            }
            DebugUtil.writeDebugGraph(lgraph, slotIndex, "finished");
        } else {
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                processor.process(lgraph, monitor.subTask(monitorProgress));
            }
        }
        for (Layer layer : lgraph) {
            lgraph.getLayerlessNodes().addAll(layer.getNodes());
            layer.getNodes().clear();
        }
        for (LNode node : lgraph.getLayerlessNodes()) {
            node.setLayer(null);
        }
        lgraph.getLayers().clear();
        if (!monitorStarted) {
            monitor.done();
        }
    }

    private void layoutTest(List<LGraph> lgraphs, ILayoutProcessor processor) {
        for (LGraph graph : lgraphs) {
            processor.process(graph, (IKielerProgressMonitor)new BasicProgressMonitor());
        }
    }

    private void resizeGraph(LGraph lgraph) {
        Set sizeConstraint = (Set)lgraph.getProperty(LayoutOptions.SIZE_CONSTRAINT);
        Set sizeOptions = (Set)lgraph.getProperty(LayoutOptions.SIZE_OPTIONS);
        float borderSpacing = ((Float)lgraph.getProperty(InternalProperties.BORDER_SPACING)).floatValue();
        lgraph.getOffset().x += (double)borderSpacing;
        lgraph.getOffset().y += (double)borderSpacing;
        lgraph.getSize().x += (double)(2.0f * borderSpacing);
        lgraph.getSize().y += (double)(2.0f * borderSpacing);
        lgraph.setProperty(InternalProperties.BORDER_SPACING, Float.valueOf(0.0f));
        KVector calculatedSize = lgraph.getActualSize();
        KVector adjustedSize = new KVector(calculatedSize);
        if (sizeConstraint.contains(SizeConstraint.MINIMUM_SIZE)) {
            float minWidth = ((Float)lgraph.getProperty(LayoutOptions.MIN_WIDTH)).floatValue();
            float minHeight = ((Float)lgraph.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue();
            if (sizeOptions.contains(SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minWidth <= 0.0f) {
                    minWidth = 20.0f;
                }
                if (minHeight <= 0.0f) {
                    minHeight = 20.0f;
                }
            }
            adjustedSize.x = Math.max(calculatedSize.x, (double)minWidth);
            adjustedSize.y = Math.max(calculatedSize.y, (double)minHeight);
        }
        this.resizeGraphNoReallyIMeanIt(lgraph, calculatedSize, adjustedSize);
    }

    private void resizeGraphNoReallyIMeanIt(LGraph lgraph, KVector oldSize, KVector newSize) {
        Set contentAlignment = (Set)lgraph.getProperty(Properties.CONTENT_ALIGNMENT);
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                lgraph.getOffset().x += (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                lgraph.getOffset().x += newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                lgraph.getOffset().y += (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                lgraph.getOffset().y += newSize.y - oldSize.y;
            }
        }
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS) && (newSize.x > oldSize.x || newSize.y > oldSize.y)) {
            for (LNode node : lgraph.getLayerlessNodes()) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (extPortSide == PortSide.EAST) {
                    node.getPosition().x += newSize.x - oldSize.x;
                    continue;
                }
                if (extPortSide != PortSide.SOUTH) continue;
                node.getPosition().y += newSize.y - oldSize.y;
            }
        }
        LInsets insets = lgraph.getInsets();
        lgraph.getSize().x = newSize.x - insets.left - insets.right;
        lgraph.getSize().y = newSize.y - insets.top - insets.bottom;
    }

    private void graphLayoutToNode(LNode node, LGraph lgraph) {
        for (LNode childNode : lgraph.getLayerlessNodes()) {
            Object origin = childNode.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof LPort)) continue;
            LPort port = (LPort)((Object)origin);
            KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, childNode, port.getSize().x, port.getSize().y);
            port.getPosition().x = portPosition.x;
            port.getPosition().y = portPosition.y;
            port.setSide((PortSide)childNode.getProperty(InternalProperties.EXT_PORT_SIDE));
        }
        KVector actualGraphSize = lgraph.getActualSize();
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            node.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
            ((Set)node.getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.NON_FREE_PORTS);
            LGraphUtil.resizeNode(node, actualGraphSize, false, true);
        } else {
            LGraphUtil.resizeNode(node, actualGraphSize, true, true);
        }
    }

    public static class TestExecutionState {
        private List<LGraph> graphs;
        private int step;

        public List<LGraph> getGraphs() {
            return this.graphs;
        }

        public int getStep() {
            return this.step;
        }
    }
}

