/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.KlayLayered;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.transform.KGraphTransformer;

public final class LayeredLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "de.cau.cs.kieler.klay.layered";
    private final KlayLayered klayLayered = new KlayLayered();

    public void doLayout(KNode kgraph, IKielerProgressMonitor progressMonitor) {
        KGraphTransformer graphImporter = new KGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        KShapeLayout kgraphLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        if (kgraphLayout.getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.klayLayered.doCompoundLayout(layeredGraph, progressMonitor);
        } else {
            this.klayLayered.doLayout(layeredGraph, progressMonitor);
        }
        if (!progressMonitor.isCanceled()) {
            graphImporter.applyLayout(layeredGraph);
        }
    }

    public KlayLayered.TestExecutionState startLayoutTest(KNode kgraph) {
        KGraphTransformer graphImporter = new KGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        return this.klayLayered.prepareLayoutTest(layeredGraph);
    }

    public KlayLayered getLayoutAlgorithm() {
        return this.klayLayered;
    }
}

