/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.compaction.oned.algs;

import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.CompareFuzzy;
import de.cau.cs.kieler.klay.layered.compaction.oned.OneDimensionalCompactor;
import de.cau.cs.kieler.klay.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;

public class QuadraticConstraintCalculation
implements IConstraintCalculationAlgorithm {
    @Override
    public void calculateConstraints(OneDimensionalCompactor compactor) {
        for (CNode cNode : compactor.cGraph.cNodes) {
            cNode.constraints.clear();
        }
        for (CNode cNode1 : compactor.cGraph.cNodes) {
            for (CNode cNode2 : compactor.cGraph.cNodes) {
                if (cNode1 == cNode2 || cNode1.cGroup != null && cNode1.cGroup == cNode2.cGroup) continue;
                double spacing = compactor.direction.isHorizontal() ? compactor.spacingsHandler.getVerticalSpacing(cNode1, cNode2) : compactor.spacingsHandler.getHorizontalSpacing(cNode1, cNode2);
                if (cNode1 == cNode2.parentNode || !(cNode2.hitbox.x > cNode1.hitbox.x) && (cNode1.hitbox.x != cNode2.hitbox.x || !(cNode1.hitbox.width < cNode2.hitbox.width)) || !CompareFuzzy.gt(cNode2.hitbox.y + cNode2.hitbox.height + spacing, cNode1.hitbox.y) || !CompareFuzzy.lt(cNode2.hitbox.y, cNode1.hitbox.y + cNode1.hitbox.height + spacing)) continue;
                cNode1.constraints.add(cNode2);
            }
        }
    }
}

