/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import java.util.Collection;
import java.util.List;

abstract class AbstractGraphPlacer {
    AbstractGraphPlacer() {
    }

    public abstract void combine(List<LGraph> var1, LGraph var2);

    protected void moveGraphs(LGraph destGraph, Collection<LGraph> sourceGraphs, double offsetx, double offsety) {
        for (LGraph sourceGraph : sourceGraphs) {
            this.moveGraph(destGraph, sourceGraph, offsetx, offsety);
        }
    }

    protected void moveGraph(LGraph destGraph, LGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = sourceGraph.getOffset().add(offsetx, offsety);
        for (LNode node : sourceGraph.getLayerlessNodes()) {
            node.getPosition().add(graphOffset);
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    edge.getBendPoints().offset(graphOffset);
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayoutOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        junctionPoints.offset(graphOffset);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(graphOffset);
                    }
                }
            }
            destGraph.getLayerlessNodes().add(node);
            node.setGraph(destGraph);
        }
    }

    protected void offsetGraphs(Collection<LGraph> graphs, double offsetx, double offsety) {
        for (LGraph graph : graphs) {
            this.offsetGraph(graph, offsetx, offsety);
        }
    }

    protected void offsetGraph(LGraph graph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        for (LNode node : graph.getLayerlessNodes()) {
            node.getPosition().add(graphOffset);
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    edge.getBendPoints().offset(graphOffset);
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayoutOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        junctionPoints.offset(graphOffset);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(graphOffset);
                    }
                }
            }
        }
    }
}

