/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.components.AbstractGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.ComponentGroupGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.SimpleRowGraphPlacer;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class ComponentsProcessor {
    private final ComponentGroupGraphPlacer componentGroupGraphPlacer = new ComponentGroupGraphPlacer();
    private final SimpleRowGraphPlacer simpleRowGraphPlacer = new SimpleRowGraphPlacer();
    private AbstractGraphPlacer graphPlacer;

    public List<LGraph> split(LGraph graph) {
        ArrayList result;
        boolean compatiblePortConstraints;
        this.graphPlacer = this.simpleRowGraphPlacer;
        Boolean separateProperty = (Boolean)graph.getProperty(LayoutOptions.SEPARATE_CC);
        boolean separate = separateProperty == null || separateProperty != false;
        boolean extPorts = ((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS);
        PortConstraints extPortConstraints = (PortConstraints)graph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        boolean bl = compatiblePortConstraints = !extPortConstraints.isOrderFixed();
        if (separate && (compatiblePortConstraints || !extPorts)) {
            for (LNode node : graph.getLayerlessNodes()) {
                node.id = 0;
            }
            result = Lists.newArrayList();
            for (LNode node : graph.getLayerlessNodes()) {
                Pair<List<LNode>, Set<PortSide>> componentData = this.dfs(node, null);
                if (componentData == null) continue;
                LGraph newGraph = new LGraph();
                newGraph.copyProperties((IPropertyHolder)graph);
                newGraph.setProperty(InternalProperties.EXT_PORT_CONNECTIONS, (Set)componentData.getSecond());
                newGraph.getInsets().copy(graph.getInsets());
                for (LNode n : (List)componentData.getFirst()) {
                    newGraph.getLayerlessNodes().add(n);
                    n.setGraph(newGraph);
                }
                result.add(newGraph);
            }
            if (extPorts) {
                this.graphPlacer = this.componentGroupGraphPlacer;
            }
        } else {
            result = Arrays.asList(graph);
        }
        return result;
    }

    private Pair<List<LNode>, Set<PortSide>> dfs(LNode node, Pair<List<LNode>, Set<PortSide>> data) {
        if (node.id == 0) {
            node.id = 1;
            Pair mutableData = data;
            if (mutableData == null) {
                ArrayList component = Lists.newArrayList();
                EnumSet<PortSide> extPortSides = EnumSet.noneOf(PortSide.class);
                mutableData = new Pair((Object)component, extPortSides);
            }
            ((List)mutableData.getFirst()).add(node);
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                ((Set)mutableData.getSecond()).add((PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE));
            }
            for (LPort port1 : node.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    this.dfs(port2.getNode(), (Pair<List<LNode>, Set<PortSide>>)mutableData);
                }
            }
            return mutableData;
        }
        return null;
    }

    public void combine(List<LGraph> components, LGraph target) {
        this.graphPlacer.combine(components, target);
    }
}

