/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.klay.layered.components.AbstractGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.ComponentsCompactor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class SimpleRowGraphPlacer
extends AbstractGraphPlacer {
    private static final float SPACING_FACTOR = 1.6f;

    SimpleRowGraphPlacer() {
    }

    @Override
    public void combine(List<LGraph> components, LGraph target) {
        if (components.size() == 1) {
            LGraph source = components.get(0);
            if (source != target) {
                target.getLayerlessNodes().clear();
                this.moveGraph(target, source, 0.0, 0.0);
                target.copyProperties((IPropertyHolder)source);
                target.getInsets().copy(source.getInsets());
                target.getSize().x = source.getSize().x;
                target.getSize().y = source.getSize().y;
            }
            return;
        }
        if (components.isEmpty()) {
            target.getLayerlessNodes().clear();
            target.getSize().x = 0.0;
            target.getSize().y = 0.0;
            return;
        }
        assert (!components.contains(target));
        for (LGraph graph : components) {
            int priority = 0;
            for (LNode node : graph.getLayerlessNodes()) {
                priority += ((Integer)node.getProperty(InternalProperties.PRIORITY)).intValue();
            }
            graph.id = priority;
        }
        Collections.sort(components, new Comparator<LGraph>(){

            @Override
            public int compare(LGraph graph1, LGraph graph2) {
                int prio = graph2.id - graph1.id;
                if (prio == 0) {
                    double size1 = graph1.getSize().x * graph1.getSize().y;
                    double size2 = graph2.getSize().x * graph2.getSize().y;
                    return Double.compare(size1, size2);
                }
                return prio;
            }
        });
        LGraph firstComponent = components.get(0);
        target.getLayerlessNodes().clear();
        target.copyProperties((IPropertyHolder)firstComponent);
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)target.getProperty(InternalProperties.ASPECT_RATIO)).floatValue()));
        double spacing = 1.6f * ((Float)target.getProperty(InternalProperties.SPACING)).floatValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            KVector offset = graph.getOffset();
            this.offsetGraph(graph, xpos + offset.x, ypos + offset.y);
            offset.reset();
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        target.getSize().x = broadestRow;
        target.getSize().y = ypos + highestBox;
        double regularSpacing = ((Float)target.getProperty(InternalProperties.SPACING)).doubleValue();
        if (((Boolean)firstComponent.getProperty(Properties.COMPACT_COMPONENTS)).booleanValue()) {
            ComponentsCompactor compactor = new ComponentsCompactor();
            compactor.compact(components, target.getSize(), regularSpacing);
            for (LGraph h : components) {
                h.getOffset().reset().add(compactor.getOffset());
            }
            target.getSize().reset().add(compactor.getGraphSize());
        }
        this.moveGraphs(target, components, 0.0, 0.0);
    }
}

