/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.compound;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.compound.CrossHierarchyEdge;
import de.cau.cs.kieler.klay.layered.compound.CrossHierarchyEdgeComparator;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;

public class CompoundGraphPostprocessor
implements ILayoutProcessor {
    private static final Predicate<CrossHierarchyEdge> HAS_JUNCTION_POINTS_PREDICATE = new Predicate<CrossHierarchyEdge>(){

        public boolean apply(CrossHierarchyEdge chEdge) {
            KVectorChain jps = (KVectorChain)chEdge.getEdge().getProperty(LayoutOptions.JUNCTION_POINTS);
            return jps != null && !jps.isEmpty();
        }
    };

    @Override
    public void process(LGraph graph, IKielerProgressMonitor monitor) {
        monitor.begin("Compound graph postprocessor", 1.0f);
        boolean addUnnecessaryBendpoints = (Boolean)graph.getProperty(Properties.ADD_UNNECESSARY_BENDPOINTS);
        Multimap crossHierarchyMap = (Multimap)graph.getProperty(InternalProperties.CROSS_HIERARCHY_MAP);
        HashSet dummyEdges = Sets.newHashSet();
        for (LEdge origEdge : crossHierarchyMap.keySet()) {
            ArrayList crossHierarchyEdges = new ArrayList(crossHierarchyMap.get((Object)origEdge));
            Collections.sort(crossHierarchyEdges, new CrossHierarchyEdgeComparator(graph));
            LPort sourcePort = ((CrossHierarchyEdge)crossHierarchyEdges.get(0)).getActualSource();
            LPort targetPort = ((CrossHierarchyEdge)crossHierarchyEdges.get(crossHierarchyEdges.size() - 1)).getActualTarget();
            origEdge.getBendPoints().clear();
            LNode referenceNode = sourcePort.getNode();
            LGraph referenceGraph = LGraphUtil.isDescendant(targetPort.getNode(), referenceNode) ? (LGraph)referenceNode.getProperty(InternalProperties.NESTED_LGRAPH) : referenceNode.getGraph();
            KVectorChain junctionPoints = (KVectorChain)origEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
            if (Iterables.any(crossHierarchyEdges, HAS_JUNCTION_POINTS_PREDICATE)) {
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    origEdge.setProperty(LayoutOptions.JUNCTION_POINTS, junctionPoints);
                } else {
                    junctionPoints.clear();
                }
            } else if (junctionPoints != null) {
                origEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
            }
            KVector lastPoint = null;
            for (CrossHierarchyEdge chEdge : crossHierarchyEdges) {
                KVector offset = new KVector();
                LGraphUtil.changeCoordSystem(offset, chEdge.getGraph(), referenceGraph);
                LEdge ledge = chEdge.getEdge();
                KVectorChain bendPoints = new KVectorChain();
                bendPoints.addAllAsCopies(0, (Iterable)ledge.getBendPoints());
                bendPoints.offset(offset);
                KVector sourcePoint = new KVector(ledge.getSource().getAbsoluteAnchor());
                KVector targetPoint = new KVector(ledge.getTarget().getAbsoluteAnchor());
                sourcePoint.add(offset);
                targetPoint.add(offset);
                if (lastPoint != null) {
                    boolean yDiffEnough;
                    KVector nextPoint = bendPoints.isEmpty() ? targetPoint : (KVector)bendPoints.getFirst();
                    boolean xDiffEnough = Math.abs(lastPoint.x - nextPoint.x) > 0.001;
                    boolean bl = yDiffEnough = Math.abs(lastPoint.y - nextPoint.y) > 0.001;
                    if (!addUnnecessaryBendpoints && xDiffEnough && yDiffEnough || addUnnecessaryBendpoints && (xDiffEnough || yDiffEnough)) {
                        origEdge.getBendPoints().add((Object)sourcePoint);
                    }
                }
                origEdge.getBendPoints().addAll((Collection)bendPoints);
                lastPoint = bendPoints.isEmpty() ? sourcePoint : (KVector)bendPoints.getLast();
                KVectorChain ledgeJPs = (KVectorChain)ledge.getProperty(LayoutOptions.JUNCTION_POINTS);
                if (ledgeJPs != null && junctionPoints != null) {
                    KVectorChain jpCopies = new KVectorChain();
                    jpCopies.addAllAsCopies(0, (Iterable)ledgeJPs);
                    jpCopies.offset(offset);
                    junctionPoints.addAll((Collection)jpCopies);
                }
                if (chEdge.getActualTarget() == targetPort) {
                    if (targetPort.getNode().getGraph() != chEdge.getGraph()) {
                        offset = new KVector();
                        LGraphUtil.changeCoordSystem(offset, targetPort.getNode().getGraph(), referenceGraph);
                    }
                    origEdge.setProperty(InternalProperties.TARGET_OFFSET, offset);
                }
                ListIterator<LLabel> labelIterator = ledge.getLabels().listIterator();
                while (labelIterator.hasNext()) {
                    LLabel currLabel = (LLabel)((Object)labelIterator.next());
                    if (currLabel.getProperty(InternalProperties.ORIGINAL_LABEL_EDGE) != origEdge) continue;
                    LGraphUtil.changeCoordSystem(currLabel.getPosition(), ledge.getSource().getNode().getGraph(), referenceGraph);
                    labelIterator.remove();
                    origEdge.getLabels().add(currLabel);
                }
                dummyEdges.add(ledge);
            }
            origEdge.setSource(sourcePort);
            origEdge.setTarget(targetPort);
        }
        for (LEdge dummyEdge : dummyEdges) {
            dummyEdge.setSource(null);
            dummyEdge.setTarget(null);
        }
        monitor.done();
    }
}

