/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.compound;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.compound.CrossHierarchyEdge;
import de.cau.cs.kieler.klay.layered.compound.CrossHierarchyEdgeComparator;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CompoundGraphPreprocessor
implements ILayoutProcessor {
    private Multimap<LEdge, CrossHierarchyEdge> crossHierarchyMap;
    private final Map<LPort, LNode> dummyNodeMap = Maps.newHashMap();

    @Override
    public void process(LGraph graph, IKielerProgressMonitor monitor) {
        monitor.begin("Compound graph preprocessor", 1.0f);
        this.crossHierarchyMap = HashMultimap.create();
        this.transformHierarchyEdges(graph, null);
        this.moveLabelsAndRemoveOriginalEdges(graph);
        graph.setProperty(InternalProperties.CROSS_HIERARCHY_MAP, this.crossHierarchyMap);
        this.crossHierarchyMap = null;
        this.dummyNodeMap.clear();
        monitor.done();
    }

    private List<ExternalPort> transformHierarchyEdges(LGraph graph, LNode parentNode) {
        ArrayList containedExternalPorts = Lists.newArrayList();
        for (LNode node : graph.getLayerlessNodes()) {
            LGraph nestedGraph = (LGraph)node.getProperty(InternalProperties.NESTED_LGRAPH);
            if (nestedGraph == null) continue;
            List<ExternalPort> childPorts = this.transformHierarchyEdges(nestedGraph, node);
            containedExternalPorts.addAll(childPorts);
            this.processInsideSelfLoops(nestedGraph, node);
            if (!((Set)nestedGraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) continue;
            for (LPort port : node.getPorts()) {
                if (this.dummyNodeMap.get((Object)port) != null) continue;
                PortConstraints nodePortConstraints = (PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS);
                LNode dummyNode = LGraphUtil.createExternalPortDummy((IPropertyHolder)port, nodePortConstraints != null ? nodePortConstraints : PortConstraints.FREE, port.getSide(), -port.getNetFlow(), null, null, port.getSize(), (Direction)nestedGraph.getProperty(LayoutOptions.DIRECTION), nestedGraph);
                dummyNode.setProperty(InternalProperties.ORIGIN, (Object)port);
                this.dummyNodeMap.put(port, dummyNode);
                nestedGraph.getLayerlessNodes().add(dummyNode);
            }
        }
        ArrayList exportedExternalPorts = Lists.newArrayList();
        this.processInnerHierarchicalEdgeSegments(graph, parentNode, containedExternalPorts, exportedExternalPorts);
        if (parentNode != null) {
            this.processOuterHierarchicalEdgeSegments(graph, parentNode, exportedExternalPorts);
        }
        return exportedExternalPorts;
    }

    private void moveLabelsAndRemoveOriginalEdges(LGraph graph) {
        for (LEdge origEdge : this.crossHierarchyMap.keySet()) {
            if (origEdge.getLabels().size() > 0) {
                ArrayList edgeSegments = new ArrayList(this.crossHierarchyMap.get((Object)origEdge));
                Collections.sort(edgeSegments, new CrossHierarchyEdgeComparator(graph));
                ListIterator<LLabel> labelIterator = origEdge.getLabels().listIterator();
                while (labelIterator.hasNext()) {
                    LLabel currLabel = (LLabel)((Object)labelIterator.next());
                    int targetDummyEdgeIndex = -1;
                    switch ((EdgeLabelPlacement)currLabel.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT)) {
                        case HEAD: {
                            targetDummyEdgeIndex = edgeSegments.size() - 1;
                            break;
                        }
                        case CENTER: {
                            targetDummyEdgeIndex = edgeSegments.size() / 2;
                            break;
                        }
                        case TAIL: {
                            targetDummyEdgeIndex = 0;
                        }
                    }
                    if (targetDummyEdgeIndex == -1) continue;
                    CrossHierarchyEdge targetSegment = (CrossHierarchyEdge)edgeSegments.get(targetDummyEdgeIndex);
                    targetSegment.getEdge().getLabels().add(currLabel);
                    ((Set)targetSegment.getEdge().getSource().getNode().getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.END_LABELS);
                    ((Set)targetSegment.getEdge().getSource().getNode().getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.CENTER_LABELS);
                    labelIterator.remove();
                    currLabel.setProperty(InternalProperties.ORIGINAL_LABEL_EDGE, (Object)origEdge);
                }
            }
            origEdge.setSource(null);
            origEdge.setTarget(null);
        }
    }

    private void processInnerHierarchicalEdgeSegments(LGraph graph, LNode parentNode, List<ExternalPort> containedExternalPorts, List<ExternalPort> exportedExternalPorts) {
        ArrayList createdExternalPorts = Lists.newArrayList();
        for (ExternalPort externalPort : containedExternalPorts) {
            ExternalPort newExternalPort;
            ExternalPort currentExternalPort = null;
            if (externalPort.type == PortType.OUTPUT) {
                for (LEdge outEdge : externalPort.origEdges) {
                    LNode targetNode = outEdge.getTarget().getNode();
                    if (targetNode.getGraph() == graph) {
                        this.connectChild(graph, externalPort, outEdge, externalPort.dummyPort, outEdge.getTarget());
                        continue;
                    }
                    if (parentNode == null || LGraphUtil.isDescendant(targetNode, parentNode)) {
                        this.connectSiblings(graph, externalPort, containedExternalPorts, outEdge);
                        continue;
                    }
                    newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, outEdge, externalPort.dummyPort, PortType.OUTPUT, currentExternalPort);
                    if (newExternalPort != currentExternalPort) {
                        createdExternalPorts.add(newExternalPort);
                    }
                    if (!newExternalPort.exported) continue;
                    currentExternalPort = newExternalPort;
                }
                continue;
            }
            for (LEdge inEdge : externalPort.origEdges) {
                LNode sourceNode = inEdge.getSource().getNode();
                if (sourceNode.getGraph() == graph) {
                    this.connectChild(graph, externalPort, inEdge, inEdge.getSource(), externalPort.dummyPort);
                    continue;
                }
                if (parentNode == null || LGraphUtil.isDescendant(sourceNode, parentNode)) continue;
                newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, inEdge, externalPort.dummyPort, PortType.INPUT, currentExternalPort);
                if (newExternalPort != currentExternalPort) {
                    createdExternalPorts.add(newExternalPort);
                }
                if (!newExternalPort.exported) continue;
                currentExternalPort = newExternalPort;
            }
        }
        for (ExternalPort externalPort : createdExternalPorts) {
            if (!graph.getLayerlessNodes().contains((Object)externalPort.dummyNode)) {
                graph.getLayerlessNodes().add(externalPort.dummyNode);
            }
            if (!externalPort.exported) continue;
            exportedExternalPorts.add(externalPort);
        }
    }

    private void connectChild(LGraph graph, ExternalPort externalPort, LEdge origEdge, LPort sourcePort, LPort targetPort) {
        LEdge dummyEdge = this.createDummyEdge(graph, origEdge);
        dummyEdge.setSource(sourcePort);
        dummyEdge.setTarget(targetPort);
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(dummyEdge, graph, externalPort.type));
    }

    private void connectSiblings(LGraph graph, ExternalPort externalOutputPort, List<ExternalPort> containedExternalPorts, LEdge origEdge) {
        ExternalPort targetExternalPort = null;
        for (ExternalPort externalPort2 : containedExternalPorts) {
            if (externalPort2 == externalOutputPort || !externalPort2.origEdges.contains((Object)origEdge)) continue;
            targetExternalPort = externalPort2;
            break;
        }
        if (targetExternalPort == null) {
            return;
        }
        assert (targetExternalPort.type == PortType.INPUT);
        LEdge dummyEdge = this.createDummyEdge(graph, origEdge);
        dummyEdge.setSource(externalOutputPort.dummyPort);
        dummyEdge.setTarget(targetExternalPort.dummyPort);
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(dummyEdge, graph, externalOutputPort.type));
    }

    private void processOuterHierarchicalEdgeSegments(LGraph graph, LNode parentNode, List<ExternalPort> exportedExternalPorts) {
        ArrayList createdExternalPorts = Lists.newArrayList();
        for (LNode childNode : graph.getLayerlessNodes()) {
            for (LPort childPort : childNode.getPorts()) {
                ExternalPort currentExternalOutputPort = null;
                LEdge[] lEdgeArray = childPort.getOutgoingEdges().toArray(new LEdge[0]);
                int n = lEdgeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LEdge outEdge = lEdgeArray[n2];
                    if (!LGraphUtil.isDescendant(outEdge.getTarget().getNode(), parentNode)) {
                        ExternalPort newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, outEdge, outEdge.getSource(), PortType.OUTPUT, currentExternalOutputPort);
                        if (newExternalPort != currentExternalOutputPort) {
                            createdExternalPorts.add(newExternalPort);
                        }
                        if (newExternalPort.exported) {
                            currentExternalOutputPort = newExternalPort;
                        }
                    }
                    ++n2;
                }
                ExternalPort currentExternalInputPort = null;
                LEdge[] lEdgeArray2 = childPort.getIncomingEdges().toArray(new LEdge[0]);
                int n3 = lEdgeArray2.length;
                n = 0;
                while (n < n3) {
                    LEdge inEdge = lEdgeArray2[n];
                    if (!LGraphUtil.isDescendant(inEdge.getSource().getNode(), parentNode)) {
                        ExternalPort newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, inEdge, inEdge.getTarget(), PortType.INPUT, currentExternalInputPort);
                        if (newExternalPort != currentExternalInputPort) {
                            createdExternalPorts.add(newExternalPort);
                        }
                        if (newExternalPort.exported) {
                            currentExternalInputPort = newExternalPort;
                        }
                    }
                    ++n;
                }
            }
        }
        for (ExternalPort externalPort : createdExternalPorts) {
            if (!graph.getLayerlessNodes().contains((Object)externalPort.dummyNode)) {
                graph.getLayerlessNodes().add(externalPort.dummyNode);
            }
            if (!externalPort.exported) continue;
            exportedExternalPorts.add(externalPort);
        }
    }

    private void processInsideSelfLoops(LGraph nestedGraph, LNode node) {
        if (!((Boolean)node.getProperty(LayoutOptions.SELF_LOOP_INSIDE)).booleanValue()) {
            return;
        }
        for (LPort lport : node.getPorts()) {
            LEdge[] outEdges;
            LEdge[] lEdgeArray = outEdges = lport.getOutgoingEdges().toArray(new LEdge[lport.getOutgoingEdges().size()]);
            int n = outEdges.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isInsideSelfLoop;
                LEdge outEdge = lEdgeArray[n2];
                boolean isSelfLoop = outEdge.getTarget().getNode() == node;
                boolean bl = isInsideSelfLoop = isSelfLoop && (Boolean)outEdge.getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
                if (isInsideSelfLoop) {
                    LPort targetPort;
                    LNode targetExtPortDummy;
                    LPort sourcePort = outEdge.getSource();
                    LNode sourceExtPortDummy = this.dummyNodeMap.get((Object)sourcePort);
                    if (sourceExtPortDummy == null) {
                        sourceExtPortDummy = LGraphUtil.createExternalPortDummy((IPropertyHolder)sourcePort, PortConstraints.FREE, sourcePort.getSide(), -1, null, null, sourcePort.getSize(), (Direction)nestedGraph.getProperty(LayoutOptions.DIRECTION), nestedGraph);
                        sourceExtPortDummy.setProperty(InternalProperties.ORIGIN, (Object)sourcePort);
                        this.dummyNodeMap.put(sourcePort, sourceExtPortDummy);
                        nestedGraph.getLayerlessNodes().add(sourceExtPortDummy);
                    }
                    if ((targetExtPortDummy = this.dummyNodeMap.get((Object)(targetPort = outEdge.getTarget()))) == null) {
                        targetExtPortDummy = LGraphUtil.createExternalPortDummy((IPropertyHolder)targetPort, PortConstraints.FREE, targetPort.getSide(), 1, null, null, targetPort.getSize(), (Direction)nestedGraph.getProperty(LayoutOptions.DIRECTION), nestedGraph);
                        targetExtPortDummy.setProperty(InternalProperties.ORIGIN, (Object)targetPort);
                        this.dummyNodeMap.put(targetPort, targetExtPortDummy);
                        nestedGraph.getLayerlessNodes().add(targetExtPortDummy);
                    }
                    LEdge dummyEdge = this.createDummyEdge(nestedGraph, outEdge);
                    dummyEdge.setSource(sourceExtPortDummy.getPorts().get(0));
                    dummyEdge.setTarget(targetExtPortDummy.getPorts().get(0));
                    this.crossHierarchyMap.put((Object)outEdge, (Object)new CrossHierarchyEdge(dummyEdge, nestedGraph, PortType.OUTPUT));
                    ((Set)nestedGraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.EXTERNAL_PORTS);
                }
                ++n2;
            }
        }
    }

    private ExternalPort introduceHierarchicalEdgeSegment(LGraph graph, LNode parentNode, LEdge origEdge, LPort oppositePort, PortType portType, ExternalPort defaultExternalPort) {
        boolean mergeExternalPorts = (Boolean)graph.getProperty(Properties.MERGE_HIERARCHICAL_EDGES);
        LPort parentEndPort = null;
        if (portType == PortType.INPUT && origEdge.getSource().getNode() == parentNode) {
            parentEndPort = origEdge.getSource();
        } else if (portType == PortType.OUTPUT && origEdge.getTarget().getNode() == parentNode) {
            parentEndPort = origEdge.getTarget();
        }
        ExternalPort externalPort = defaultExternalPort;
        if (externalPort == null || !mergeExternalPorts || parentEndPort != null) {
            PortSide externalPortSide = PortSide.UNDEFINED;
            if (parentEndPort != null) {
                externalPortSide = parentEndPort.getSide();
            } else if (((PortConstraints)parentNode.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                PortSide portSide = externalPortSide = portType == PortType.INPUT ? PortSide.WEST : PortSide.EAST;
                if (externalPortSide == PortSide.EAST && oppositePort.getNode().getProperty(Properties.LAYER_CONSTRAINT) != LayerConstraint.LAST_SEPARATE) {
                    externalPortSide = PortSide.WEST;
                }
            }
            LNode dummyNode = this.createExternalPortDummy(graph, parentNode, portType, externalPortSide, origEdge);
            LEdge dummyEdge = this.createDummyEdge(parentNode.getGraph(), origEdge);
            if (portType == PortType.INPUT) {
                dummyEdge.setSource(dummyNode.getPorts().get(0));
                dummyEdge.setTarget(oppositePort);
            } else {
                dummyEdge.setSource(oppositePort);
                dummyEdge.setTarget(dummyNode.getPorts().get(0));
            }
            externalPort = new ExternalPort(origEdge, dummyEdge, dummyNode, (LPort)((Object)dummyNode.getProperty(InternalProperties.ORIGIN)), portType, parentEndPort == null);
        } else {
            externalPort.origEdges.add(origEdge);
            float thickness = Math.max(((Float)externalPort.newEdge.getProperty(LayoutOptions.THICKNESS)).floatValue(), ((Float)origEdge.getProperty(LayoutOptions.THICKNESS)).floatValue());
            externalPort.newEdge.setProperty(LayoutOptions.THICKNESS, Float.valueOf(thickness));
        }
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(externalPort.newEdge, graph, portType));
        return externalPort;
    }

    private LEdge createDummyEdge(LGraph graph, LEdge origEdge) {
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)origEdge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        return dummyEdge;
    }

    private LNode createExternalPortDummy(LGraph graph, LNode parentNode, PortType portType, PortSide portSide, LEdge edge) {
        LNode dummyNode = null;
        LPort outsidePort = portType == PortType.INPUT ? edge.getSource() : edge.getTarget();
        Direction layoutDirection = LGraphUtil.getDirection(graph);
        if (outsidePort.getNode() == parentNode) {
            dummyNode = this.dummyNodeMap.get((Object)outsidePort);
            if (dummyNode == null) {
                dummyNode = LGraphUtil.createExternalPortDummy((IPropertyHolder)outsidePort, (PortConstraints)parentNode.getProperty(LayoutOptions.PORT_CONSTRAINTS), portSide, portType == PortType.INPUT ? -1 : 1, null, null, outsidePort.getSize(), layoutDirection, graph);
                dummyNode.setProperty(InternalProperties.ORIGIN, (Object)outsidePort);
                this.dummyNodeMap.put(outsidePort, dummyNode);
            }
        } else {
            float thickness = ((Float)edge.getProperty(LayoutOptions.THICKNESS)).floatValue();
            dummyNode = LGraphUtil.createExternalPortDummy(CompoundGraphPreprocessor.createExternalPortProperties(graph), (PortConstraints)parentNode.getProperty(LayoutOptions.PORT_CONSTRAINTS), portSide, portType == PortType.INPUT ? -1 : 1, null, null, new KVector((double)thickness, (double)thickness), layoutDirection, graph);
            LPort dummyPort = this.createPortForDummy(dummyNode, parentNode, portType);
            dummyNode.setProperty(InternalProperties.ORIGIN, (Object)dummyPort);
            this.dummyNodeMap.put(dummyPort, dummyNode);
        }
        ((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.EXTERNAL_PORTS);
        if (((PortConstraints)graph.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            graph.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_SIDE);
        } else {
            graph.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
        return dummyNode;
    }

    private static IPropertyHolder createExternalPortProperties(LGraph graph) {
        MapPropertyHolder propertyHolder = new MapPropertyHolder();
        float offset = ((Float)graph.getProperty(InternalProperties.SPACING)).floatValue() * ((Float)graph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue() / 2.0f;
        propertyHolder.setProperty(InternalProperties.OFFSET, (Object)Float.valueOf(offset));
        return propertyHolder;
    }

    private LPort createPortForDummy(LNode dummyNode, LNode parentNode, PortType type) {
        LGraph graph = parentNode.getGraph();
        Direction layoutDirection = LGraphUtil.getDirection(graph);
        LPort port = new LPort();
        port.setNode(parentNode);
        switch (type) {
            case INPUT: {
                port.setSide(PortSide.fromDirection((Direction)layoutDirection).opposed());
                break;
            }
            case OUTPUT: {
                port.setSide(PortSide.fromDirection((Direction)layoutDirection));
            }
        }
        port.setProperty(InternalProperties.OFFSET, (Float)dummyNode.getProperty(InternalProperties.OFFSET));
        dummyNode.setProperty(InternalProperties.ORIGIN, (Object)port);
        this.dummyNodeMap.put(port, dummyNode);
        return port;
    }

    private static class ExternalPort {
        private List<LEdge> origEdges = Lists.newArrayList();
        private LEdge newEdge;
        private LNode dummyNode;
        private LPort dummyPort;
        private PortType type = PortType.UNDEFINED;
        private boolean exported;

        ExternalPort(LEdge origEdge, LEdge newEdge, LNode dummyNode, LPort dummyPort, PortType portType, boolean exported) {
            this.origEdges.add(origEdge);
            this.newEdge = newEdge;
            this.dummyNode = dummyNode;
            this.dummyPort = dummyPort;
            this.type = portType;
            this.exported = exported;
        }
    }
}

