/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.compound;

import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;

public class CrossHierarchyEdge {
    private LEdge newEdge;
    private LGraph graph;
    private PortType type;

    CrossHierarchyEdge(LEdge newEdge, LGraph graph, PortType type) {
        this.newEdge = newEdge;
        this.graph = graph;
        this.type = type;
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + ":" + this.newEdge.toString();
    }

    public LEdge getEdge() {
        return this.newEdge;
    }

    public LGraph getGraph() {
        return this.graph;
    }

    public PortType getType() {
        return this.type;
    }

    public LPort getActualSource() {
        if (this.newEdge.getSource().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
            return (LPort)((Object)this.newEdge.getSource().getNode().getProperty(InternalProperties.ORIGIN));
        }
        return this.newEdge.getSource();
    }

    public LPort getActualTarget() {
        if (this.newEdge.getTarget().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
            return (LPort)((Object)this.newEdge.getTarget().getNode().getProperty(InternalProperties.ORIGIN));
        }
        return this.newEdge.getTarget();
    }
}

