/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.compound;

import de.cau.cs.kieler.klay.layered.compound.CrossHierarchyEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.Comparator;

final class CrossHierarchyEdgeComparator
implements Comparator<CrossHierarchyEdge> {
    private final LGraph graph;

    CrossHierarchyEdgeComparator(LGraph graph) {
        this.graph = graph;
    }

    @Override
    public int compare(CrossHierarchyEdge edge1, CrossHierarchyEdge edge2) {
        if (edge1.getType() == PortType.OUTPUT && edge2.getType() == PortType.INPUT) {
            return -1;
        }
        if (edge1.getType() == PortType.INPUT && edge2.getType() == PortType.OUTPUT) {
            return 1;
        }
        int level1 = CrossHierarchyEdgeComparator.hierarchyLevel(edge1.getGraph(), this.graph);
        int level2 = CrossHierarchyEdgeComparator.hierarchyLevel(edge2.getGraph(), this.graph);
        if (edge1.getType() == PortType.OUTPUT) {
            return level2 - level1;
        }
        return level1 - level2;
    }

    private static int hierarchyLevel(LGraph nestedGraph, LGraph topLevelGraph) {
        LGraph currentGraph = nestedGraph;
        int level = 0;
        while (currentGraph != topLevelGraph) {
            LNode currentNode = (LNode)((Object)currentGraph.getProperty(InternalProperties.PARENT_LNODE));
            if (currentNode == null) {
                throw new IllegalArgumentException();
            }
            currentGraph = currentNode.getGraph();
            ++level;
        }
        return level;
    }
}

