/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.List;

public final class LEdge
extends LGraphElement {
    private static final long serialVersionUID = 1429497419118554817L;
    private KVectorChain bendPoints = new KVectorChain();
    private LPort source;
    private LPort target;
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)3);

    public String toString() {
        if (this.source != null && this.target != null) {
            return (Object)((Object)this.source.getNode()) + "(" + (Object)((Object)this.source) + ")->" + (Object)((Object)this.target.getNode()) + "(" + (Object)((Object)this.target) + ")";
        }
        return "e_" + ((Object)((Object)this)).hashCode();
    }

    public void reverse(LGraph layeredGraph, boolean adaptPorts) {
        LPort oldSource = this.getSource();
        LPort oldTarget = this.getTarget();
        this.setSource(null);
        this.setTarget(null);
        if (adaptPorts && ((Boolean)oldTarget.getProperty(InternalProperties.INPUT_COLLECT)).booleanValue()) {
            this.setSource(LGraphUtil.provideCollectorPort(layeredGraph, oldTarget.getNode(), PortType.OUTPUT, PortSide.EAST));
        } else {
            this.setSource(oldTarget);
        }
        if (adaptPorts && ((Boolean)oldSource.getProperty(InternalProperties.OUTPUT_COLLECT)).booleanValue()) {
            this.setTarget(LGraphUtil.provideCollectorPort(layeredGraph, oldSource.getNode(), PortType.INPUT, PortSide.WEST));
        } else {
            this.setTarget(oldSource);
        }
        for (LLabel label : this.labels) {
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)label.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT);
            if (labelPlacement == EdgeLabelPlacement.TAIL) {
                label.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, EdgeLabelPlacement.HEAD);
                continue;
            }
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            label.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, EdgeLabelPlacement.TAIL);
        }
        boolean reversed = (Boolean)this.getProperty(InternalProperties.REVERSED);
        this.setProperty(InternalProperties.REVERSED, !reversed);
        this.bendPoints = KVectorChain.reverse((KVectorChain)this.bendPoints);
    }

    public LPort getSource() {
        return this.source;
    }

    public void setSource(LPort source) {
        if (this.source != null) {
            this.source.getOutgoingEdges().remove((Object)this);
        }
        this.source = source;
        if (this.source != null) {
            this.source.getOutgoingEdges().add(this);
        }
    }

    public LPort getTarget() {
        return this.target;
    }

    public void setTarget(LPort target) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove((Object)this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.getIncomingEdges().add(this);
        }
    }

    public void setTargetAndInsertAtIndex(LPort targetPort, int index) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove((Object)this);
        }
        this.target = targetPort;
        if (this.target != null) {
            this.target.getIncomingEdges().add(index, this);
        }
    }

    public boolean isSelfLoop() {
        if (this.source == null || this.target == null) {
            return false;
        }
        return this.source.getNode() != null && this.source.getNode() == this.target.getNode();
    }

    public KVectorChain getBendPoints() {
        return this.bendPoints;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }
}

